<?php
session_start();
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

$produto    = (isset($_POST['produto'])) ? $_POST['produto'] : '';
$tamanho    = (isset($_POST['tamanho'])) ? $_POST['tamanho'] : 'M';
$quantidade = (isset($_POST['quantidade'])) ? $_POST['quantidade'] : 1;
$opcionais  = (isset($_POST['opcionais'])) ? trim($_POST['opcionais']) : '';
$pacotes    = (isset($_POST['pacotes'])) ? $_POST['pacotes'] : '';

$pdo  = Conexao::getInstance();
$sql = "SELECT mat_001, mat_003, mat_004, b_venda_tamanho, fracionado, ";
$sql .= "COALESCE(valor_tam_p, 0.00) AS valor_tam_p, COALESCE(valor_tam_m, 0.00) AS valor_tam_m, ";
$sql .= "COALESCE(valor_tam_g, 0.00) AS valor_tam_g, COALESCE(valor_tam_gg, 0.00) AS valor_tam_gg, COALESCE(valor_tam_extra, 0.00) AS valor_tam_extra,";
$sql .= "tamanho_padrao, cat_001, mat_021, b_peso_balanca ";
$sql .= "FROM materiais WHERE mat_001 = {$produto}";
$stm = $pdo->prepare($sql);
$stm->execute();
$produto = $stm->fetch(PDO::FETCH_OBJ);

$sql = "SELECT DISTINCT tamanho_p, tamanho_m, tamanho_g, tamanho_gg, tamanho_extra ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetch(PDO::FETCH_OBJ);

if (empty($_SESSION['PEDIDO'])):
    $_SESSION['PEDIDO'] = [];
    $_SESSION['CONTADOR'] = 0;
endif;

if ($produto->b_venda_tamanho && $tamanho == ''):
	$tamanho = '';
endif;

if ($produto->b_peso_balanca === true && $quantidade == ''):
	 $quantidade = 0;
endif;

$_SESSION['CONTADOR']++;
$indice = $_SESSION['CONTADOR'];
$aProduto = [
		'INDICE'		 => $indice,
		'ID_PRODUTO'     => $produto->mat_001,
		'COD_PRODUTO'    => $produto->mat_004,
		'DESCRICAO'      => $produto->mat_003,
		'VENDA_TAMANHO'  => $produto->b_venda_tamanho,
		'VALOR_P'        => $produto->valor_tam_p,
		'VALOR_M'        => $produto->valor_tam_m,
		'VALOR_G'        => $produto->valor_tam_g,
      'VALOR_GG'       => $produto->valor_tam_gg,
      'VALOR_EXTRA'    => $produto->valor_tam_extra,
		'TAMANHO_PADRAO' => $produto->tamanho_padrao,
		'QUANTIDADE'     => $quantidade,
		'TAMANHO_PEDIDO' => $tamanho,
		'ID_FRACIONADO'  => '',
		'IMPRESSORA'     => $produto->mat_021,
		'CATEGORIA'      => $produto->cat_001,
		'STATUS'		     => 'A',
		'TXT_OBSERVACAO' => '',
		'OPC_OBSERVACAO' => '',
      'PRODUTO_BALANCA' => $produto->b_peso_balanca,
      'FRACIONADO'      => $produto->fracionado,
		'OPCIONAL'		   => [],
		'PACOTE'		      => []
   ];
   
   
$_SESSION['PEDIDO'][$indice] = $aProduto;

if (!empty($opcionais)):
   $opcionais = explode(',', $opcionais);

   foreach($opcionais as $opcional):
      if (!empty(trim($opcional))):
         $item_opcional = ['ID' => trim($opcional), 'FRACAO' => '0', 'COMPLETO' => '0', 'DESCRICAO' => '', 'QUANTIDADE' => 1, 'VALOR' => 0];
         $_SESSION['PEDIDO'][$indice]['OPCIONAL'][] = $item_opcional;
      endif;
   endforeach;
endif;

if (!empty($pacotes)):
   foreach($pacotes as $item):
      if ($item['tipo'] == 'O'):
         $item_opcional = ['ID' => trim($item['id']), 'FRACAO' => '0', 'DESCRICAO' => $item['descricao'], 'COMPLETO' => '1', 'QUANTIDADE' => 1, 'VALOR' => trim($item['valor'])];
         $_SESSION['PEDIDO'][$indice]['OPCIONAL'][] = $item_opcional;
      else:
         $item_pacote = [
            'ID' => trim($item['id']), 
            'DESCRICAO' => trim($item['descricao']), 
            'TIPO' => trim($item['tipo']), 
            'VALOR' => trim($item['valor']),
            'QUANTIDADE' => 1,
            'TAMANHO' => 'M',
         ];

         $_SESSION['PEDIDO'][$indice]['PACOTE'][] = $item_pacote;
      endif;
   endforeach;
endif;

$html = '';
if (isset($_SESSION['PEDIDO'])):

	if ($_SESSION['PEDIDO'][$indice]['VENDA_TAMANHO']):
		switch ($_SESSION['PEDIDO'][$indice]['TAMANHO_PADRAO']) :
         case 'P':
            $descricao = $tamanhos->tamanho_p;
            break;
         case 'M':
            $descricao = $tamanhos->tamanho_m;
            break;
         case 'G':
            $descricao = $tamanhos->tamanho_g;
            break;
         case 'GG':
            $descricao = $tamanhos->tamanho_gg;
            break;
         case 'E':
            $descricao = $tamanhos->tamanho_extra;
            break;
         endswitch;
      endif;

    $html = "<div class='wide-card mdl-card mdl-shadow--4dp card-revisao item-".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
    $html .= "<div class='mdl-card__title'>";
    $html .= "<p class='text-left'>" . $_SESSION['PEDIDO'][$indice]['COD_PRODUTO'] .' - ' . strtoupper($_SESSION['PEDIDO'][$indice]['DESCRICAO']) . "</p>";
    if($_SESSION['PEDIDO'][$indice]['VENDA_TAMANHO']):
        $html .= "<select class='select-tamanho tamanho' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
        $html .= "<option value='".$_SESSION['PEDIDO'][$indice]['TAMANHO_PADRAO']."'>".$descricao."</option>";

        if ($produto->valor_tam_p > 0) $html .= "<option value='P'>{$tamanhos->tamanho_p}</option>";
        if ($produto->valor_tam_m > 0) $html .= "<option value='M'>{$tamanhos->tamanho_m}</option>";
        if ($produto->valor_tam_g > 0)   $html .= "<option value='G'>{$tamanhos->tamanho_g}</option>";
        if ($produto->valor_tam_gg > 0) $html .= "<option value='GG'>{$tamanhos->tamanho_gg}</option>";
        if ($produto->valor_tam_extra > 0) $html .= "<option value='E'>{$tamanhos->tamanho_extra}</option>";

        $html .= "</select>";
        $html .= "<select class='select-tamanho2 qtde-item' id='select-".$_SESSION['PEDIDO'][$indice]['INDICE']."' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
        
        if ($_SESSION['PEDIDO'][$indice]['QUANTIDADE'] > 0):
            switch ($_SESSION['PEDIDO'][$indice]['QUANTIDADE']) :
               case '1':
                  $qtde = '1';
                  $value = '1';
                  break;
               case '2':
                  $qtde = '2';
                  $value = '2';
                  break;
               case '0.500':
                  $qtde = '1/2';
                  $value = '0.500';
                  break;
               case '0.3333':
                  $qtde = '1/3';
                  $value = '0.3333';
                  break;
               case '0.250':
                  $qtde = '1/4';
                  $value = '0.250';
                  break;
               default:
                  $qtde = $produto['QUANTIDADE'];
            endswitch;
           $html .= "<option value='".$value."'>".$qtde."</option>";
        endif;
        
        $html .= "<option value='1'>1</option>";
        $html .= "<option value='2'>2</option>";
        $html .= "<option value='0.500'>1/2</option>";
        $html .= "<option value='0.3333'>1/3</option>";
        $html .= "<option value='0.250'>1/4</option>";
        $html .= "</select>";
    elseif($_SESSION['PEDIDO'][$indice]['PRODUTO_BALANCA']):
      $html .= "<div class='mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde-peso' data-upgraded=',MaterialTextfield'>";
      $html .= "<input class='mdl-textfield__input quantidade qtde-item' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."' type='number' id='quantidade-".$_SESSION['PEDIDO'][$indice]['INDICE']."' value='1'>";
      $html .= "</div>";
      $html .= "<span class='negrito text-blue'>Kg</span>";
    else:
	    $html .= "<a href='javascript:void(0)' class='btn-subtrai'  data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
	    $html .= "<i class='material-icons text-red md-48 btn-qtde'>remove_circle</i>";
	    $html .= "</a>";
	    $html .= "<div class='mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde' data-upgraded=',MaterialTextfield'>";
	    $html .= "<input class='mdl-textfield__input quantidade qtde-item' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."' type='number' id='quantidade-".$_SESSION['PEDIDO'][$indice]['INDICE']."' value='1'>";
	    $html .= "</div>";
	    $html .= "<a href='javascript:void(0)' class='btn-adiciona'  data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
	    $html .= "<i class='material-icons text-green md-48 btn-qtde'>add_circle</i>";
	    $html .= "</a>";
    endif;
    $html .= "</div>";

    $html .= "<div class = 'mdl-card__actions mdl-card--border  totalizador detalhe'>";
    $html .= "<a class = 'mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes btn-opcional' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
    $html .= "<i class='material-icons'>check</i> OPCIONAIS";
    $html .= "</a>";
    $html .= "<a class = 'mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes btn-observacao' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
    $html .= "<i class='material-icons'>assignment</i> OBSERVAÇÕES";
    $html .= "</a>";
    $html .= "<a class = 'mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-red btn-excluir' data-id='".$_SESSION['PEDIDO'][$indice]['INDICE']."'>";
    $html .= "<i class='material-icons'>clear</i> EXCLUIR";
    $html .= "</a>";
    $html .= "</div> ";
    $html .= "</div>";
endif;

echo json_encode(['status' => 1, 'total' => sizeof($_SESSION['PEDIDO']), 'html' => $html]);
