<?php
session_start();
require 'conexao.php';
require 'config.php';
require 'funcoes.php';


$json = (isset($_POST['pedido'])) ? $_POST['pedido'] : '' ;

if (empty($json)):
	echo json_encode(['status' => 0, 'mensagem' => 'Pedido não enviado !']);
	http_response_code(406);
	exit();
endif;

$pedido = json_decode($json);

$msg = '';
switch (json_last_error()) {
	case JSON_ERROR_DEPTH:
		$msg = ' - Maximum stack depth exceeded';
	break;
	case JSON_ERROR_STATE_MISMATCH:
		$msg = ' - Underflow or the modes mismatch';
	break;
	case JSON_ERROR_CTRL_CHAR:
		$msg = ' - Unexpected control character found';
	break;
	case JSON_ERROR_SYNTAX:
		$msg = ' - Syntax error, malformed JSON';
	break;
	case JSON_ERROR_UTF8:
		$msg = ' - Malformed UTF-8 characters, possibly incorrectly encoded';
	break;
}

if ($msg != ''):
	echo json_encode(['status' => 0, 'mensagem' => 'Erro no Pedido: ' . $msg]);
	http_response_code(406);
	exit();
endif;


// GRAVA LOG DO PEDIDO
$canal = ($pedido->tipo == 'M') ? 'MESA ' . $pedido->controle : 'COMANDA ' . $pedido->controle;
$venda_log = $pedido->venda;
$sql = "INSERT INTO log_mobile (venda, canal, id_atendente, atendente, json, data_hora)VALUES(:venda, :canal, :id_atendente, :atendente, :json, :data_hora)";
$stm = $pdo->prepare($sql);
$stm->bindValue(':venda', $venda_log);
$stm->bindValue(':canal', $canal);
$stm->bindValue(':id_atendente', $pedido->id_atendente);
$stm->bindValue(':atendente', $pedido->atendente);
$stm->bindValue(':json', $json);
$stm->bindValue(':data_hora', date('Y-m-d H:i:s'));
$retorno = $stm->execute();

$venda    = $pedido->venda;
$item_pai = $pedido->item_pai;
$pdo      = Conexao::getInstance();

try{

	$sql = "SELECT ven_001 FROM venda WHERE ven_001 = {$venda}";
	$stm = $pdo->prepare($sql);
	$stm->execute();
	$existeVenda = $stm->fetch(PDO::FETCH_OBJ);

	// SENÃO NÃO ACHAR UMA VENDA ABERTA, GERA UM NÚMERO PARA NOVA VENDA
	if ( !empty($existeVenda) ):
		$id_venda = $existeVenda->ven_001;
		
		$pdo->beginTransaction();

		// PERCORRE TODOS OS ITENS EM SESSION E PROCESSA A GRAVAÇÃO NO BANCO
		// foreach($_SESSION['PEDIDO'] as $itemPedido):
		foreach($pedido->itens as $itemPedido):

			$observacao = $itemPedido->observacao;

			if(!empty($itemPedido->opcional)):
				foreach($itemPedido->opcional as $opcional):
					$sql = 'SELECT valor FROM opcional WHERE id_opcional = :opcional';
					$stm = $pdo->prepare($sql);
					$stm->bindValue(':opcional', $opcional->id_opcional);
					$stm->execute();
					$item_opcional = $stm->fetch(PDO::FETCH_OBJ);

					$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional, unitario_fracao, imprime_completo, quantidade, valor)VALUES';
					$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional, :unitario_fracao, :imprime_completo, :quantidade, :valor)';
					$stm = $pdo->prepare($sql);
					$stm->bindValue(':id_venda', $id_venda);
					$stm->bindValue(':id_vendaitem', $item_pai);
					$stm->bindValue(':id_opcional', $opcional->id_opcional);
					$stm->bindValue(':unitario_fracao', (int) $opcional->fracao);
					$stm->bindValue(':imprime_completo', (int) $opcional->completo);
					$stm->bindValue(':quantidade', (int) ($opcional->quantidade * $itemPedido->quantidade));
					$stm->bindValue(':valor', (($opcional->quantidade * $itemPedido->quantidade) * $item_opcional->valor));
					$stm->execute();
					$opcional = $stm->fetch(PDO::FETCH_OBJ);
				endforeach;
			endif;

			if(!empty($itemPedido->pacote)):
				foreach($itemPedido->pacote as $pacote):

					$qtde = (int) $pacote->quantidade;
					
					if ( $pacote->tipo == 'O' && $pacote->valor > 0 ):
						$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional, unitario_fracao, imprime_completo, quantidade, valor)VALUES';
						$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional, :unitario_fracao, :imprime_completo, :quantidade, :valor)';
						$stm = $pdo->prepare($sql);
						$stm->bindValue( ':id_venda', $id_venda );
						$stm->bindValue( ':id_vendaitem', $item_pai );
						$stm->bindValue( ':id_opcional', $pacote->id );
						$stm->bindValue( ':unitario_fracao', (int) 0 );
						$stm->bindValue( ':imprime_completo', 0 );
						$stm->bindValue( ':quantidade', (int) $qtde );
						$stm->bindValue( ':valor', ( $qtde * $pacote->valor ) );
						$stm->execute();
					else:
						$sql = 'INSERT INTO vendaitem_pacote (id_venda, id_item, id_registro, tipo, descricao, quantidade, valor, tamanho)VALUES';
						$sql .= '(:id_venda, :id_item, :id_registro, :tipo, :descricao, :quantidade, :valor, :tamanho)';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':id_venda', $id_venda);
						$stm->bindValue(':id_item', $item_pai);
						$stm->bindValue(':id_registro', $pacote->id);
						$stm->bindValue(':tipo', $pacote->tipo);
						$stm->bindValue(':descricao', $pacote->descricao);
						$stm->bindValue(':quantidade', (int) $qtde );
						$stm->bindValue(':valor', $pacote->valor);
						$stm->bindValue(':tamanho', 'M');
						$stm->execute();
					endif;

				endforeach;
			endif;
		endforeach;

		// ATUALIZA PENDÊNCIA DE IMPRESSÃO
		$sql = "UPDATE vendaitem ";
		$sql .= "SET mobile_impressao = 'S', ite_011 = 'S', ite_008 = 'N', ite_006 = :observacao ";
		$sql .= "WHERE ven_001 = :venda AND ite_001 = :item AND origem_pedido = 'M'";
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':observacao', $observacao);
		$stm->bindValue(':venda', $id_venda);
		$stm->bindValue(':item', $item_pai);
		$retorno = $stm->execute();
	
		echo json_encode(['status' => 1]);
	
		$pdo->Commit();
	else:
		echo json_encode(['status' => 0]);
	endif;

}catch(Exception $erro){
	$pdo->rollBack();
	echo json_encode(['status' => 0, 'mensagem' => $erro->getMessage()]);
}

