<style>
.onoffswitch {
    position: relative; width: 100px;
    -webkit-user-select:none; -moz-user-select:none; -ms-user-select: none;
}
.onoffswitch-checkbox {
    display: none;
}
.onoffswitch-label {
    display: block; overflow: hidden; cursor: pointer;
    border: 2px solid #E3E3E3; border-radius: 30px;
}
.onoffswitch-inner {
    display: block; width: 200%; margin-left: -100%;
    transition: margin 0.3s ease-in 0s;
}
.onoffswitch-inner:before, .onoffswitch-inner:after {
    display: block; float: left; width: 50%; height: 30px; padding: 0; line-height: 30px;
    font-size: 12px; color: white; font-family: Trebuchet, Arial, sans-serif; font-weight: bold;
    box-sizing: border-box;
}
.onoffswitch-inner:before {
    content: "FRAÇÃO";
    padding-right: 35px;
    background-color: #3F51B5; color: #FFFFFF;
}
.onoffswitch-inner:after {
    content: "";
    padding-right: 10px;
    background-color: #FFFFFF; color: #666666;
    text-align: right;
}
.onoffswitch-switch {
    display: block; width: 30px; margin: 0px;
    background: #FFFFFF;
    position: absolute; top: 0; bottom: 0;
    right: 71px;
    border: 2px solid #E3E3E3; border-radius: 30px;
    transition: all 0.3s ease-in 0s; 
}
.onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-inner {
    margin-left: 0;
}
.onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-switch {
    right: 0px; 
}
</style>
<?php
session_start();
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

function ExisteIdInArray($termo, $arrayDados=[]){
	$retorno = false;
	
	foreach($arrayDados as $opcional):
		$retorno = ($termo == $opcional['ID']);

		if ($retorno) break;
	endforeach;

	return $retorno;
}

function ExisteIdFracaoInArray($termo, $arrayDados=[]){
	$retorno = false;
	
	foreach($arrayDados as $opcional):
		$retorno = ($termo == $opcional['ID'] && $opcional['FRACAO'] == '1');

		if ($retorno) break;
	endforeach;

	return $retorno;
}

$item  = (isset($_POST['item'])) ? $_POST['item'] : '';


if (isset($_SESSION['PEDIDO'])):
	
	$id_categoria = $_SESSION['PEDIDO'][$item]['CATEGORIA'];
	$pdo  = Conexao::getInstance();
	$sql = "SELECT o.id_opcional, descricao, valor ";
	$sql .= "FROM opcional o INNER JOIN opcional_categoria oc ON o.id_opcional = oc.id_opcional ";
	$sql .= "WHERE id_categoria = '{$id_categoria}' ORDER BY descricao";
	$stm = $pdo->prepare($sql);
	$stm->execute();
	$opcionais = $stm->fetchAll(PDO::FETCH_OBJ);
	
	if (!empty($opcionais)): ?>
	    <table class='mdl-data-table mdl-js-data-table mdl-data-table--selectable mdl-shadow--2dp'>
        <tbody>
            <?php foreach($opcionais as $opcional):
            	// if (isset($_SESSION['PEDIDO'][$item]['OPCIONAL']) && array_search($opcional->id_opcional, $_SESSION['PEDIDO'][$item]['OPCIONAL']) !== FALSE):
				if (isset($_SESSION['PEDIDO'][$item]['OPCIONAL']) && ExisteIdInArray($opcional->id_opcional, $_SESSION['PEDIDO'][$item]['OPCIONAL'])):
					$checked = 'checked';
            	else:
					$checked = '';
				endif;
				
				if (isset($_SESSION['PEDIDO'][$item]['OPCIONAL']) && ExisteIdFracaoInArray($opcional->id_opcional, $_SESSION['PEDIDO'][$item]['OPCIONAL'])):
					$checked_fracao = 'checked';
            	else:
					$checked_fracao = '';
				endif;
           	    ?>
	            <tr>
		           <td width='10'>
		           <input type='checkbox' id='checkbox<?=$opcional->id_opcional?>' class='ckb-opcional' value='<?=$opcional->id_opcional?>' <?=$checked?> >
		           </td>
		           <td class = 'mdl-data-table__cell--non-numeric'><label for='checkbox<?=$opcional->id_opcional?>'><?=strtoupper($opcional->descricao)?> (<?=number_format($opcional->valor, 2, ',', '.')?>)</label></td>
				   <td>
				   		<div class="onoffswitch">
							<input type="checkbox" <?=$checked_fracao?> value='<?=$opcional->id_opcional?>' name="onoffswitch" class="onoffswitch-checkbox ckb-fracao" id="ckb-fracao-<?=$opcional->id_opcional?>">
							<label class="onoffswitch-label" for="ckb-fracao-<?=$opcional->id_opcional?>">
								<span class="onoffswitch-inner"></span>
								<span class="onoffswitch-switch"></span>
							</label>
						</div>
				   </td>
	       	    </tr>
       	    <?php endforeach; ?>
        </tbody>
        </table>
	<?php endif; ?>
	
<?php endif; ?>