<?php
session_start();
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

$termo = (isset($_POST['termo'])) ? strtoupper($_POST['termo']) : '';
$codigo = (isset($_POST['codigo'])) ? strtoupper($_POST['codigo']) : '';

$pdo  = Conexao::getInstance();
$sql = "SELECT mat_001, mat_003, mat_004, b_venda_tamanho, valor_tam_p, valor_tam_m, valor_tam_g, ";
$sql .="valor_tam_gg, valor_tam_extra, tamanho_padrao, descricao, c.cat_002, mat_008 ";
$sql .= "FROM materiais m INNER JOIN categoria c ON m.cat_001 = c.cat_001 ";
$sql .= "WHERE m.sit_001 = 4 AND fracionado AND mat_001 <> {$codigo}";

if (!empty($termo)):
	$sql .= " AND (mat_003 LIKE '%{$termo}%' OR mat_004 LIKE '%{$termo}%') ";
endif;

switch (CAMPO_ORDENACAO_PRODUTO) :
	case 'CODIGO':
		$sql .= "ORDER BY c.cat_002 ASC, mat_004";
		break;
	case 'DESCRICAO':
		$sql .= "ORDER BY c.cat_002 ASC, mat_003";
		break;
	default:
		$sql .= "ORDER BY c.cat_002 ASC, mat_003";
		break;
endswitch;

switch (TIPO_ORDENACAO_PRODUTO) :
	case 'ASC':
		$sql .= " ASC";
		break;
	case 'DESC':
		$sql .= " DESC";
		break;
	default:
		$sql .= " ASC";
		break;
endswitch;

$stm = $pdo->prepare($sql);
$stm->execute();
$produtos = $stm->fetchAll(PDO::FETCH_OBJ);

$sql = "SELECT DISTINCT tamanho_p, tamanho_m, tamanho_g, tamanho_gg, tamanho_extra ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetch(PDO::FETCH_OBJ);

foreach($produtos as $produto):

	$valor_unitario = '';
	if ($produto->b_venda_tamanho):

		if (!empty($produto->valor_tam_p)):
			$valor_unitario .= substr($tamanhos->tamanho_p, 0, 3) . '. ' . number_format($produto->valor_tam_p, 2, ',', '.');
		endif;

		if (!empty($produto->valor_tam_m)):
			$valor_unitario .= ' / ' . substr($tamanhos->tamanho_m, 0, 3) . '. ' . number_format($produto->valor_tam_m, 2, ',', '.');
		endif;

		if (!empty($produto->valor_tam_g)):
			$valor_unitario .= ' / ' . substr($tamanhos->tamanho_g, 0, 3) . '. ' . number_format($produto->valor_tam_g, 2, ',', '.');
		endif;

		if (!empty($produto->valor_tam_gg)):
			$valor_unitario .= ' / ' . substr($tamanhos->tamanho_gg, 0, 3) . '. ' . number_format($produto->valor_tam_gg, 2, ',', '.');
		endif;

		if (!empty($produto->valor_tam_extra)):
			$valor_unitario .= ' / ' . substr($tamanhos->tamanho_extra, 0, 3) . '. ' . number_format($produto->valor_tam_extra, 2, ',', '.');
		endif;
	else:
		$valor_unitario = 'R$ ' . number_format($produto->mat_008, 2, ',', '.');
	endif;
	?>

	<a href="javascript:void(0)" data-id="<?=$produto->mat_001?>" data-nome="<?=strtoupper($produto->mat_003)?>" class="container-produto mdl-shadow--6dp">
		<div class = "wide-card mdl-card mdl-shadow--4dp mdl-card--border card-produto">
			<div class = "mdl-card__actions titulo-produto">
			<p class="text-left text-black"><?=$produto->mat_004?> - <?=strtoupper($produto->mat_003)?></p>
			<p class="text-left text-gray"><?=$produto->descricao?></p>
			<p class="text-red"><?=$valor_unitario?></p>
			</div>
		</div>
	</a>
<?php endforeach; ?>
