<?php
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

$comanda = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$cliente = (isset($_GET['cliente'])) ? $_GET['cliente'] : '' ;
$pdo     = Conexao::getInstance();

$sql = "SELECT i.ite_001, i.mat_001, i.ite_002, m.mat_003, i.ite_011, i.ite_005, i.ven_001 ";
$sql .= "FROM venda v INNER JOIN vendaitem i ON v.ven_001 = i.ven_001 ";
$sql .= "INNER JOIN materiais m ON m.mat_001 = i.mat_001 ";
$sql .= "WHERE v.ven_024 = 'C' AND i.sit_001 = 4 AND v.sit_001 = 8 ";

if (empty($comanda)):
	$sql .= "AND v.ven_027 = '{$cliente}' ";
else:
	$sql .= "AND v.ven_026 = {$comanda} ";
endif;

$sql .= "ORDER BY i.ite_001 ";
$stm = $pdo->prepare($sql);
$stm->execute();
$itens = $stm->fetchAll(PDO::FETCH_OBJ);

$sql = "SELECT ven_009 as subtotal,  ((ven_009 * 0.10) + ven_009) as total, (ven_009 * 0.10) as servico, ven_001 ";
$sql .= "FROM venda ";
$sql .= "WHERE ven_024 = 'C' AND sit_001 = 8 ";

if (empty($comanda)):
	$sql .= "AND ven_027 = '{$cliente}' ";
else:
	$sql .= "AND ven_026 = {$comanda} ";
endif;

$stm = $pdo->prepare($sql);
$stm->execute();
$totalizadores = $stm->fetch(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">
	  
	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	  	<div class="mdl-cell mdl-cell--12-col mdl-cell--16-col-phone">
		  	<a href='produto.php?comanda=<?=$comanda?>&cliente=<?=$cliente?>' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored">
				  Adicionar Item 
				  <i class="material-icons">add_circle</i>
		    </a>
		    <a href='javascript:void(0)' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-blue btn-imprimir">
				  Imprimir 
				  <i class="material-icons">print</i>
		    </a>

	  		<h4>Itens da Comanda: <?= (empty($cliente)) ? $comanda : $cliente; ?></h4>
	  		<?php if ($itens):?>
		  		<?php foreach($itens as $item):
		  			$back = ($item->ite_011 == 'S') ? 'fundo-red' : '' ;
		  			?>
					<div class="mdl-card mdl-shadow--4dp <?=$back?>">
					   <div class="mdl-card__title">
					    <h4 class="mdl-card__supporting-text">
					    <?=number_format($item->ite_002, 3, ',', '.')?> - <?=$item->mat_003?></h4>
					    <a href="detalhe.php?comanda=<?=$comanda?>&item=<?=$item->ite_001?>&cliente=<?=$cliente?>">
					    	<i class="material-icons green">search</i>
					    </a> 
					  </div>
					  <span>Valor R$ <?=number_format($item->ite_005, 2, ',', '.')?></span>
					</div><br>
				<?php endforeach;?>	

				<div class="mdl-card mdl-shadow--4dp fundo-cinza">
				   <div class="mdl-card__title">
				    <h4 class="mdl-card__supporting-text"><strong>TOTALIZADORES</strong></h4>
				  </div>
				  <span>
				  	<strong>SUB-TOTAL:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;R$ <?=number_format( $totalizadores->subtotal, 2, ',', '.')?>
				  </span>
				  <span>
				  	<strong>+ TX. de SERVIÇO:</strong> 
				  	<?php if (TAXA_MESA):?> 
				  		R$ <?=number_format( $totalizadores->servico, 2, ',', '.')?>
				  	<?php else:?>
				  		R$ 0,00
				  	<?php endif;?>
				  </span>
				  <span>
				  	<strong>= TOTAL:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				  		<?php if (TAXA_COMANDA):?> 
				  			R$ <?=number_format( $totalizadores->total, 2, ',', '.')?>
					  	<?php else:?>
					  		R$ <?=number_format( $totalizadores->subtotal, 2, ',', '.')?>
					  	<?php endif;?>
				  	</strong>
				  </span>
				</div><br>
			<?php else: ?>	
	  			<p>Ainda não foram adicionados itens.</p>
	  		<?php endif; ?>
		</div>
	  </div>
	</div>

    <!-- Modal de Exclusão -->
	<dialog class="mdl-dialog modal-excluir">
	    <div class="mdl-dialog__content">
	      <p>
	      <h5>Excluir item?</h5>
	      <p><span class="produto red"></span></p>
	      </p>
	    </div>
	    <div class="mdl-dialog__actions">
	      <input type="hidden" id="venda" value="">
	      <input type="hidden" id="item" value="">
	      <button type="button" class="mdl-button close">Cancelar</button>
	      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored excluir btn-red">Excluir</button>
	    </div>
	</dialog>

	<!-- Modal de Impressãp -->
	<dialog class="mdl-dialog modal-impressao">
	    <div class="mdl-dialog__content">
	      <p>
	      <h5>Deseja imprimir os itens pendentes?</h5>
	      <p><span class="produto red"></span></p>
	      </p>
	    </div>
	    <div class="mdl-dialog__actions">
	      <input type="hidden" id="venda" value="">
	      <input type="hidden" id="item" value="">
	      <button type="button" class="mdl-button closeImpressao">Cancelar</button>
	      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored imprimir btn-blue">Imprimir</button>
	    </div>
	</dialog>

	<script src="js/jquery.min.js"></script>
	<script>

	if (localStorage.hasOwnProperty('carrinho')){
        localStorage.removeItem('carrinho')
	}

    var dialogExcluir = document.querySelector('.modal-excluir')
	if (! dialogExcluir.showModal) {
       dialogPolyfill.registerDialog(dialogExcluir);
    }

    var dialogImprimir = document.querySelector('.modal-impressao')
	if (! dialogImprimir.showModal) {
       dialogPolyfill.registerDialog(dialogImprimir);
    }

    jQuery(document).ready(function($) {	

    	$('.btn-excluir').click(function(event) {
    		var item    = $(this).attr('data-item');
    		var produto = $(this).attr('data-produto');
    		var venda   = $(this).attr('data-venda');

    		$('.produto').html(produto);
    		$('.item').html(item);
    		$('#item').val(item);
    		$('#venda').val(venda);

		    dialogExcluir.showModal();
    	});

    	$('.close').click(function(event) {
    		dialogExcluir.close();
    	});

    	$('.excluir').click(function(event) { 
    		var item = $('#item').val();
    		var venda = $('#venda').val();

    		$.ajax({
    			url: 'excluir_item.php',
    			type: 'POST',
    			dataType: 'JSON',
    			data: {id_venda: venda, item: item},
    			beforeSend: function(){
    				$('.excluir').html('Excluindo ...');
    			},
    			success: function(retorno){
    				if (retorno.status == '1'){
    					window.location = 'comanda.php?comanda=<?=$comanda?>&cliente=<?=$cliente?>';
    				}else{
    					alert(retorno.erro);
    				}
    			}
    		});			
    	});


    	$('.btn-imprimir').click(function(event) {
		    dialogImprimir.showModal();
    	});

    	$('.closeImpressao').click(function(event) {
    		dialogImprimir.close();
    	});

    	$('.imprimir').click(function(event) { 
    		$.ajax({
    			url: 'enviar_impressao.php',
    			type: 'POST',
    			dataType: 'JSON',
    			data: {enviar: true, venda: <?=$totalizadores->ven_001?>},
    			beforeSend: function(){
    				$('.imprimir').html('Enviando ...');
    			},
    			success: function(retorno){
    				if (retorno.status == '1'){
    					window.location = 'comanda.php?comanda=<?=$comanda?>&cliente=<?=$cliente?>';
    				}else{
    					alert(retorno.erro);
    				}
    			}
    		});			
    	});


    });
  </script>
</body>
</html>
