<?php
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

$pdo  = Conexao::getInstance();

$sql = "SELECT ven_001, ven_027, ven_026 FROM venda WHERE sit_001 = 8 AND ven_024 = 'C' ORDER BY ven_026";
$stm = $pdo->prepare($sql);
$stm->execute();
$comandas = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">

	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	  	<a href='javascript:void(0)' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-blue center-block">
			  Adicionar Comanda 
			  <i class="material-icons">add_circle</i>
	    </a>
	    <hr>
	    <?php foreach($comandas as $comanda):
	    	$n_comanda = $comanda->ven_026;
	    	$sql = "SELECT ven_009 as subtotal,  ((ven_009 * 0.10) + ven_009) as total, (ven_009 * 0.10) as servico, ven_001 ";
			$sql .= "FROM venda ";
			$sql .= "WHERE ven_026 = {$n_comanda} AND ven_024 = 'C' AND sit_001 = 8 ";
			$stm = $pdo->prepare($sql);
			$stm->execute();
			$totalizadores = $stm->fetch(PDO::FETCH_OBJ);
	    	?>
	    	<div class="mdl-card mdl-shadow--4dp comanda">
			   <div class="mdl-card__title">
			    <h4 class="mdl-card__supporting-text">
			    Comanda <?=$comanda->ven_026?> | <?=$comanda->ven_027?>
			    </h4>
			    <a href="comanda.php?comanda=<?=$comanda->ven_026?>&cliente=<?=$comanda->ven_027?>">
			    	<i class="material-icons green">search</i>
			    </a> 
			  </div>
			  <span>
			  	<?php if (TAXA_COMANDA):?> 
				  		Valor R$ <?=number_format( $totalizadores->total, 2, ',', '.')?>
					<?php else:?>
					  	Valor R$ <?=number_format( $totalizadores->subtotal, 2, ',', '.')?>
					<?php endif;?>
			  </span>
			</div>
    	<?php endforeach;?>
	  </div>
	</div>
	<dialog class="mdl-dialog">
		<form>
		    <div class="mdl-dialog__content">
		      <p>
		      <h5>Abrir Comanda</h5>
		      <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
			    <input class="mdl-textfield__input" type="text" id="cliente" required>
			    <label class="mdl-textfield__label" for="sample3">Nome do Cliente (* Obrigatório)</label>
			  </div>
		      </p>
		    </div>
		    <div class="mdl-dialog__actions">
		      <button type="button" class="mdl-button close">Cancelar</button>
		      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored pedido">Lançar Item</button>
		    </div>
		</form>
	</dialog>
	<script src="js/jquery.min.js"></script>
	<script>

	if (localStorage.hasOwnProperty('carrinho')){
        localStorage.removeItem('carrinho')
	}

    var dialog = document.querySelector('dialog')
	if (! dialog.showModal) {
       dialogPolyfill.registerDialog(dialog);
    }

    jQuery(document).ready(function($) {	

    	$('.mdl-js-button').click(function(event) {
		    dialog.showModal();
    	});

    	$('.close').click(function(event) {
    		dialog.close();
    	});

    	$('.pedido').click(function(event) {
    		var cliente = $('#cliente').val();

    		if (cliente != ''){
	    		dialog.close();
	    		window.location = 'comanda.php?cliente=' + cliente;
    		}
    	});

    });
  </script>
</body>
</html>