﻿<?php
session_start();

require 'conexao.php';
require 'config.php';
require 'includes/inc_verifica_caixa.php';
require 'includes/limpar_session.php';

$pdo  = Conexao::getInstance();	
$sql = "SELECT ven_001, ven_027, ven_026 FROM venda WHERE sit_001 IN (8,21)  AND ven_024 = 'C' ORDER BY ven_026";
$stm = $pdo->prepare($sql);
$stm->execute();
$comandas = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
  <?php require 'includes/inc_head.php'; ?>
</head>
<body>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title">Comanda Eletrônica</span>      
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?> 

  	  <main class="mdl-layout__content">
        <div class="block-center">
          <p class="linha-5"></p>
          <button class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored adicionar" data-upgraded=",MaterialButton">
            <i class="material-icons">add_circle</i> 
            Adicionar Comanda
          </button>
        </div>

        <?php foreach($comandas as $comanda):
            $n_comanda = $comanda->ven_026;
            $link = 'pedido.php?tipo=C&comanda='.$comanda->ven_026.'&cliente='.$comanda->ven_027.'&venda='.$comanda->ven_001;

            $sql = "SELECT sit_001 FROM venda WHERE sit_001 = 21 AND ven_026 = " . $comanda->ven_026;
            $stm = $pdo->prepare($sql);
            $stm->execute();
            $venda = $stm->fetchAll(PDO::FETCH_OBJ);
            $back  = (empty($venda)) ? '' : 'btn-yellow';
            $link  = (empty($venda)) ? $link : 'javascript:void(0)';

            $sql = "SELECT ven_009 as subtotal,  ((ven_009 * 0.10) + ven_009) as total, (ven_009 * 0.10) as servico, ven_001 ";
            $sql .= "FROM venda ";
            $sql .= "WHERE ven_026 = {$n_comanda} AND ven_024 = 'C' AND sit_001 in (8, 21)";
            $stm = $pdo->prepare($sql);
            $stm->execute();
            $totalizadores = $stm->fetch(PDO::FETCH_OBJ);
            ?>
            <a class='link-comanda' href="<?=$link?>">
              <div class = "wide-card mdl-card mdl-shadow--4dp container-comandas  <?=$back?>">
                  <div class = "mdl-card__title">
                    <h3 class = "mdl-card__title-text">
                    Comanda <?=$comanda->ven_026?> | <?=$comanda->ven_027?>
                    </h3>
                  </div>
                  
                  <div class = "card-valor">
                    <span class="text-left text-red valor">
                      <?php if (TAXA_COMANDA):?> 
                      Valor R$ <?=number_format( $totalizadores->total, 2, ',', '.')?>
                      <?php else:?>
                      Valor R$ <?=number_format( $totalizadores->subtotal, 2, ',', '.')?>
                      <?php endif;?>
                    </span>
                  </div>        
                  <i class="material-icons text-blue icone-detalhes">search</i>
                </div>
            </a> 
        <?php endforeach;?>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <?php include 'includes/inc_notifica_js.php'; ?>
  <script>
    if (localStorage.hasOwnProperty('carrinho')){
        localStorage.removeItem('carrinho')
	  }
    
    $(document).ready(function($) {	
        $('.adicionar').on('click', function(){
           
          swal({
              title: 'Nome do Cliente',
              html: "<input autofocus type='text' id='nome' placeholder='Informe o Nome' class='inpt-cliente text-red' autocomplete='off'>",
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Abrir Comanda',
              cancelButtonText: 'Cancelar',
              confirmButtonClass: 'btn btn-success',
              cancelButtonClass: 'btn btn-danger',
              buttonsStyling: false,
              reverseButtons: true,
              focusConfirm: true
            }).then((result) => {
              if (result.value) {
                var cliente = $('#nome').val();

                if (cliente.trim() != ''){
                  window.location = './pedido.php?tipo=C&cliente='+cliente;
                }else{
                    swal(
                      'Alerta',
                      'Informe o nome do Cliente!',
                      'warning'
                    )
                }
              } 
            })
        });
    });
  </script>
</body>
</html>