<?php
ini_set('date.timezone', 'America/Fortaleza');
$pdo       = Conexao::getInstance();
$sql = "SELECT table_name FROM information_schema.tables WHERE table_schema='public' AND table_name='config_mobile'";
$stm = $pdo->prepare($sql);
$stm->execute();
$tabela = $stm->fetch(PDO::FETCH_OBJ);

if (!empty($tabela)):

    $sql = "SELECT * FROM config_mobile LIMIT 1";
    $stm = $pdo->prepare($sql);
    $stm->execute();
    $configuracao = $stm->fetch(PDO::FETCH_OBJ);

    if (!empty($configuracao)):
        define('TAXA_MESA', $configuracao->calcular_taxa_mesa);
        define('TAXA_COMANDA', $configuracao->calcular_taxa_comanda);
        define('COBRAR_MAIOR_VALOR_FRACIONADO', $configuracao->cobrar_maior_valor_fracionado);
        define('CAMPO_ORDENACAO_PRODUTO', $configuracao->ordenacao_produtos);
        define('TIPO_ORDENACAO_PRODUTO', $configuracao->tipo_ordenacao);
        define('TIPO_COMANDA', $configuracao->tipo_comanda);
        define('PAGINA_INICIAL', $configuracao->pagina_inicial);
        define('PERMITE_REIMPRESSAO', $configuracao->permite_reimpressao);
        define('EXIBE_BOTAO_ADICIONAR_COMANDA', $configuracao->exibe_botao_adicionar_rodape);
        define('SERVIDOR', $configuracao->servidor);
        define('ESCOLHA_SABORES', $configuracao->venda_escolha_sabores);
        define('HABILITA_ETAPA', $configuracao->habilita_etapa);
        define('MONITORA_COZINHA', $configuracao->monitora_cozinha);
    else:
        // Cobrar 10% das Mesas
        define('TAXA_MESA', FALSE);

        // Cobrar 10% das Comandas
        define('TAXA_COMANDA', FALSE);

        // Cobrar maior valor da Pizza fracionada
        define('COBRAR_MAIOR_VALOR_FRACIONADO', TRUE);

        // Ordenação dos produtos or CODIGO ou DESCRICAO
        define('CAMPO_ORDENACAO_PRODUTO', 'DESCRICAO');

        // Tipo ordenação dos produtos ASC ou DESC
        define('TIPO_ORDENACAO_PRODUTO', 'ASC');

        // Tipo de Comanda
        // 0 - Usuário informa o Nome do Cliente e o Sistema gera o Número da Comanda
        // 1 - Usuário informa o Número da Comanda
        // 2 - Usuário informa o Número da Comanda e o Número da Mesa
        // 3 - Usuário NÃO informa o Número da Comanda e possui Pesquisa
        // 4 - Usuário informa o Número da Comanda e o Nome do Cliente
        // 5 - Usuário o Nome do Cliente na Abertura da Mesa
        define('TIPO_COMANDA', 2);

        // Após o login inicia com a página de:
        // COMANDAS_NUMERO
        // COMANDAS_NOME
        // COMANDAS_NUMERO_MESA
        // COMANDAS_NUMERO_PESQUISA
        // MESAS
        // COMANDAS_NUMERO_NOME
        // MESAS_NOME
        define('PAGINA_INICIAL', 'MESAS');

        // Exibe opção de reimpressão dos itens
        define('PERMITE_REIMPRESSAO', FALSE);

        // Exibe botão adicionar comanda na listagem com pesquisa
        define('EXIBE_BOTAO_ADICIONAR_COMANDA', TRUE);

        define('SERVIDOR', '');

        define('ESCOLHA_SABORES', TRUE);

        define('HABILITA_ETAPA', FALSE);

        define('MONITORA_COZINHA', FALSE);
    endif;
endif;


