<?php
require 'verifica_cookie.php';
require 'conexao.php';

$mesa    = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$cliente = (isset($_GET['cliente'])) ? $_GET['cliente'] : '' ;
$item    = (isset($_GET['item'])) ? $_GET['item'] : '' ;
$pdo     = Conexao::getInstance();

$sql = "SELECT i.ite_001, i.mat_001, i.ite_002, m.mat_003, i.ite_011, i.ite_005, i.ven_001, ";
$sql .= "i.ite_006, i.ite_009, i.tamanho, i.gar_001 ";
$sql .= "FROM venda v INNER JOIN vendaitem i ON v.ven_001 = i.ven_001 ";
$sql .= "INNER JOIN materiais m ON m.mat_001 = i.mat_001 ";
$sql .= "WHERE i.sit_001 = 4 AND v.sit_001 = 8 ";
$sql .= "AND i.ite_001 = {$item}";

if (empty($comanda)):
	$sql .= "AND v.ven_025 = {$mesa} AND v.ven_024 = 'M' ";
else:
	$sql .= "AND v.ven_026 = {$comanda} AND v.ven_024 = 'C' ";
endif;

$sql .= "ORDER BY i.ite_001 ";
$stm = $pdo->prepare($sql);
$stm->execute();
$item = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT o.descricao, o.valor ';
$sql .= 'FROM vendaitemopcional v INNER JOIN opcional o ON v.id_opcional = o.id_opcional ';
$sql .= 'WHERE id_venda = :id_venda and id_vendaitem = :item';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_venda', $item->ven_001);
$stm->bindValue(':item', $item->ite_001);
$stm->execute();
$opcional = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT usu_002 FROM usuarios ';
$sql .= 'WHERE usu_001 = :id_usuario';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_usuario', $item->gar_001);
$stm->execute();
$usuario = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT b_cancelamento_mesa FROM usuarios ';
$sql .= 'WHERE usu_001 = :id_usuario';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_usuario', $_COOKIE['id']);
$stm->execute();
$autorizacao = $stm->fetch(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">
	  
	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	  	<div class="mdl-cell mdl-cell--12-col mdl-cell--16-col-phone">

	  		<h4>Detalhes do Item</h4>
	  		<?php if ($item):?>
				<div class="mdl-card mdl-shadow--4dp detalhe">
				   <div class="mdl-card__title">
				    <h4 class="mdl-card__supporting-text">
				    <strong>
				    	<?=number_format($item->ite_002, 3, ',', '.')?> - <?=$item->mat_003?>
				    </strong>
				    
				    </h4>
				  </div>

				  <span><strong>VALOR: </strong>R$ <?=number_format($item->ite_005, 2, ',', '.')?></span>
				  <span><strong>GARÇOM: </strong><?=$usuario->usu_002?></span>
				  <span><strong>HORA: </strong><?=$item->ite_009?></span>
				  <?php if(!empty($item->tamanho)):?>
				  	<span><strong>TAMANHO: </strong><?=$item->tamanho?></span>
				  <?php endif; ?>
				  <?php if(!empty($opcional)):?>
				  	<span><strong>OPCIONAL: </strong><?=$opcional->descricao?></span>
				  <?php endif; ?>
				  <span><strong>OBS: </strong><?=$item->ite_006?></span>
				</div><br>
				<?php if ($autorizacao->b_cancelamento_mesa):?>
					<p>* Itens Fracionados serão excluídos todos os produtos</p>
					<input type="hidden" id="item" value="<?=$item->ite_001?>">
					<input type="hidden" id="venda" value="<?=$item->ven_001?>">
					<a href='javascript:void(0)' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-red btn-excluir">
					  Excluir 
				    </a>
				<?php endif; ?>   
			<?php else: ?>	
	  			<p>Item não encontrado.</p>
	  		<?php endif; ?>
		</div>
	  </div>
	</div>

	<!-- Modal de Exclusão -->
	<dialog class="mdl-dialog modal-excluir">
	    <div class="mdl-dialog__content">
	      <p>
	      <h5>Excluir item?</h5>
	      <p><span class="produto red"></span></p>
	      </p>
	    </div>
	    <div class="mdl-dialog__actions">
	      <button type="button" class="mdl-button close">Cancelar</button>
	      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored excluir btn-red">Excluir</button>
	    </div>
	</dialog>
	<script src="js/jquery.min.js"></script>
	<script>

    var dialogExcluir = document.querySelector('.modal-excluir')
	if (! dialogExcluir.showModal) {
       dialogPolyfill.registerDialog(dialogExcluir);
    }

    jQuery(document).ready(function($) {	

    	$('.btn-excluir').click(function(event) {
		    dialogExcluir.showModal();
    	});

    	$('.close').click(function(event) {
    		dialogExcluir.close();
    	});

    	$('.excluir').click(function(event) { 
    		var item = $('#item').val();
    		var venda = $('#venda').val();

    		$.ajax({
    			url: 'excluir_item.php',
    			type: 'POST',
    			dataType: 'JSON',
    			data: {id_venda: venda, item: item},
    			beforeSend: function(){
    				$('.excluir').html('Excluindo ...');
    			},
    			success: function(retorno){
    				if (retorno.status == '1'){
    					window.location = 'pedido.php?mesa=' + <?=$mesa?>;
    				}else{
    					alert(retorno.erro);
    				}
    			}
    		});			
    	});
    });
    </script>
</body>
</html>
