﻿<?php
session_start();
require 'conexao.php';
require 'config.php';
require 'includes/inc_verifica_caixa.php';

$sql = "SELECT * FROM impressoras WHERE (computador = '".SERVIDOR."' OR computador IS NULL) ORDER BY codigo";
$stm = $pdo->prepare($sql);
$stm->execute();
$impressoras = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
  <?php require 'includes/inc_head.php'; ?>
  <style>
    label.mdl-checkbox.mdl-js-checkbox.mdl-js-ripple-effect.mdl-js-ripple-effect--ignore-events.is-upgraded {
      margin: 10px auto;
  }
  </style>
</head>
<body>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title"><?=$_COOKIE['usuario']?></span>      
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?> 

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp">
           <div class = "mdl-card__title">
              <h3 class = "mdl-card__title-text">
                 ENVIAR IMPRESSÃO
              </h3>
           </div>

           <div class = "mdl-card__actions mdl-card--border">
             <form id="formulario" action="">
              <textarea rows="8" style="width: 100%" id="texto" name="texto" placeholder="Digite o texto ..."></textarea><br><br>
 
              <?php foreach($impressoras as $impressora):?>
               <label class = "mdl-checkbox mdl-js-checkbox mdl-js-ripple-effect" for = "ckb-<?=$impressora->id?>">
                 <input type = "checkbox" class="ckb mdl-checkbox__input" id="ckb-<?=$impressora->id?>" name="impressoras[]" value="<?=$impressora->codigo?>">
                 <span class = "mdl-checkbox__label"><?=$impressora->nome?></span>
               </label>&nbsp;
              <?php endforeach; ?>
              
            </div>
            <br>
            <div class = "mdl-card__actions mdl-card--border totalizador detalhe">
              <a href="javascript:window.history.go(-1)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-red">
                <i class="material-icons">arrow_back</i> VOLTAR
              </a>&nbsp;
              <a href="javascript:void(0)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-impressao">
                <i class="material-icons">print</i> IMPRIMIR
              </a>&nbsp;
            </form>
           </div>          
        </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
    $(document).ready(function($) {	

    	$('.btn-impressao').click(function(event) { 
        var texto = $('#texto').val();

        if (texto != ""){
            swal({
               title: 'Deseja enviar Impressão?',
               type: 'question',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Sim, Enviar!',
               cancelButtonText: 'Não Enviar!',
               confirmButtonClass: 'btn btn-success',
               cancelButtonClass: 'btn btn-danger',
               buttonsStyling: false,
               reverseButtons: true
             }).then((result) => {
               if (result.value) {
                  $.ajax({
                      url: 'ajax_envia_texto.php',
                      type: 'POST',
                      dataType: 'JSON',
                      data: $('#formulario').serialize(),
                      beforeSend: function(){
                         EasyLoading.show({});
                      },
                      success: function(retorno){
                         EasyLoading.hide();
                         if (retorno.status == 1){
                            Snackbar.show({text: 'Texto enviado com sucesso!', 
                                           actionText: 'Fechar', 
                                           duration: 2000,
                                           pos: 'bottom-left'
                                        }); 
                         }else{
                          swal(
                              'Alerta',
                              retorno.text,
                              'warning'
                            )
                         }
                      }
                   });
               } 
             }) 
        }else{
          swal(
              'Alerta',
              'Digite um Texto e Selecione uma Impressora!',
              'warning'
            )
        }
      });

    });
  </script>
</body>
</html>