<?php
require 'conexao.php';
require 'config.php';

$usuario   = (isset($_POST['usuario'])) ? strtoupper($_POST['usuario']) : '';
$senha     = (isset($_POST['senha'])) ? $_POST['senha'] : '';
$pdo       = Conexao::getInstance();

$sql = "SELECT usu_001, usu_002, usu_003, usu_004, b_cancelamento_mesa FROM usuarios ";
$sql .= "WHERE usu_003 = ? AND usu_004 = ? AND sit_001 = 4 AND b_funcao_garcom = TRUE";
$stm = $pdo->prepare($sql);
$stm->bindValue(1, $usuario);
$stm->bindValue(2, $senha);
$stm->execute();
$usuario = $stm->fetch(PDO::FETCH_OBJ);

if (empty($usuario)):
	echo json_encode(array('status'=>'0', 'text' => 'Login inválido'));
else:
	$expira = (time() + (20 * 3600));
    setcookie('id', $usuario->usu_001, $expira, '/');
    setcookie('usuario', $usuario->usu_002, $expira, '/');
    setcookie('login', date('d/m/Y H:i:s'), $expira, '/');
	setcookie('cancelamento_mesa', $usuario->b_cancelamento_mesa, $expira, '/');

    $linkListagen  = '';
    if (PAGINA_INICIAL == 'MESAS'):
    	$linkListagen = 'mesas.php';
    else:
	    switch (TIPO_COMANDA):
	     case 0:
	       $linkListagen = 'comandas_nome.php';
	       break;
	     case 1:
	       $linkListagen = 'comandas_numero.php';
	       break;
	     case 2:
	       $linkListagen = 'comandas_numero_mesa.php';
	       break;
		 case 3:
	       $linkListagen = 'comandas_numero_pesquisa.php';
		   break;
		 case 4:
			$linkListagen = 'comandas_numero_nome.php';
			break;
	     default:
	       $linkListagen = 'comandas_numero.php';
	       break;
	    endswitch;
	endif;

	echo json_encode(array('status'=>'1', 'text' => 'Logado com sucesso', 'url' => $linkListagen));
endif;
