﻿<?php
session_start();
require 'conexao.php';
require 'config.php';

$venda    = (isset($_GET['venda'])) ? $_GET['venda'] : '' ;
$codigo  = (isset($_GET['codigo'])) ? $_GET['codigo'] : '' ;
$mesa  = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda  = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$tipo  = (isset($_GET['tipo'])) ? $_GET['tipo'] : '' ;

$sql = 'SELECT mat_003, tamanho_padrao, valor_tam_p, valor_tam_m, valor_tam_g, valor_tam_gg, valor_tam_extra  ';
$sql .= 'FROM materiais WHERE mat_001 = :codigo';
$stm = $pdo->prepare($sql);
$stm->bindValue(':codigo', $codigo);
$stm->execute();
$produto = $stm->fetch(PDO::FETCH_OBJ);

$sql = "SELECT DISTINCT tamanho_p, tamanho_m, tamanho_g, tamanho_gg, tamanho_extra ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetch(PDO::FETCH_OBJ);


switch ($produto->tamanho_padrao) :
  case 'P':
      $descricao = ($produto->valor_tam_p > 0) ? $tamanhos->tamanho_p : '';
      $tamanhoAbreviado = ($produto->valor_tam_p > 0) ? $produto->tamanho_padrao : '';
      break;
  case 'M':
      $descricao = ($produto->valor_tam_m > 0) ? $tamanhos->tamanho_m : '';
      $tamanhoAbreviado = ($produto->valor_tam_m > 0) ? $produto->tamanho_padrao : '';
      break;
  case 'G':
      $descricao = ($produto->valor_tam_g > 0) ? $tamanhos->tamanho_g : '';
      $tamanhoAbreviado = ($produto->valor_tam_g > 0) ? $produto->tamanho_padrao : '';
      break;
  case 'GG':
      $descricao = ($produto->valor_tam_gg > 0) ? $tamanhos->tamanho_gg : '';
      $tamanhoAbreviado = ($produto->valor_tam_gg > 0) ? $produto->tamanho_padrao : '';
      break;
  case 'E':
      $descricao = ($produto->valor_tam_extra > 0) ? $tamanhos->tamanho_extra : '';
      $tamanhoAbreviado = ($produto->valor_tam_extra > 0) ? $produto->tamanho_padrao : '';
      break;
  default:
      $descricao = $tamanhos->tamanho_m;
endswitch;


$sql = "SELECT tamanho_p as tamanho, 'P' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_m as tamanho, 'M' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_g as tamanho, 'G' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_gg as tamanho, 'GG' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_extra as tamanho, 'E' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tabela_tamanhos = $stm->fetchAll(PDO::FETCH_OBJ);

if ($tipo == 'M'):
  $linkListagem = "opcional.php?mesa={$mesa}&tipo={$tipo}&venda={$venda}&codigo={$codigo}";
elseif($tipo == 'C'):
  $linkListagem = "opcional.php?comanda={$comanda}&tipo={$tipo}&venda={$venda}&codigo={$codigo}";
endif;

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'includes/inc_head.php'; ?>
  <style>
      .footer {
        position: absolute;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1000;
        background:#d6d7da;
      }
      .box-altura{
        display: block;
        height: 70px;
      }
      .btn-rodape{
        height: 50px;
      }
      .select-tamanho {
        width: 25%;
        padding: 8px 6px;
        margin: 8px 5px 8px 0;
    }
    .sabores{
      font-size: 17px;
      font-weight: bold;
      /* line-height: 27px; */
    }
    hr{
      margin-bottom: 10px;
    }
  </style>
</head>
<body>
   <script>loadPagina()</script>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header page">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title">SABORES DO ITEM</span>
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?>

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp conteudo">
           <div class = "mdl-card__actions mdl-card--border">
              <p class="text-left text-red valor">
                <strong>TAMANHO: </strong>
                <select id="tamanho" class="select-tamanho">
                  <option value="<?=$tamanhoAbreviado?>"><?=$descricao?></option>
                  <?php 
                    foreach($tabela_tamanhos as $tamanho):

                      $descricao = '';
                      $sigla = '';
                      if ($tamanho->sigla == 'P' && $produto->valor_tam_p > 0):
                          $descricao = $tamanhos->tamanho_p;
                          $sigla = $tamanho->sigla;
                      endif;

                      if ($tamanho->sigla == 'M' && $produto->valor_tam_m > 0):
                         $descricao = $tamanhos->tamanho_m;
                         $sigla = $tamanho->sigla;
                      endif;

                      if ($tamanho->sigla == 'G' && $produto->valor_tam_g > 0):
                         $descricao = $tamanhos->tamanho_g;
                         $sigla = $tamanho->sigla;
                      endif;

                      if ($tamanho->sigla == 'GG' && $produto->valor_tam_gg > 0):
                         $descricao = $tamanhos->tamanho_gg;
                         $sigla = $tamanho->sigla;
                     endif;

                     if ($tamanho->sigla == 'E' && $produto->valor_tam_extra > 0):
                        $descricao = $tamanhos->tamanho_extra;
                        $sigla = $tamanho->sigla;
                    endif;

                    if ($descricao != '' && $sigla != ''):?>
                       <option value="<?=$tamanho->sigla?>"><?=$tamanho->tamanho?></option>
                    <?php endif; ?>

                  <?php endforeach; ?>
                </select>
                <strong>SABORES: </strong>
                <select id="qtde"  class="select-tamanho">
                  <option value="1">1</option>
                  <option value="0.500">2</option>
                  <option value="0.3333">3</option>
                  <option value="0.250">4</option>
                </select>
              </p><p></p>
              <p class="text-left text-red valor">
              </p><br><br>
              <hr>
              <p class='sabores'>
                <a href="javascript::void(0)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-gray">
                  <i class="material-icons">clear</i>
                </a>
                <?=$produto->mat_003?>
              </p>
              <div id="container-sabores">

              </div>
           </div>
        </div>

        <div id="sabores" style="display:none">
          <div class = "mdl-textfield mdl-js-textfield mdl-textfield--floating-label pesquisa">
              <input class = "mdl-textfield__input" type = "text" id = "pesquisa" autocomplete="off">
              <label class = "mdl-textfield__label" for = "text4">Procurar por Código ou Descrição</label>
          </div>

          <div id="produtos-fracionado">

          </div>
        </div>

        <div class="box-altura"></div>
          <div class = "mdl-shadow--4dp footer mdl-card__actions mdl-card--border container-finalizar <?=$exibe_finalizacao?>">
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-red" onclick="javascript:window.history.go(-1)" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">arrow_back</i>
                VOLTAR
            </button>
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-green btn-finalizar" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">check_circle</i>
                PRÓXIMO
            </button>
          </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
     function preloader(){
         EasyLoading.hide();
         $('#page').show();
      }
      window.onload = preloader;

     $(document).ready(function($) {

       consultaProdutos()
       var arrayPizza = [];

       $('#pesquisa').on('input', function(event) {
          var termo = $(this).val();

          if(termo.length >= 0){
            consultaProdutos(termo)
          }
      });

       $(document).on('click', '.container-produto', function(){
         var id = $(this).attr('data-id');
         var nome = $(this).attr('data-nome');
         var qtde = $('#qtde option:selected').text();
         var qtde_real = $('#qtde').val();

         if (parseInt(qtde) > arrayPizza.length +1){
           if (isItemJaExiste(id)){
              swal(
                nome,
                'Já foi adicionado !',
                'warning'
              );
           }else{
              arrayPizza.push({codigo: id, nome: nome, qtde:qtde_real, tamanho: ''})
              atualizaSabores()

              if(parseInt(qtde) == arrayPizza.length +1){
                $('#sabores').hide();
              }
           }
         }else{
          swal(
            'Alerta',
            'Máximo de sabores permitido ( '+qtde+' ) !',
            'warning'
          );

         }
      });

      $(document).on('click', '.btn-excluir', function(){
         var id = $(this).attr('data-id');
         swal({
            title: 'Deseja Excluir esse Item?',
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#ccc',
            confirmButtonText: 'Sim, Excluir!',
            cancelButtonText: 'Não Excluir!',
            confirmButtonClass: 'btn btn-danger',
            cancelButtonClass: 'btn',
            buttonsStyling: false,
            reverseButtons: true
          }).then((result) => {
            if (result.value) {
              removerItem(id)
              exibeSabores()
            }
          })
      });

      $('#qtde').on('change', function() {
        exibeSabores()
      })

      $('.btn-finalizar').on('click', function(){
        var qtde = $('#qtde option:selected').text();
        var tamanho = $('#tamanho').val();
        var desc_tamanho = $('#tamanho option:selected').text();
        var qtde_real = $('#qtde').val();

        if (parseInt(qtde) != arrayPizza.length +1){
          swal(
            'Alerta',
            'Você selecionou ( '+qtde+' ) sabores, mas adicionou ( '+(arrayPizza.length +1)+' ) !',
            'warning'
          );
        }else{
          arrayPizza.push({
              codigo: '<?=$codigo?>', 
              nome: '<?=$produto->mat_003?>', 
              qtde:qtde_real, 
              tamanho: tamanho,
              descricao_tamanho: desc_tamanho
          })

          arrayPizza.forEach((item, index) => {
            arrayPizza[index].tamanho = tamanho
            arrayPizza[index].qtde = qtde_real
            arrayPizza[index].descricao_tamanho = desc_tamanho
          })

          let contador = 0
          localStorage.setItem('sabores', JSON.stringify(arrayPizza))
          window.location.href = '<?=$linkListagem?>';
        }
      })

      function consultaProdutos(termo){
        let container = document.getElementById('produtos-fracionado')
        let codigo = '<?=$codigo?>'
        let produtos = []

        container.innerHTML = "<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>"

        if (localStorage.hasOwnProperty('produtos')){
            let produtosStorage = JSON.parse(localStorage.getItem('produtos'))

            if (termo != undefined && termo != ''){
               produtos = produtosStorage.filter(prod => ( prod.fracionado && prod.mat_001 != codigo && prod.mat_003.indexOf(termo.toUpperCase()) >= 0) )
            }else{
               produtos = produtosStorage.filter(prod => ( prod.fracionado && prod.mat_001 != codigo ))
            }

            let str = ''
            produtos.forEach(produto => {
                  let descricao = produto.descricao ? produto.descricao : ''
                  let valores = ''

                  if (produto.b_venda_tamanho == true){
                    if (produto.valor_tam_p != "0.00"){  
                        valores = 'Pq ' + produto.valor_tam_p
                    }

                    if (produto.valor_tam_m != "0.00"){
                        valores += (valores != '') ? ' / Med ' + produto.valor_tam_m : 'Med ' + produto.valor_tam_m
                    }

                    if (produto.valor_tam_g != "0.00"){
                        valores += (valores != '') ? ' / Grd ' + produto.valor_tam_g : 'Grd ' + produto.valor_tam_g
                    }

                    if (produto.valor_tam_gg != "0.00"){
                        valores += (valores != '') ? ' / GG ' + produto.valor_tam_gg : 'GG ' + produto.valor_tam_gg
                    }

                    if (produto.valor_tam_extra != "0.00"){
                        valores += (valores != '') ? ' / Ext ' + produto.valor_tam_extra : 'Ext ' + produto.valor_tam_extra
                    }
                  }else{
                    if (produto.valor_tam_m != "0.00"){
                        valores = produto.valor_tam_m
                    }
                  }

                  str += `<a href="javascript:void(0)" 
                              data-id="${produto.mat_001}" 
                              data-nome="${produto.mat_003.toUpperCase()}" 
                              class="container-produto mdl-shadow--6dp">
                            <div class = "wide-card mdl-card mdl-shadow--4dp mdl-card--border card-produto">
                              <div class = "mdl-card__actions titulo-produto">
                              <p class="text-left text-black">${produto.mat_004} - ${produto.mat_003.toUpperCase()}</p>
                              <p class="text-left text-gray">${descricao}</p>
                              <p class="text-red">${valores}</p>
                              </div>
                            </div>
                          </a>`
            })

            container.innerHTML = str
        }

      }

      function removerItem(codigo){
        arrayPizza.forEach((item, index) => {
          if (item.codigo == codigo){
            arrayPizza.splice(index, 1)
          }
        })

        atualizaSabores()
      }

      function atualizaSabores(){
         let elemento = ''
         let sabores = arrayPizza.length
         arrayPizza.forEach(item => {
            elemento += `<p class='sabores'>
                  <a href="javascript::void(0)" data-id="${item.codigo}" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-red btn-excluir">
                    <i class="material-icons">clear</i>
                  </a>
                  ${item.nome}
                </p>`
         })
         $('#container-sabores').html(elemento)
      }

      function isItemJaExiste(codigo){
        let existe = false

        arrayPizza.forEach(item => {
          if (item.codigo == codigo){
            existe = true
          }
        })

        return existe
      }

      function exibeSabores(){
        let qtde = $('#qtde option:selected').text();
        
        if (qtde > arrayPizza.length +1){
          $('#sabores').show();
        }else{
           $('#sabores').hide();
        }
      }

    });
  </script>
</body>
</html>
