<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
require 'verifica_cookie.php';
require 'conexao.php';

$texto       = (isset($_POST['texto'])) ? trim(strtoupper($_POST['texto'])) : '' ;
$impressoras = (isset($_POST['impressoras'])) ? $_POST['impressoras'] : '' ;
$pdo         = Conexao::getInstance();
$contErro    = 0;

if (empty($texto) || empty($impressoras)):
	echo json_encode(array('status'=>'0', 'text' => 'Digite um Texto e Selecione uma Impressora !'));
    exit;
endif;


$sql = "INSERT INTO impressao_livre(id, garcom, data_hora, texto, impressora, status) VALUES";
$sql .= "((SELECT COALESCE(MAX(id), 0)+1 FROM impressao_livre), :garcom, :data_hora, :texto, :impressora, :status)";
$stm = $pdo->prepare($sql);
foreach($_POST['impressoras'] as $impressora):
	$stm->bindValue(':garcom', strtoupper($_COOKIE['usuario']));
	$stm->bindValue(':data_hora', date('d/m/Y H:i:s'));
	$stm->bindValue(':texto', $texto);
	$stm->bindValue(':impressora', $impressora);
	$stm->bindValue(':status', 'N');
	$retorno = $stm->execute();
endforeach;


if ($retorno):
	echo json_encode(array('status'=>'1', 'text' => 'Gravado com sucesso'));
else:
	echo json_encode(array('status'=>'0', 'text' => 'Erro ao gravar item!'));
endif;