<?php
require 'verifica_cookie.php';
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'conexao.php';

$id_venda = (isset($_POST['id_venda'])) ? $_POST['id_venda'] : '' ;
$item     = (isset($_POST['item'])) ? $_POST['item'] : '' ;
$usuario  = (isset($_COOKIE['id'])) ? $_COOKIE['id'] : '1' ;
$pdo      = Conexao::getInstance();
$contErro = 0;

if (empty($id_venda)):
	$contErro += 1;
endif;

if (empty($item)):
	$contErro += 1;
endif;

if ($contErro):
	 $output = json_encode(array('status'=>'0', 'text' => 'Existem campos vazios!'));
     die($output);
endif;

$sql = 'SELECT item_fracionado FROM vendaitem ';
$sql .= 'WHERE ven_001 =:venda AND (item_fracionado IS NOT NULL AND item_fracionado > 0) AND ite_001 = :item';
$stm = $pdo->prepare($sql);
$stm->bindValue(':venda', $id_venda);
$stm->bindValue(':item', $item);
$stm->execute();
$item_fracionado = $stm->fetch(PDO::FETCH_OBJ);

if (empty($item_fracionado)) :

	$sql = 'UPDATE vendaitem SET sit_001 = 2, id_usuario_cancelamento=:id_usuario WHERE ven_001=:id_venda and ite_001=:nro_item';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':id_usuario', $usuario);
	$stm->bindValue(':id_venda', $id_venda);
	$stm->bindValue(':nro_item', $item);
	$retorno = $stm->execute();
else:
	$sql = 'UPDATE vendaitem SET sit_001 = 2, id_usuario_cancelamento=:id_usuario, acrescimo = 0 WHERE ven_001=:id_venda and item_fracionado= :item_fracionado';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':id_usuario', $usuario);
	$stm->bindValue(':id_venda', $id_venda);
	$stm->bindValue(':item_fracionado', $item_fracionado->item_fracionado);
	$retorno = $stm->execute();

	$sql = 'DELETE FROM vendaitemopcional WHERE id_venda =:id_venda and id_vendaitem=:nro_item';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':id_venda', $id_venda);
	$stm->bindValue(':nro_item', $item);
	$retorno = $stm->execute();
endif;


$sql = 'SELECT fn_calcula_total_venda(:idvenda, :idempresa)';
$stm = $pdo->prepare($sql);
$stm->bindValue(':idvenda', $id_venda);
$stm->bindValue(':idempresa', 1);
$stm->execute();

if ($retorno):
	echo json_encode(array('status'=>'1', 'text' => 'Gravado com sucesso'));
else:
	echo json_encode(array('status'=>'0', 'text' => 'Erro ao gravar item!'));
endif;