<?php
session_start();
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

if (isset($_SESSION['PEDIDO'])):

	$venda       = (isset($_POST['venda'])) ? $_POST['venda'] : '' ;
	$tipo_venda  = (isset($_POST['tipo'])) ? $_POST['tipo'] : '' ;
	$mesa        = (isset($_SESSION['CONTROLE']) && $tipo_venda == 'M') ? $_SESSION['CONTROLE'] : '0' ;
	$comanda     = (isset($_SESSION['CONTROLE']) && $tipo_venda == 'C') ? $_SESSION['CONTROLE'] : '0' ;
	$cliente     = (isset($_POST['cliente'])) ? $_POST['cliente'] : '' ;
	$pedidosJson = (isset($_POST['pedido'])) ? $_POST['pedido'] : '' ;
	$usuario     = (isset($_COOKIE['id'])) ? $_COOKIE['id'] : 1 ;
	$tipo_venda  = (isset($_POST['tipo'])) ? $_POST['tipo'] : '' ;
	$pdo         = Conexao::getInstance();
	$contErro    = 0;
	$aberturaVenda = true;

	if ($pedidosJson):

		try{
			$pdo->beginTransaction();

			// SENÃO EXISTIR VENDA ABERTA INSERI A NOVA VENDA, GERA UM NÚMERO PARA NOVA VENDA
			if (empty($venda)):

				$aberturaVenda = true;
				$sql = 'SELECT (COALESCE(MAX(ven_001) ,0)+1) as venda FROM venda WHERE emp_001 = 1';
				$stm = $pdo->prepare($sql);
				$stm->execute();
				$contador = $stm->fetch(PDO::FETCH_OBJ);
				$id_venda = $contador->venda;
				$_SESSION['VENDA'] = $contador->venda;
				$itens    = 0;

				// SE FOR UMA VENDA DO TIPO COMANDA E ESTIVER CONFIGURADO PARA
				// GERAR O NÚMERO AUTOMATICAMENTE TAMBÉM GERA O NÚMERO DE COMANDA
				if ($tipo_venda == 'C' && TIPO_COMANDA == 0):
					$sql = 'SELECT (COALESCE(MAX(ven_026) ,0)+1) as comanda FROM venda WHERE sit_001 = 8';
					$stm = $pdo->prepare($sql);
					$stm->execute();
					$controle = $stm->fetch(PDO::FETCH_OBJ);
					$comanda = $controle->comanda;
					$_SESSION['CONTROLE'] = $controle->comanda;
				endif;

				// SELECIONA O ID DE ABERTURA PARA O FLUXO DE CAIXA ATUAL
				$sql = "SELECT id_caixa FROM caixa WHERE id_situacao = 4";
				$stm = $pdo->prepare($sql);
				$stm->execute();
				$caixa = $stm->fetch(PDO::FETCH_OBJ);

				$sql = 'INSERT INTO venda (ven_001, ven_002, emp_001, dat_001_1, ven_025, cli_001, sit_001, usu_001_1, ';
				$sql .= 'VEN_024, ven_029, ven_004, ven_023, id_caixa_abertura, ven_026, terminal_abertura, ven_027)';
				$sql .= 'VALUES(:id_venda, 0, :emp, LOCALTIMESTAMP, :id_mesa, 0, 8, :id_usuario, ';
				$sql .= ":tipo_venda, :id_venda2, LOCALTIMESTAMP, 'N', :id_caixa_abertura, :comanda, :terminal_abertura, :nome_cliente)";
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':id_venda', $id_venda);
				$stm->bindValue(':emp', 1);
				$stm->bindValue(':id_mesa', (int) $mesa);
				$stm->bindValue(':id_usuario', (int) $usuario);
				$stm->bindValue(':tipo_venda', $tipo_venda);
				$stm->bindValue(':id_venda2', $id_venda);
				$stm->bindValue(':id_caixa_abertura', (int) $caixa->id_caixa);
				$stm->bindValue(':comanda', $comanda);
				$stm->bindValue(':terminal_abertura', 'MOBILE');
				$stm->bindValue(':nome_cliente', $cliente);
				$stm->execute();

			else:

				$aberturaVenda = false;
				$sql = 'SELECT MAX(ite_001) as itens FROM vendaitem WHERE ven_001 = :venda';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':venda', $venda);
				$stm->execute();
				$item = $stm->fetch(PDO::FETCH_OBJ);

				$itens    = $item->itens;
				$id_venda = $venda;
			endif;

			// ACERTA AS QUANTIDADES NOS ITENS QUE AINDA ESTÃO PENDENTES
			$pedidos = json_decode($pedidosJson);
			foreach($pedidos as $produto):
				$_SESSION['PEDIDO'][$produto->item]['QUANTIDADE']     = $produto->qtde;
				$_SESSION['PEDIDO'][$produto->item]['TAMANHO_PEDIDO'] = $produto->tamanho;
			endforeach;

			// PERCORRE TODOS OS ITENS EM SESSION E PROCESSA A GRAVAÇÃO NO BANCO
			foreach($_SESSION['PEDIDO'] as $itemPedido): 

				if (empty($mesa) && empty($comanda) && empty($cliente)):
					$contErro += 1;
				endif;

				if (empty($itemPedido['COD_PRODUTO'])):
					$contErro += 1;
				endif;

				if (empty($itemPedido['QUANTIDADE'])):
					$contErro += 1;
				endif;

				$sql = 'SELECT mat_001, mat_021, valor_tam_p, valor_tam_m, valor_tam_g, b_venda_tamanho FROM materiais ';
				$sql .= 'WHERE mat_004 = :produto AND sit_001 = 4';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':produto', $itemPedido['COD_PRODUTO']);
				$stm->execute();
				$produto = $stm->fetch(PDO::FETCH_OBJ);

				if ($itemPedido['VENDA_TAMANHO']):
					switch ($itemPedido['TAMANHO_PADRAO']) :
						case 'P':
							$valor_unitario = $produto->valor_tam_p;
							break;
						case 'M': 
							$valor_unitario = $produto->valor_tam_m;
							break;
						case 'G': 
							$valor_unitario = $produto->valor_tam_g;
							break;
					endswitch;
				else:
					$valor_unitario = $produto->valor_tam_m;
				endif;

				$valor_caculo_item = $valor_unitario;
				$fracionado = null;

				// VERIFICA SE É QUANTIDADE FRACIONADA
				if ($itemPedido['QUANTIDADE'] < 1):

				   // SELECIONA O MAIOR ITEM QUE FOI FRACIONADO NA VENDA
				   $sql = 'SELECT COALESCE(MAX(item_fracionado), 0) AS item_fracionado FROM vendaitem ';
				   $sql .= 'WHERE ven_001 =:venda AND sit_001 = 4 AND (item_fracionado IS NOT NULL AND item_fracionado > 0) ';
				   $stm = $pdo->prepare($sql);
				   $stm->bindValue(':venda', $id_venda);
				   $stm->execute();
				   $ultimo_fracionado = $stm->fetch(PDO::FETCH_OBJ);

				    if ($ultimo_fracionado->item_fracionado == 0):
				  	    $fracionado = 1;
				    else:
				   	    if (COBRAR_MAIOR_VALOR_FRACIONADO):

					  	    // SELECIONA O MAIOR VALOR ENTRE OS ITENS FRACIONADOS DO MESMO PEDIDO
				   	        $sql = 'SELECT MAX(ite_003) as maior_valor, ite_001 as item, ite_002 as qtde FROM vendaitem ';
					        $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado ';
					        $sql .= 'GROUP BY ite_001, ite_002 LIMIT 1';
					     
					        $stm = $pdo->prepare($sql);
					        $stm->bindValue(':venda', $id_venda);
					        $stm->bindValue(':fracionado', $ultimo_fracionado->item_fracionado);
					        $stm->execute();
					        $totalizador = $stm->fetch(PDO::FETCH_OBJ);

						    if ($totalizador->maior_valor > $valor_caculo_item):
						     	$valor_caculo_item = $totalizador->maior_valor;
						    endif;

					     	$sql = 'UPDATE vendaitem SET ite_005 = :valor + COALESCE(acrescimo, 0.0) ';
						    $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:item ';
						    $stm = $pdo->prepare($sql);
						    $stm->bindValue(':valor', ($totalizador->qtde * $valor_caculo_item));
						    $stm->bindValue(':venda', $id_venda);
						    $stm->bindValue(':item', $ultimo_fracionado->item_fracionado);
						    $stm->execute();

				   	    endif;

					    // SOMA A QUANTIDADE DOS ÚLTIMO ITENS FRACIONADOS
				   	    $sql = 'SELECT COALESCE(TRUNC(SUM(ite_002), 1),0) as total FROM vendaitem ';
					    $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado AND sit_001 = 4';
					    $stm = $pdo->prepare($sql);
					    $stm->bindValue(':venda', $id_venda);
					    $stm->bindValue(':fracionado', $ultimo_fracionado->item_fracionado);
					    $stm->execute();
					    $qtde_fracionada = $stm->fetch(PDO::FETCH_OBJ);

					    if ($qtde_fracionada->total >= 0.9):
					   	   $fracionado = $ultimo_fracionado->item_fracionado + 1;
					    else:
					   	   $fracionado = $ultimo_fracionado->item_fracionado;
					    endif;
				    endif; 
				endif;

				$observacao = '';
				if (!empty($itemPedido['TXT_OBSERVACAO']) && !empty($itemPedido['OPC_OBSERVACAO'])):
					$observacao = $itemPedido['TXT_OBSERVACAO'] . ', ' . $itemPedido['OPC_OBSERVACAO'];
				elseif (!empty($itemPedido['TXT_OBSERVACAO'])):
					$observacao = $itemPedido['TXT_OBSERVACAO'];
				elseif (!empty($itemPedido['OPC_OBSERVACAO'])):
					$observacao = $itemPedido['OPC_OBSERVACAO'];
				endif;

				$itens++;
				$sql = 'INSERT INTO vendaitem ';
				$sql .= '(emp_001, ven_001, mat_001, ite_002, ite_003, ite_005, ite_006, ite_009, ite_001, gar_001, ';
				$sql .= 'ite_013, ite_012, sit_001, ite_011, ite_008, tamanho, b_venda_tamanho, item_fracionado,';
				$sql .= 'quantidade_impressao, origem_pedido, mobile_impressao)VALUES ';
				$sql .= '(:emp, :id_venda, :id_material, :quantidade, :valor_unit, :valor_total, :observacao, :hora, :nro_item, ';
				$sql .= ":id_garcom, :cod_impressora, 'N', 4, 'S', 'N', :tamanho, :b_venda_tamanho, :item_fracionado, :quantidade_impressao, 'M', 'N')";
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':emp', '1');
				$stm->bindValue(':id_venda', $id_venda);
				$stm->bindValue(':id_material', $itemPedido['ID_PRODUTO']);
				$stm->bindValue(':quantidade', $itemPedido['QUANTIDADE']);
				$stm->bindValue(':valor_unit', $valor_unitario);
				$stm->bindValue(':valor_total', ($itemPedido['QUANTIDADE'] * $valor_caculo_item));
				$stm->bindValue(':observacao', $observacao);
				$stm->bindValue(':hora', date('H:i:s'));
				$stm->bindValue(':nro_item', $itens);
				$stm->bindValue(':id_garcom', $usuario);
				$stm->bindValue(':cod_impressora', $itemPedido['IMPRESSORA']);
				$stm->bindValue(':tamanho', $itemPedido['TAMANHO_PEDIDO']);
				$stm->bindValue(':b_venda_tamanho', (int) $itemPedido['VENDA_TAMANHO']);
				$stm->bindValue(':item_fracionado', $fracionado);
				$stm->bindValue(':quantidade_impressao', $itemPedido['QUANTIDADE']);
				$retorno = $stm->execute();

				if(!empty($itemPedido['OPCIONAL'])):
					foreach($itemPedido['OPCIONAL'] as $opcional):
						$sql = 'SELECT MAX(ite_001) as ultimo_item FROM vendaitem WHERE ven_001 = :venda';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':venda', $id_venda);
						$stm->execute();
						$item = $stm->fetch(PDO::FETCH_OBJ);

						$sql = 'SELECT valor FROM opcional WHERE id_opcional = :opcional';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':opcional', $opcional);
						$stm->execute();
						$item_opcional = $stm->fetch(PDO::FETCH_OBJ);

						$sql = 'UPDATE vendaitem SET acrescimo = :valor_opcional, ite_005 = (ite_005 + :valor_opcional) ';
					    $sql .= 'WHERE ven_001 =:venda AND ite_001 =:item ';
					    $stm = $pdo->prepare($sql);
					    $stm->bindValue(':valor_opcional', ($itemPedido['QUANTIDADE'] * $item_opcional->valor));
					    $stm->bindValue(':venda', $id_venda);
					    $stm->bindValue(':item', $item->ultimo_item);
					    $stm->execute();

						$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional)VALUES';
						$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional)';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':id_venda', $id_venda);
						$stm->bindValue(':id_vendaitem', $item->ultimo_item);
						$stm->bindValue(':id_opcional', $opcional);
						$stm->execute();
						$opcional = $stm->fetch(PDO::FETCH_OBJ);
					endforeach;
				endif;

				unset($_SESSION['PEDIDO'][$itemPedido['INDICE']]);
			endforeach;

			// ATUALIZA DOS TOTALIZADORES DA VENDA
			$sql = 'SELECT fn_calcula_total_venda(:idvenda, :idempresa)';
			$stm = $pdo->prepare($sql);
			$stm->bindValue(':idvenda', $id_venda);
			$stm->bindValue(':idempresa', 1);
			$stm->execute();

			if (FINALIZAR_IMPRIMI_ITENS):
				// ATUALIZA PENDÊNCIA DE IMPRESSÃO
				$sql = "UPDATE vendaitem SET mobile_impressao = 'S' WHERE ven_001 = :venda AND origem_pedido = 'M' AND mobile_impressao = 'N'";
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':venda', $id_venda);
				$retorno = $stm->execute();
			endif;

			echo json_encode(['status' => 1]);

			$pdo->Commit();

		}catch(Exception $erro){
			$pdo->rollBack();

			if ($aberturaVenda):
				unset($_SESSION['VENDA']);
			endif;

			echo json_encode(['status' => 0, 'mensagem' => $erro->getMessage()]);
		}
	else:
		echo json_encode(['status' => 0]);
	endif;
endif;