﻿<?php
session_start();

require 'conexao.php';
require 'config.php';
require 'includes/inc_verifica_caixa.php';
require 'includes/limpar_session.php';

$pdo  = Conexao::getInstance();
$sql = "SELECT ven_001, ven_027, ven_026 FROM venda WHERE sit_001 IN (8,21) AND ven_024 = 'C' ORDER BY ven_026";
$stm = $pdo->prepare($sql);
$stm->execute();
$comandas = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
  <?php require 'includes/inc_head.php'; ?>
</head>
<body>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title">Comanda Eletrônica</span>
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?>

  	  <main class="mdl-layout__content">
        <div class="block-center">
           <p class="linha-5"></p>
		   <div class = "mdl-textfield mdl-js-textfield mdl-textfield--floating-label pesquisa">
				<input class = "mdl-textfield__input" type = "number" id = "pesquisa">
				<label class = "mdl-textfield__label" for = "text4">Procurar Comanda</label>
		   </div>
        </div>

				<div class="box-comandas">
					<?php foreach($comandas as $comanda):
						$n_comanda = $comanda->ven_026;
						$link = 'pedido.php?tipo=C&comanda='.$comanda->ven_026.'&venda='.$comanda->ven_001;

						$sql = "SELECT sit_001 FROM venda WHERE sit_001 = 21 AND ven_026 = " . $comanda->ven_026;
						$stm = $pdo->prepare($sql);
						$stm->execute();
						$venda = $stm->fetchAll(PDO::FETCH_OBJ);
						$back  = (empty($venda)) ? '' : 'btn-yellow';
						$link  = (empty($venda)) ? $link : 'javascript:void(0)';
						$n_comanda  = (empty($venda)) ? $n_comanda : '';
						?>
						<a href='<?=$link?>' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-mesa <?=$back?>" data-upgraded=",MaterialButton">
							<?=$comanda->ven_026?>
						</a>
					<?php endforeach;?>
				</div>
  	  </main>
		<?php if (EXIBE_BOTAO_ADICIONAR_COMANDA):?>
			<button class="mdl-button mdl-js-button mdl-button--colored btn-rodape-azul adicionar">
				<i class="material-icons">add_circle</i>
				Adicionar Comanda
			</button>
		<?php endif;?>
  	</div>


  <?php include 'includes/inc_js.php'; ?>
  <?php include 'includes/inc_notifica_js.php'; ?>
  <script>
	if (localStorage.hasOwnProperty('carrinho')){
        localStorage.removeItem('carrinho')
	}
	
    $(document).ready(function($) {

        $('.adicionar').on('click', function(){

          swal({
              title: 'Número da Comanda',
              html: "<input autofocus type='number' id='numero' placeholder='Informe o Número' class='inpt-cliente text-red' autocomplete='off'>",
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Abrir Comanda',
              cancelButtonText: 'Cancelar',
              confirmButtonClass: 'btn btn-success',
              cancelButtonClass: 'btn btn-danger',
              buttonsStyling: false,
              reverseButtons: true,
              focusConfirm: true
            }).then((result) => {
              if (result.value) {
                var comanda = $('#numero').val();

                if (comanda.trim() != ''){
                  window.location = './pedido.php?tipo=C&comanda='+comanda;
                }else{
                  swal(
                    'Alerta',
                    'Informe o número da Comanda!',
                    'warning'
                  )
                }
              }
            })
        });

				$('#pesquisa').on('input', function(event) {
					 var termo = $(this).val();

					 if(termo.length >= 0){
							$.ajax({
								 url: 'ajax_pesquisa_comanda.php',
								 type: 'POST',
								 dataType: 'html',
								 data: {termo: termo},
								 beforeSend: function(){
										$('.box-comandas').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");
								 },
								 success: function(retorno){
										$('.box-comandas').html(retorno);
								 }
							});

					 }
				});
    });
  </script>
</body>
</html>
