﻿<?php
session_start();
require 'conexao.php';
require 'config.php';

$sql = "SELECT * FROM impressoras ";
$sql .= "WHERE (computador = '".SERVIDOR."' OR computador IS NULL) ORDER BY codigo";
$stm = $pdo->prepare($sql);
$stm->execute();
$impressoras = $stm->fetchAll(PDO::FETCH_OBJ);

$pCozinha = (isset($_COOKIE['pCozinha'])) ? $_COOKIE['pCozinha'] : '2';
$pBar     = (isset($_COOKIE['pBar'])) ? $_COOKIE['pBar'] : '-1';
$pCaixa   = (isset($_COOKIE['pCaixa'])) ? $_COOKIE['pCaixa'] : '5';
$pPraca   = (isset($_COOKIE['pPraca'])) ? $_COOKIE['pPraca'] : '0';
$valorDeliveryComanda  = (isset($_COOKIE['valorDeliveryComanda'])) ? $_COOKIE['valorDeliveryComanda'] : '0';
?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'includes/inc_head.php'; ?>
</head>
<body>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title"><?=$_COOKIE['usuario']?></span>      
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?> 

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp">
           <div class = "mdl-card__title">
              <h3 class = "mdl-card__title-text">
                 CONFIGURAÇÕES
              </h3>
           </div>

           <form action="">
           <div class = "mdl-card__actions mdl-card--border">

              <br>
              <p class="text-left text-red valor">
                <label class = "mdl-checkbox mdl-js-checkbox mdl-js-ripple-effect" for = "valorDeliveryComanda">
                   <input type = "checkbox" 
                          class="ckb mdl-checkbox__input" 
                          id="valorDeliveryComanda" 
                          name="valorDeliveryComanda" 
                          value="1"
                          <?= ($valorDeliveryComanda == 1) ? 'checked' : '' ?>>
                   <span class = "mdl-checkbox__label"> <strong>Usar valor do DELIVERY nos Pedidos</strong> </span>
                 </label>&nbsp;
              </p><br><br>

             <p class="text-left text-red valor">
                <strong>PRAÇA DE ATEND.: </strong> 
                <select class='select-tamanho tamanho' id="pPraca">
                   <?php if ($pPraca != 0) :?>
                      <option selected value='$pPraca'>PRAÇA <?=$pPraca?></option>
                   <?php endif; ?>
                   <option value='0'>NENHUMA</option>
                   <option value='1'>PRAÇA 1</option>
                   <option value='2'>PRAÇA 2</option>
                   <option value='3'>PRAÇA 3</option>
                   <option value='4'>PRAÇA 4</option>
                   <option value='5'>PRAÇA 5</option>
                   <option value='6'>PRAÇA 6</option>
                   <option value='7'>PRAÇA 7</option>
                   <option value='8'>PRAÇA 8</option>
                   <option value='9'>PRAÇA 9</option>
                   <option value='10'>PRAÇA 10</option>
                </select>
              </p><br><br>

              <p class="text-left text-red valor">
                <strong>PRÉ FECHAMENTO: </strong> 
                <select class='select-tamanho tamanho' id="pCaixa">
                    <?php foreach($impressoras as $impressora):?>
                      <?php if ($pCaixa == $impressora->codigo) :?>
                        <option selected value='<?=$impressora->codigo?>'><?=$impressora->nome?></option>
                      <?php else: ?>
                        <option value='<?=$impressora->codigo?>'><?=$impressora->nome?></option>
                      <?php endif; ?>
                    <?php endforeach;?> 
                </select>
              </p>
              <br><br>
              <p class="text-left text-red valor">
                <strong>ATENÇÃO:</strong> No Servidor é necessário estar habilitado o gerenciamento MOBILE do Pré-Fechamento em: Configurações > Vendas > Mobile.             
              </p>

              <p class="text-left text-red valor">
                <strong>IMPR. SEGUNDO BAR: </strong> 
                <select class='select-tamanho tamanho' id="pBar">
                    <option selected value='-1'>NENHUMA</option>
                    <?php foreach($impressoras as $impressora):?>
                      <?php if ($pBar == $impressora->codigo) :?>
                        <option selected value='<?=$impressora->codigo?>'><?=$impressora->nome?></option>
                      <?php else: ?>
                        <option value='<?=$impressora->codigo?>'><?=$impressora->nome?></option>
                      <?php endif; ?>
                      <?php endforeach;?> 
                </select>
              </p>
              <br><br>
              <p class="text-left text-red valor">
                <strong>ATENÇÃO:</strong> Só alterar em casos onde o estabelecimento possuir 2 bares para impressão, a impressora do BAR principal precisa estar com código "3".            
              </p>
 
           </div>
           </form>
        
           <div class = "mdl-card__actions mdl-card--border totalizador detalhe">
              <a href="javascript:window.history.go(-1)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes">
                 <i class="material-icons">arrow_back</i> VOLTAR
              </a>&nbsp;
              <a href="javascript::void(0)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-green btn-gravar">
                 <i class="material-icons">done</i> GRAVAR
              </a>&nbsp;
           </div>          
        </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
    $(document).ready(function($) {	

    	$('.btn-gravar').click(function(event) { 
        var pCaixa = $('#pCaixa').val()
        var pPraca = $('#pPraca').val()
        var pBar = $('#pBar').val()
        var valorDeliveryComanda = 0

        if ( $('#valorDeliveryComanda').prop('checked') ){
           valorDeliveryComanda = 1
        }

        swal({
           title: 'Gravar Configurações?',
           type: 'question',
           showCancelButton: true,
           confirmButtonColor: '#3085d6',
           cancelButtonColor: '#d33',
           confirmButtonText: 'Sim, Gravar!',
           cancelButtonText: 'Não Gravar!',
           confirmButtonClass: 'btn btn-success',
           cancelButtonClass: 'btn btn-danger',
           buttonsStyling: false,
           reverseButtons: true
         }).then((result) => {
           if (result.value) {
              $.ajax({
                  url: 'ajax_gravar_config.php',
                  type: 'POST',
                  dataType: 'JSON',
                  data: {pCaixa: pCaixa, pPraca: pPraca, valorDeliveryComanda: valorDeliveryComanda, pBar: pBar},
                  beforeSend: function(){
                     EasyLoading.show({});
                  },
                  success: function(retorno){
                     EasyLoading.hide();
                     if (retorno.status == 1){
                          swal(
                            'Aviso',
                            'Gravado com sucesso!',
                            'success'
                          )
                     }
                  }
               });
           } 
         }) 
      });

    });
  </script>
</body>
</html>