﻿<?php
session_start();
require 'conexao.php';
require 'config.php';

function calculaTempo($hora_inicial, $hora_final) {
    // se hora inicial for nula, não tem como calcular
    if (empty($hora_inicial) || empty($hora_final)) {
        return "00:00:00";
    }
    $inicio = DateTime::createFromFormat('H:i:s', $hora_inicial);
    $fim    = DateTime::createFromFormat('H:i:s', $hora_final);
    if (!$inicio || !$fim) {
        return "00:00:00"; // fallback se o formato não bater
    }
    $intervalo = $inicio->diff($fim);
    return $intervalo->format('%H:%I:%S');
}

$venda = (isset($_GET['venda'])) ? $_GET['venda'] : '' ;
$item  = (isset($_GET['item'])) ? $_GET['item'] : '' ;

$labelControle = '';
if ($_SESSION['TIPO'] == 'M'):
  $labelControle = 'Mesa ' . str_pad($_SESSION['CONTROLE'], 2, '0', STR_PAD_LEFT);
elseif ($_SESSION['TIPO'] == 'C'):

  switch (TIPO_COMANDA):
    case 0:
      if (!empty($_SESSION['CONTROLE'])):
         $labelControle = 'Comanda ' . str_pad($_SESSION['CONTROLE'], 2, '0', STR_PAD_LEFT);
      endif;

      if (!empty($_SESSION['CLIENTE'])):
         $labelControle = $_SESSION['CLIENTE'];
         $labelControle .= (!empty($_SESSION['CONTROLE'])) ? ' | Nº: ' . str_pad($_SESSION['CONTROLE'], 2, '0', STR_PAD_LEFT) : '';
       endif;
      break;
    case 1:
      if (!empty($_SESSION['CONTROLE'])):
       $labelControle = 'Comanda ' . str_pad($_SESSION['CONTROLE'], 2, '0', STR_PAD_LEFT);
      endif;
      break;
    case 2:
    if (!empty($_SESSION['CONTROLE'])):
         $labelControle = 'Com.: ' . str_pad($_SESSION['CONTROLE'], 2, '0', STR_PAD_LEFT);
    endif;

    if (!empty($_SESSION['CLIENTE'])):
         $labelControle .= (!empty($_SESSION['CONTROLE'])) ? ' | ' . str_pad($_SESSION['CLIENTE'], 2, '0', STR_PAD_LEFT) : '';
       endif;
      break;
    default:
      $labelControle = 'Não Identificado';
      break;
  endswitch;
endif;

$pdo  = Conexao::getInstance();
$sql = "SELECT i.ite_001, i.mat_001, i.ite_002, m.mat_003, i.ite_011, i.ite_005, i.ven_001, ";
$sql .= "i.ite_006, i.ite_009, i.tamanho, i.gar_001, v.ven_025, v.ven_026, v.ven_024, m.b_venda_tamanho ";
$sql .= "FROM venda v INNER JOIN vendaitem i ON v.ven_001 = i.ven_001 ";
$sql .= "INNER JOIN materiais m ON m.mat_001 = i.mat_001 ";
$sql .= "WHERE i.sit_001 = 4 AND v.sit_001 = 8 ";
$sql .= "AND i.ite_001 = {$item} AND v.ven_001 = {$venda}";
$sql .= "ORDER BY i.ite_001 ";
$stm = $pdo->prepare($sql);
$stm->execute();
$item = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT o.descricao, o.valor ';
$sql .= 'FROM vendaitemopcional v INNER JOIN opcional o ON v.id_opcional = o.id_opcional ';
$sql .= 'WHERE id_venda = :id_venda and id_vendaitem = :item';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_venda', $item->ven_001);
$stm->bindValue(':item', $item->ite_001);
$stm->execute();
$opcionais = $stm->fetchAll(PDO::FETCH_OBJ);

$sql = 'SELECT usu_002 FROM usuarios ';
$sql .= 'WHERE usu_001 = :id_usuario';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_usuario', $item->gar_001);
$stm->execute();
$usuario = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT b_cancelamento_mesa FROM usuarios ';
$sql .= 'WHERE usu_001 = :id_usuario';
$stm = $pdo->prepare($sql);
$stm->bindValue(':id_usuario', $_COOKIE['id']);
$stm->execute();
$autorizacao = $stm->fetch(PDO::FETCH_OBJ);

$sql = "SELECT DISTINCT tamanho_p, tamanho_m, tamanho_g, tamanho_gg, tamanho_extra ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetch(PDO::FETCH_OBJ);

switch ($item->tamanho) :
   case 'P':
      $descricao = $tamanhos->tamanho_p;
      break;
   case 'M':
      $descricao = $tamanhos->tamanho_m;
      break;
   case 'G':
      $descricao = $tamanhos->tamanho_g;
      break;
   case 'GG':
      $descricao = $tamanhos->tamanho_gg;
      break;
   case 'E':
      $descricao = $tamanhos->tamanho_extra;
      break;
endswitch;

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'includes/inc_head.php'; ?>
</head>
<body>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title"><?=$labelControle?></span>
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?>

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp">
           <div class = "mdl-card__title">
              <h3 class = "mdl-card__title-text">
                 DETALHES
              </h3>
           </div>

           <div class = "mdl-card__actions mdl-card--border">
              <p class="text-left text-red valor">
                <strong><?=number_format($item->ite_002, 3, ',', '.')?> - <?=$item->mat_003?></strong>
              </p><p></p>
              <p class="text-left text-red valor">
                <strong>GARÇOM: </strong> <?=$usuario->usu_002?>
              </p><br>
              <p class="text-left text-red valor">
                <strong>VALOR: </strong> R$ <?=number_format($item->ite_005, 2, ',', '.')?>
              </p><br>
              <p class="text-left text-red valor">
                <strong>HORA: </strong> <?=$item->ite_009?>
              </p><br>
              <p class="text-left text-red valor">
                <strong>TEMPO DECORRIDO: </strong> <?=calculaTempo($item->ite_009, date('H:i:s'))?>
              </p><br>
              <?php if( $item->b_venda_tamanho && !empty($item->tamanho) ):?>
                <p class="text-left text-red valor">
                  <strong>TAMANHO: </strong> <?=$descricao?>
                </p><br>
              <?php endif; ?>
              <?php if(!empty($opcionais)):?>
                <?php foreach($opcionais as $opcional): ?>
                  <p class="text-left text-red valor">
                    <strong>OPCIONAL: </strong> <?=$opcional->descricao?>
                  </p><br>
                <?php endforeach; ?>
              <?php endif; ?>
              <?php if(!empty($item->ite_006)):?>
                <p class="text-left text-red valor">
                  <strong>OBS: </strong> <?=$item->ite_006?>
                </p><br>
              <?php endif; ?>
           </div>

           <div class = "mdl-card__actions mdl-card--border totalizador detalhe">
              <a href="javascript:window.history.go(-1)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes">
                 <i class="material-icons">arrow_back</i> VOLTAR
              </a>&nbsp;
              <!--
              <?php if ($autorizacao->b_cancelamento_mesa):?>
                <a href="javascript::void(0)" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-red btn-excluir">
                   <i class="material-icons">clear</i> EXCLUIR
                </a>&nbsp;
              <?php endif; ?>
              -->
           </div>
        </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
    $(document).ready(function($) {

    	$('.btn-excluir').click(function(event) {
        var item = '<?=$item->ite_001?>';
        var venda = '<?=$venda?>';

        swal({
           title: 'Excluir Item?',
           type: 'question',
           showCancelButton: true,
           confirmButtonColor: '#3085d6',
           cancelButtonColor: '#d33',
           confirmButtonText: 'Sim, Excluir!',
           cancelButtonText: 'Não Excluir!',
           confirmButtonClass: 'btn btn-success',
           cancelButtonClass: 'btn btn-danger',
           buttonsStyling: false,
           reverseButtons: true
         }).then((result) => {
           if (result.value) {
              $.ajax({
                  url: 'ajax_excluir_produto.php',
                  type: 'POST',
                  dataType: 'JSON',
                  data: {id_venda: venda, item: item},
                  beforeSend: function(){
                     EasyLoading.show({});
                  },
                  success: function(retorno){
                     EasyLoading.hide();
                     if (retorno.status == 1){
                        Snackbar.show({text: 'Produto excluído com sucesso!',
                                       actionText: 'Fechar',
                                       duration: 2000,
                                       pos: 'bottom-left'
                                    });
                        setTimeout(function(){
                          window.location = 'pedido.php?venda=<?=$venda?>&tipo=<?=$item->ven_024?>';
                        }, 1000)
                     }
                  }
               });
           }
         })
      });

    });
  </script>
</body>
</html>
