﻿<?php
session_start();
require 'conexao.php';
require 'config.php';

$venda    = (isset($_GET['venda'])) ? $_GET['venda'] : '' ;
$id_produto  = (isset($_GET['codigo'])) ? $_GET['codigo'] : '' ;
$mesa  = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda  = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$tipo  = (isset($_GET['tipo'])) ? $_GET['tipo'] : '' ;

$sql = 'SELECT mat_004, mat_003, tamanho_padrao, b_venda_tamanho FROM materiais WHERE mat_001 = :codigo';
$stm = $pdo->prepare($sql);
$stm->bindValue(':codigo', $id_produto);
$stm->execute();
$produto = $stm->fetch(PDO::FETCH_OBJ);

$sql = 'SELECT DISTINCT e.*, ep.ordem ';
$sql .= 'FROM etapa_produtos ep INNER JOIN etapa e ON ep.id_etapa = e.id ';
$sql .= 'INNER JOIN etapa_opcoes eo ON eo.id_etapa = ep.id_etapa         ';
$sql .= 'WHERE eo.exporta_integracao AND ep.status = 1 AND e.status = 1  ';
$sql .= 'AND eo.status = 1 AND ep.id_produto = :codigo AND e.exibe_salao = 1 ';
$sql .= 'ORDER BY ep.ordem';
$stm = $pdo->prepare($sql);
$stm->bindValue(':codigo', $produto->mat_004);
$stm->execute();
$etapas = $stm->fetchAll(PDO::FETCH_OBJ);

$sql = "SELECT DISTINCT tamanho_p, tamanho_m, tamanho_g, tamanho_gg, tamanho_extra ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetch(PDO::FETCH_OBJ);

switch ($produto->tamanho_padrao) :
  case 'P':
      $descricao = $tamanhos->tamanho_p;
      break;
  case 'M':
      $descricao = $tamanhos->tamanho_m;
      break;
  case 'G':
      $descricao = $tamanhos->tamanho_g;
      break;
  case 'GG':
      $descricao = $tamanhos->tamanho_gg;
      break;
  case 'E':
      $descricao = $tamanhos->tamanho_extra;
      break;
  default:
      $descricao = $tamanhos->tamanho_m;
endswitch;
$tamanhoAbreviado = $produto->tamanho_padrao;

if ($tipo == 'M'):
  $linkListagem = "pedido.php?mesa={$mesa}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
elseif($tipo == 'C'):
  $linkListagem = "pedido.php?comanda={$comanda}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
endif;

if ($tipo == 'M'):
  $linkListagem = "pedido.php?mesa={$mesa}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
elseif($tipo == 'C'):
  $linkListagem = "pedido.php?comanda={$comanda}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
endif;

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'includes/inc_head.php'; ?>
  <style>
      .footer {
        position: absolute;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1000;
        background:#d6d7da;
      }
      .box-altura{
        display: block;
        height: 70px;
      }
      .btn-rodape{
        height: 50px;
      }
      .select-tamanho {
        width: 25%;
        padding: 8px 6px;
        margin: 8px 5px 8px 0;
    }

    hr{
      margin-bottom: 10px;
    }

    p.titulo {
        font-weight: bold;
    }

    p.sub-titulo {
        color: #828181;
    }

    .sub-texto {
        color: #828181;
        font-weight: bold;
        font-size: 13px;
    }

    label {
        font-size: 15px;
        margin: -1px 0;
        display: block;
    }

    .produto{
      font-size: 15px;
      font-weight: bold;
    }

    input[type=checkbox], input[type=radio] {
        transform: scale(1.5);
    }

    .alert-flash {
        animation: 700ms flash-color forwards;
        z-index: 999999;
    }

    @keyframes flash-color {
        0% {
            background-color: #f6f6f6;
            color: #333;
        }
        50% {
            background-color: rgb(253, 181, 181);
            color: #333;
        }
        100% {
            background-color: #f6f6f6;
            color: #333;
        }
    }

    .qtde-item{
      position: relative;
      top: 3px;
      border: none;
    }

    .opcao-qtde {
        position: relative;
        top: 7px;
    }

    .box-qtde{
      margin-right: 10px;
      display: flex;
      flex-direction: row;
      justify-content: space-around;
    }

    .container-qtde {
        width: 35px;
    }

    .btn-qtde{
      font-size: 35px !important;
    }

    .mdl-textfield {
      padding: 0;
    }

    .btn-subtrai{
      display: block;
      margin: 0;
      padding: 0;
      width: 35px;
      height: 35px;
      background: #e74c3c;
      color: white;
      border-radius: 7px;
      z-index: 1000;
    }

    .btn-adiciona{
      display: block;
      margin: 0;
      padding: 0;
      width: 35px;
      height: 35px;
      background: green;
      color: white;
      border-radius: 7px;
      z-index: 1000;
    }
  </style>
</head>
<body>
   <script>loadPagina()</script>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header page">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title">ETAPAS DO PEDIDO</span>
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?>

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp conteudo">
           <div class = "mdl-card__actions mdl-card--border">
              <p class='produto'>
                <?=$produto->mat_003?>
              </p>
              <hr>
              <p class="text-left text-red valor">
              <strong>QTDE: </strong>
                <select id="qtde"  class="select-tamanho">
                  <option value="1">1</option>
                  <option value="2">2</option>
                  <option value="3">3</option>
                  <option value="4">4</option>
                  <option value="5">5</option>
                </select>
              </p>
              <?php if ($produto->b_venda_tamanho): ?>
                  <p class="text-left text-red valor">
                    <strong>TAMANHO: </strong>
                    <select id="tamanho" class="select-tamanho">
                      <option value="<?=$tamanhoAbreviado?>"><?=$descricao?></option>
                      <option value="P">Pequeno</option>
                      <option value="M">Médio</option>
                      <option value="G">Grande</option>
                    </select>
                  </p><br><br>
              <?php endif; ?>
           </div>
        </div>

        <div class="etapas">
          <a href="#etapa-<?=$etapa->id?>"></a>

          <?php foreach($etapas as $etapa): 

            $sub_texto = '';
            if ($etapa->maximo_soma_qtde_etapa >= 1):
              $sub_texto = '* resposta obrigatória - escolha '.$etapa->maximo_soma_qtde_etapa .' opções';
            elseif ($etapa->resposta_minima == 1 && $etapa->resposta_maxima == 1):
              $sub_texto = 'resposta obrigatória';
            elseif ($etapa->resposta_minima >= 1 && $etapa->resposta_maxima > 1):
              $sub_texto = 'escolha de '.$etapa->resposta_minima.' até '.$etapa->resposta_maxima.' opções';
            elseif ($etapa->resposta_minima == 0 && $etapa->resposta_maxima > 1):
              $sub_texto = 'escolha até '.$etapa->resposta_maxima.' opções';
            elseif ($etapa->resposta_minima == 0 && $etapa->resposta_maxima == 0):
              $sub_texto = '';
            endif;
            
            ?>
            <div class = "wide-card mdl-card mdl-shadow--4dp conteudo">
                <div class = "mdl-card__actions mdl-card--border">
                    <p class='etapa titulo fase-<?=$etapa->id?>' 
                       id="<?=$etapa->id?>" 
                       data-id="<?=$etapa->id?>" 
                       data-tipo="<?=$etapa->tipo?>" 
                       data-resposta-obrigatoria="<?= (int) $etapa->resposta_obrigatoria ?>" 
                       data-resposta-minima="<?=$etapa->resposta_minima?>" 
                       data-resposta-maxima="<?=$etapa->resposta_maxima?>"
                       data-maximo-soma-etapa="<?=$etapa->maximo_soma_qtde_etapa?>">
                      <?=$etapa->titulo?>
                    </p>
                    <p class='sub-titulo text-red sub-<?=$etapa->id?>'><?=$sub_texto?></p>
                    <br>
                    <?php
                    $sql = 'SELECT DISTINCT eo.* ';
                    $sql .= 'FROM etapa_produtos ep INNER JOIN etapa e ON ep.id_etapa = e.id ';
                    $sql .= 'INNER JOIN etapa_opcoes eo ON eo.id_etapa = ep.id_etapa ';
                    $sql .= 'WHERE eo.exporta_integracao AND ep.status = 1 AND eo.status = 1 AND ep.id_produto = :codigo AND e.id = :etapa ';
                    $sql .= 'ORDER BY eo.titulo';
                    $stm = $pdo->prepare($sql);
                    $stm->bindValue(':codigo', $produto->mat_004);
                    $stm->bindValue(':etapa', $etapa->id);
                    $stm->execute();
                    $opcoes = $stm->fetchAll(PDO::FETCH_OBJ);

                    foreach($opcoes as $opcao):
                      
                      if ($etapa->tipo == 'A'):
                        $valor = '';
                      else:
                        $valor = "<span class='sub-texto'> (R$ ".number_format($opcao->valor_etapa, 2, ',', '.').")</span>";
                      endif;

                      if ($etapa->maximo_soma_qtde_etapa >= 1): ?>

                        <div class='box-qtde text-left'>
                          <a href="javascript:void(0)" 
                            class="btn-subtrai" 
                            data-id="<?=$opcao->id?>" 
                            data-etapa="<?=$etapa->id?>">
                            <i class="material-icons md-48 btn-qtde">remove</i>
                          </a>
                          <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                            <input type="number" 
                                   class="mdl-textfield__input quantidade qtde-item etapa-qtde-<?=$etapa->id?>" 
                                   data-descricao="<?=$opcao->titulo?>"
                                   data-id="<?=$opcao->id?>"
                                   data-id-registro="<?=$opcao->id_registro?>" 
                                   data-tipo="<?=$etapa->tipo?>" 
                                   id="quantidade-<?=$opcao->id?>" value="0">
                          </div>
                          <a href="javascript:void(0)" 
                            class="btn-adiciona" 
                            data-id="<?=$opcao->id?>" 
                            data-etapa="<?=$etapa->id?>">
                            <i class="material-icons md-48 btn-qtde">add</i>
                          </a>
                        </div>
                        <p data-valor="<?=$opcao->valor_etapa?>" 
                            data-id-registro="<?=$opcao->id_registro?>" 
                            id="etapa<?=$opcao->id?>" 
                            name="etapa<?=$opcao->id_etapa?>" 
                            class="opcao-qtde opcao etapa-<?=$opcao->id_etapa?>" 
                            value="<?=$opcao->titulo?>">  <?=$opcao->titulo?></p>
                        <br><br>

                     <?php else: 
                          if ($etapa->resposta_minima == 1 && $etapa->resposta_maxima == 1): ?>
                            <label class="opcao" data-etapa="<?=$opcao->id_etapa?>" data-opcao="<?=$opcao->id?>">
                            <input type="radio" data-valor="<?=$opcao->valor_etapa?>" 
                                                  data-id-registro="<?=$opcao->id_registro?>" 
                                                  id="etapa<?=$opcao->id?>" 
                                                  name="etapa<?=$opcao->id_etapa?>" 
                                                  class="opcao etapa-<?=$opcao->id_etapa?>" 
                                                  value="<?=$opcao->titulo?>"> <?=$opcao->titulo?> <?=$valor?>
                            </label><br>
                          <?php else: ?>
                            <label class="opcao" data-etapa="<?=$opcao->id_etapa?>" data-opcao="<?=$opcao->id?>">
                            <input type="checkbox" data-valor="<?=$opcao->valor_etapa?>" 
                                                    data-id-registro="<?=$opcao->id_registro?>" 
                                                    id="etapa<?=$opcao->id?>" 
                                                    class="opcao etapa-<?=$opcao->id_etapa?>" 
                                                    value="<?=$opcao->titulo?>"> <?=$opcao->titulo?> <?=$valor?>
                            </label><br>
                          <?php endif; ?>
                      <?php endif; ?>

                    <?php endforeach; ?>
                </div>
            </div>
          <?php endforeach; ?>
        </div>

        <div class="box-altura"></div>
          <div class = "mdl-shadow--4dp footer mdl-card__actions mdl-card--border container-finalizar <?=$exibe_finalizacao?>">
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-red" onclick="javascript:window.history.go(-1)" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">arrow_back</i>
                VOLTAR
            </button>
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-green btn-finalizar" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">check_circle</i>
                PRÓXIMO
            </button>
          </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
     function preloader(){
         EasyLoading.hide();
         $('#page').show();
      }
      window.onload = preloader;

     $(document).ready(function($) {

       var arrayEtapa = []
       var arrayOpcionais = []

        function alertTitleEtapa(classe, id) {
          let title_el = document.querySelector('.' + classe)
          title_el.classList.add('alert-flash')

          let sub = document.querySelector('.sub-' + id)
          sub.classList.add('alert-flash')

          window.location.href = "#"+id;

          setTimeout(() => {
              document.querySelector('.' + classe).classList.remove('alert-flash')
              document.querySelector('.sub-' + id).classList.remove('alert-flash')
          }, 2000)
        }
          
        function preenchimentoValido(){
          let erro = 0;
          let id = 0

          $('.etapa').each(function(index){
            let resposta_obrigatoria = $(this).attr('data-resposta-obrigatoria')
            let resposta_minima = $(this).attr('data-resposta-minima')
            let resposta_maxima = $(this).attr('data-resposta-maxima')
            let maximo_soma_resposta_etapa = parseFloat( $(this).attr('data-maximo-soma-etapa') ) 
            let marcado = 0
            let etapa = this
            id = $(this).attr('data-id')

            if (maximo_soma_resposta_etapa > 0 ){
                if ( !isQtdeValidaEtapa(id) ){
                  erro++;
                  return false;
                }
            }else{
              $('.etapa-' + id).each(function(i){
                if ( $(this).prop('checked') ){
                  marcado++;
                }
              })

              if (resposta_obrigatoria == 1 && marcado == 0){
                erro++;
                return false;
              }
            }

          });

          if (erro > 0){
            alertTitleEtapa('fase-'+id, id)
          }

          return (erro == 0)
        }

        function preencheArray(){
          let ordem = 0 

          $('.etapa').each(function(index){
            let tipo = $(this).attr('data-tipo')
            let id = $(this).attr('data-id')
            let maximo_soma_resposta_etapa = parseFloat( $(this).attr('data-maximo-soma-etapa') )

            if ( maximo_soma_resposta_etapa > 0 ){
              $('.etapa-qtde-'+id).each(function(){
                  let valor = 0
                  let id_registro = $(this).attr('data-id-registro')
                  let descricao = $(this).attr('data-descricao')
                  let tipo = $(this).attr('data-tipo')
                  let qtde = parseFloat( $(this).val() )
                  ordem++

                  if (qtde > 0){
                    arrayEtapa.push({ 
                        ordem: ordem,
                        id: id_registro, 
                        descricao: descricao, 
                        valor: valor, 
                        tipo: tipo, 
                        quantidade: qtde })
                  }
              }) 
            }else{
              $('.etapa-' + id).each(function(i){
                  if ( $(this).prop('checked') ){
                    let id_registro = $(this).attr('data-id-registro')
                    let descricao = $(this).val()
                    let valor = $(this).attr('data-valor')
                    ordem++
                    
                    arrayEtapa.push({
                        ordem: ordem,
                        id: id_registro, 
                        descricao: descricao, 
                        valor: valor, 
                        tipo: tipo, quantidade: 1})
                  }
              })
            }
          });
        }

        $('.btn-finalizar').on('click', function(){
          
          if (preenchimentoValido()){
            let id = '<?=$id_produto?>'
            let qtde = $('#qtde option:selected').text()
            let tamanho = $('#tamanho').val()
            let qtde_real = parseFloat($('#qtde').val())
            let contador = 0
            let ordem = 1
            preencheArray();

            let carrinho = []
            let produto = {}
            let produtos = JSON.parse(localStorage.getItem('produtos'))

            if (localStorage.hasOwnProperty('carrinho')){
              carrinho = JSON.parse(localStorage.getItem('carrinho'))
              
              if ( carrinho.length > 0 ){
                  carrinho.sort((a, b) => Number(b.ordem) - Number(a.ordem))
                  ordem = carrinho[0].ordem + 1
              }
            }

            let produto_selecionado = produtos.filter(prod => (prod.mat_001 == id))
            
            if (produto_selecionado){
              indice = ((new Date().getTime() / 1000) * Math.random()).toString()
              produto.ordem = ordem
              produto.indice = indice.replace(/\./g, '')
              produto.id = produto_selecionado[0].mat_001
              produto.codigo = produto_selecionado[0].mat_004
              produto.descricao = produto_selecionado[0].mat_003
              produto.vende_tamanho = produto_selecionado[0].b_venda_tamanho
              produto.vende_fracionado = produto_selecionado[0].fracionado
              produto.vende_balanca = produto_selecionado[0].b_peso_balanca
              produto.quantidade = qtde_real.toFixed(3)
              produto.tamanho_padrao = produto_selecionado[0].tamanho_padrao
              produto.tamanho_pedido = (tamanho != undefined) ? tamanho : 'M'
              produto.valor_p = produto_selecionado[0].valor_tam_p 
              produto.valor_m = produto_selecionado[0].valor_tam_m  
              produto.valor_g = produto_selecionado[0].valor_tam_g 
              produto.valor_gg = produto_selecionado[0].valor_tam_gg  
              produto.valor_extra = produto_selecionado[0].valor_tam_extra 
              produto.impressora = produto_selecionado[0].impressora 
              produto.id_fracionado = 0
              produto.categoria = produto_selecionado[0].cat_001 
              produto.status = 'A'
              produto.observacao = ''
              produto.opcao_observacao = ''
              produto.opcional = arrayOpcionais
              produto.pacote = arrayEtapa

              carrinho.push(produto)
              localStorage.setItem('carrinho', JSON.stringify(carrinho))
              EasyLoading.hide();

              Snackbar.show({text: 'Produto adicionado com sucesso!',
                                      actionText: 'Fechar',
                                      duration: 1000,
                                      pos: 'top-left'
                                    });
                                
              setTimeout(() => {
                        EasyLoading.show({text: 'Aguarde, carregando ...'})
                        window.location.href = '<?=$linkListagem?>'
                    }, 500)
            }
          }
        })

        $('.opcao').on('click', function(){
          let etapa = $(this).attr('data-etapa')
          let opcao = $(this).attr('data-opcao')
          let resposta_minima = $('#'+etapa).attr('data-resposta-minima')
          let resposta_maxima = $('#'+etapa).attr('data-resposta-maxima')
          let marcado = 0

          $('.etapa-'+etapa).each(function(){
            if ( $(this).prop('checked') ){
              marcado++;
            }
          })

          if (resposta_minima >= 1 && marcado == 0){
            alertTitleEtapa('fase-'+etapa, etapa)
            $('#etapa'+opcao).prop('checked', false)
          }else if (resposta_maxima >= 1 && marcado > resposta_maxima){
            alertTitleEtapa('fase-'+etapa, etapa)
            $('#etapa'+opcao).prop('checked', false)
          }

        })

        $('#qtde').on('change', function(){
          let qtde = $(this).val()
        })

        function somaQtdeSelecionada(id_etapa){
          let selecionado = 0

          $('.etapa-qtde-'+id_etapa).each(function(){
            selecionado += parseFloat( $(this).val() )
          })

          return selecionado
        }

        function isQtdeValidaEtapa(etapa){
          let selecionado = somaQtdeSelecionada(etapa)
          let qtde_combo = parseFloat( $('#qtde').val() )
          let qtde_permitida_etapa = parseFloat( $('#'+etapa).attr('data-maximo-soma-etapa') ) 
          
          $('.sub-' + etapa).text( '* resposta obrigatória - escolha '+(qtde_combo * qtde_permitida_etapa)+' opções' )

          return ( (qtde_combo * qtde_permitida_etapa) == selecionado)
        }

        $(document).on('click', '.btn-adiciona', function(event) {
            let id   = $(this).attr('data-id')
            let etapa = $(this).attr('data-etapa')
            let qtde_opcao = parseFloat ($('#quantidade-'+id).val() )
            let qtde_combo = parseFloat( $('#qtde').val() )
            let qtde_permitida_etapa = parseFloat( $('#'+etapa).attr('data-maximo-soma-etapa') ) 
            let qtde_selecionada = somaQtdeSelecionada(etapa)

            qtde_opcao += parseFloat(1)

            if ( (qtde_combo * qtde_permitida_etapa) > qtde_selecionada){
               $('#quantidade-'+id).val( qtde_opcao )
            }else{
               alertTitleEtapa('fase-'+etapa, etapa)
            }
        })

        $(document).on('click', '.btn-subtrai', function(event) {
            var id   = $(this).attr('data-id');
            var qtde = parseFloat($('#quantidade-'+id).val());

            if (qtde > 1){
              qtde -= parseFloat(1)
              $('#quantidade-'+id).val(qtde);
            }
        })

    });
  </script>
</body>
</html>
