<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

function CapturaIdPromocao($idProduto, $tamanho, $canal)
{
    $sql = 'SELECT COALESCE(pp.id_promocao, 0) as id                            ';
    $sql .= 'FROM promocao_produto pp                                           ';
    $sql .= 'INNER JOIN promocao_agenda pa ON pp.id_promocao = pa.id_promocao   ';
    $sql .= 'INNER JOIN promocao p ON p.id = pp.id_promocao                     ';
    $sql .= 'WHERE p.status = 1 AND pa.dia_semana = :DIA_SEMANA AND             ';
    $sql .= 'pa.hora_inicio <= :HORA_ATUAL1 AND pa.hora_fim >= :HORA_ATUAL2 AND ';
    $sql .= 'pp.id_produto = :ID_PRODUTO AND pp.tamanho = :TAMANHO';
    $sql .= ($canal == 'M') ? ' AND mesa = 1' : ' AND comanda = 1';

    $hoje = date('Y-m-d');
    $hora_atual = date('H:i:s');
    $dia_semana = date('w', strtotime($hoje));

    $pdo = Conexao::getInstance();
    $stm = $pdo->prepare($sql);
    $stm->bindValue(':DIA_SEMANA', $dia_semana + 1);
    $stm->bindValue(':HORA_ATUAL1', $hora_atual);
    $stm->bindValue(':HORA_ATUAL2', $hora_atual);
    $stm->bindValue(':ID_PRODUTO', $idProduto);
    $stm->bindValue(':TAMANHO', $tamanho);
    $stm->execute();
    $produto = $stm->fetch(PDO::FETCH_OBJ);

    return (!empty($produto)) ? $produto->id : 0;
}

function CapturaValorPromocao($idProduto, $tamanho, $canal)
{
    //$sql = 'SELECT COALESCE(valor, 0.00) as valor                               ';
    // $sql .= 'FROM promocao_produto pp                                           ';
    //$sql .= 'INNER JOIN promocao_agenda pa ON pp.id_promocao = pa.id_promocao   ';
    //$sql .= 'INNER JOIN promocao p ON p.id = pp.id_promocao                     ';
    // $sql .= 'WHERE p.status = 1 AND pa.dia_semana = :DIA_SEMANA AND             ';
    //$sql .= 'pa.hora_inicio <= :HORA_ATUAL1 AND pa.hora_fim >= :HORA_ATUAL2 AND ';
    //$sql .= 'pp.id_produto = :ID_PRODUTO AND pp.tamanho = :TAMANHO';
    //$sql .= ($canal == 'M') ? ' AND mesa = 1' : ' AND comanda = 1';

    $sql = 'SELECT COALESCE(pp.hh_valor, 0.00) as valor ';
    $sql .= ' FROM materiais pp  ';


    $hoje = date('Y-m-d');
    $hora_atual = date('H:i:s');
    $dia_semana = date('w', strtotime($hoje));
    $i = $dia_semana + 1;
    switch ($i) {
        case 1:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_dom = true AND  ';
            break;
        case 2:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_seg = true AND  ';
            break;
        case 3:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_ter = true AND  ';
            break;
        case 4:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_qua = true AND  ';
            break;
        case 5:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_qui = true AND  ';
            break;
        case 6:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_sex = true AND  ';
            break;
        case 7:
            $sql .= ' WHERE pp.hh_ativar is true AND pp.hh_dia_sab = true AND  ';
            break;
    }

    $sql .= ' pp.hh_inicial <= :HORA_ATUAL1 AND pp.hh_final >= :HORA_ATUAL2 AND pp.mat_001 = :ID_PRODUTO  ';
    $sql .= ($canal == 'M') ? ' AND pp.hh_tipo_mesa = true' : ' AND pp.hh_tipo_mesa = true';


    $pdo = Conexao::getInstance();
    $stm = $pdo->prepare($sql);

    $stm->bindValue(':HORA_ATUAL1', $hora_atual);
    $stm->bindValue(':HORA_ATUAL2', $hora_atual);
    $stm->bindValue(':ID_PRODUTO', $idProduto);
    //$stm->bindValue(':TAMANHO', $tamanho);
    $stm->execute();
    $produto = $stm->fetch(PDO::FETCH_OBJ);

    return (!empty($produto)) ? $produto->valor : 0;
}

function CapturaValorNormal($idProduto, $tamanho, $canal)
{
    $sql = 'SELECT b_venda_tamanho, mat_008, valor_tam_p, valor_tam_m, valor_tam_g, valor_tam_gg, valor_tam_extra ';
   // não existe no bd atual
   // $sql .= 'valor_tam_p_delivery, valor_tam_m_delivery, valor_tam_g_delivery, valor_tam_gg_delivery, valor_tam_extra_delivery ';
    $sql .= " FROM materiais WHERE mat_001 = :id";

    $pdo = Conexao::getInstance();
    $stm = $pdo->prepare($sql);
    $stm->bindValue(':id', $idProduto);
    $stm->execute();
    $produto = $stm->fetch(PDO::FETCH_OBJ);

    $valor = 0;

    if (!empty($produto)) :
        if ($produto->b_venda_tamanho) :
            switch ($tamanho):
                case 'P':
                    $valor = $produto->valor_tam_p;
                    break;
                case 'M':
                    $valor = $produto->valor_tam_m;
                    break;
                case 'G':
                    $valor = $produto->valor_tam_g;
                    break;
                case 'GG':
                    $valor = $produto->valor_tam_gg;
                    break;
                case 'E':
                    $valor = $produto->valor_tam_extra;
                    break;
            endswitch;
        else :
            $valor = $produto->mat_008;
        endif;
    endif;

    return $valor;
}

function CapturaValorDelivery($idProduto, $tamanho, $canal)
{
    $sql = 'SELECT b_venda_tamanho, valor_tam_p_delivery, valor_tam_m_delivery, ';
    $sql .= 'valor_tam_g_delivery, valor_tam_gg_delivery, valor_tam_extra_delivery ';
    $sql .= "FROM materiais WHERE mat_001 = :id";

    $pdo = Conexao::getInstance();
    $stm = $pdo->prepare($sql);
    $stm->bindValue(':id', $idProduto);
    $stm->execute();
    $produto = $stm->fetch(PDO::FETCH_OBJ);

    $valor = 0;

    if (!empty($produto)) :
        if ($produto->b_venda_tamanho) :
            switch ($tamanho):
                case 'P':
                    $valor = $produto->valor_tam_p_delivery;
                    break;
                case 'M':
                    $valor = $produto->valor_tam_m_delivery;
                    break;
                case 'G':
                    $valor = $produto->valor_tam_g_delivery;
                    break;
                case 'GG':
                    $valor = $produto->valor_tam_gg_delivery;
                    break;
                case 'E':
                    $valor = $produto->valor_tam_extra_delivery;
                    break;
            endswitch;
        else :
            $valor = $produto->valor_tam_m_delivery;
        endif;
    endif;

    return $valor;
}

function CapturaValorNormalOuPromocao($idProduto, $tamanho, $canal)
{
    $valor = 0;
    $valorDeliveryComanda = (isset($_COOKIE['valorDeliveryComanda'])) ? $_COOKIE['valorDeliveryComanda'] : '0';

    if ($canal == 'C' && $valorDeliveryComanda == 1) :
        $valor = CapturaValorPromocao($idProduto, $tamanho, 'D');
        if ($valor <= 0) :
            $valor = CapturaValorDelivery($idProduto, $tamanho, $canal);
        endif;
    else :
        $valor = CapturaValorPromocao($idProduto, $tamanho, $canal);
        if ($valor <= 0) $valor = CapturaValorNormal($idProduto, $tamanho, $canal);
    endif;

    return $valor;
}
