<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'verifica_cookie.php';
require 'conexao.php';
require 'config.php';

$mesa        = (isset($_POST['mesa'])) ? $_POST['mesa'] : '' ;
$comanda     = (isset($_POST['comanda'])) ? $_POST['comanda'] : '' ;
$cliente     = (isset($_POST['cliente'])) ? $_POST['cliente'] : '' ;
$cod_produto = (isset($_POST['produto'])) ? $_POST['produto'] : '' ;
$quantidade  = (isset($_POST['qtde'])) ? $_POST['qtde'] : '' ;
$opcional    = (isset($_POST['opcional'])) ? $_POST['opcional'] : '' ;
$tamanho     = (isset($_POST['tamanho'])) ? $_POST['tamanho'] : 'M' ;
$observacao  = (isset($_POST['obs'])) ? strtoupper($_POST['obs']) : '' ;
$observacao2 = (isset($_POST['obs2'])) ? strtoupper($_POST['obs2']) : '' ;
$usuario     = $_COOKIE['id'] ;
$tipo_venda  = 'C';
$pdo         = Conexao::getInstance();
$contErro    = 0;

if (empty($mesa) && empty($comanda) && empty($cliente)):
	$contErro += 1;
endif;

if (empty($cod_produto)):
	$contErro += 1;
endif;

if (empty($quantidade)):
	$contErro += 1;
endif;

if (empty($usuario)):
	$contErro += 1;
endif;

if (!empty($observacao) && !empty($observacao2)):
	$observacao .= ', ' . $observacao2;
endif;

if (empty($observacao) && !empty($observacao2)):
	$observacao = $observacao2;
endif;



if ($contErro):
	 $output = json_encode(array('status'=>'0', 'text' => 'Existem campos vazios!'));
     die($output);
endif;


// VERIFICA SE EXISTE UMA VENDA ABERTA POR MESA, NÚMERO DE COMANDA OU NOME DO CLIENTE
if (!empty($mesa)):
	$sql = "SELECT ven_001 FROM venda WHERE sit_001 = 8 AND ven_025 = :mesa AND sit_001 = 8";
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':mesa', $mesa);
	$stm->execute();
	$mesa_aberta = $stm->fetch(PDO::FETCH_OBJ);
	$tipo_venda = 'M';
elseif (!empty($comanda)):
	$sql = "SELECT ven_001 FROM venda WHERE sit_001 = 8 AND ven_026 = :comanda AND sit_001 = 8";
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':comanda', $comanda);
	$stm->execute();
	$mesa_aberta = $stm->fetch(PDO::FETCH_OBJ);
	$tipo_venda = 'C';
elseif (!empty($cliente)):
	$sql = "SELECT ven_001 FROM venda WHERE sit_001 = 8 AND ven_027 = :cliente AND sit_001 = 8";
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':cliente', $cliente);
	$stm->execute();
	$mesa_aberta = $stm->fetch(PDO::FETCH_OBJ);
	$tipo_venda = 'C';
endif;


// SENÃO EXISTIR VENDA ABERTA INSERI A NOVA VENDA, GERA UM NÚMERO PARA NOVA VENDA E 
// CASO FOR COMANDA TAMBÉM GERA O NÚMERO DE COMANDA
if (empty($mesa_aberta)):

	$sql = 'SELECT (COALESCE(MAX(ven_001) ,0)+1) as venda FROM venda WHERE emp_001 = 1';
	$stm = $pdo->prepare($sql);
	$stm->execute();
	$contador = $stm->fetch(PDO::FETCH_OBJ);
	$id_venda = $contador->venda;
	$itens    = 1;

	$comanda = null;
	if (!empty($comanda) || !empty($cliente)):
		$sql = 'SELECT (COALESCE(MAX(ven_026) ,0)+1) as comanda FROM venda WHERE sit_001 = 8';
		$stm = $pdo->prepare($sql);
		$stm->execute();
		$controle = $stm->fetch(PDO::FETCH_OBJ);
		$comanda = $controle->comanda;
	endif;

	$sql = "SELECT id_caixa FROM caixa WHERE id_situacao = 4";
	$stm = $pdo->prepare($sql);
	$stm->execute();
	$caixa = $stm->fetch(PDO::FETCH_OBJ);

	$sql = 'INSERT INTO venda (ven_001, ven_002, emp_001, dat_001_1, ven_025, cli_001, sit_001, usu_001_1, ';
	$sql .= 'VEN_024, ven_029, ven_004, ven_023, id_caixa_abertura, ven_026, terminal_abertura, ven_027)';
	$sql .= 'VALUES(:id_venda, 0, :emp, LOCALTIMESTAMP, :id_mesa, 0, 8, :id_usuario, ';
	$sql .= ":tipo_venda, :id_venda2, LOCALTIMESTAMP, 'N', :id_caixa_abertura, :comanda, :terminal_abertura, :nome_cliente)";
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':id_venda', $id_venda);
	$stm->bindValue(':emp', 1);
	$stm->bindValue(':id_mesa', (int) $mesa);
	$stm->bindValue(':id_usuario', (int) $usuario);
	$stm->bindValue(':tipo_venda', $tipo_venda);
	$stm->bindValue(':id_venda2', $id_venda);
	$stm->bindValue(':id_caixa_abertura', (int) $caixa->id_caixa);
	$stm->bindValue(':comanda', $comanda);
	$stm->bindValue(':terminal_abertura', 'MOBILE');
	$stm->bindValue(':nome_cliente', $cliente);
	$stm->execute();

else:

	$sql = 'SELECT MAX(ite_001) as itens FROM vendaitem WHERE ven_001 = :venda';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':venda', $mesa_aberta->ven_001);
	$stm->execute();
	$item = $stm->fetch(PDO::FETCH_OBJ);

	$itens    = $item->itens;
	$id_venda = $mesa_aberta->ven_001;
endif;


$sql = 'SELECT mat_001, mat_021, valor_tam_p, valor_tam_m, valor_tam_g, b_venda_tamanho FROM materiais ';
$sql .= 'WHERE mat_004 = :produto AND sit_001 = 4';
$stm = $pdo->prepare($sql);
$stm->bindValue(':produto', $cod_produto);
$stm->execute();
$produto = $stm->fetch(PDO::FETCH_OBJ);

if ($tamanho):

	switch ($tamanho) :
		case 'P':
			$valor_unitario = $produto->valor_tam_p;
			break;
		case 'M': 
			$valor_unitario = $produto->valor_tam_m;
			break;
		case 'G': 
			$valor_unitario = $produto->valor_tam_g;
			break;
	endswitch;

else:
	$valor_unitario = $produto->valor_tam_m;
endif;

$v_tamanho  = (isset($tamanho) && !empty($tamanho) && $produto->b_venda_tamanho) ? 1 : 0;
$valor_caculo_item = $valor_unitario;
$fracionado = null;


// VERIFICA SE É QUANTIDADE FRACIONADA
if ($quantidade < 1):

   // SELECIONA O ÚLTIMO ITEM FRACIONADO
   /*$sql = 'SELECT item_fracionado FROM vendaitem ';
   $sql .= 'WHERE ven_001 =:venda AND (item_fracionado IS NOT NULL AND item_fracionado > 0) ';
   $sql .= 'ORDER BY ite_001 DESC LIMIT 1';
   $stm = $pdo->prepare($sql);
   $stm->bindValue(':venda', $id_venda);
   $stm->execute();
   $ultimo_fracionado = $stm->fetch(PDO::FETCH_OBJ);*/

   // SELECIONA O MAIOR ITEM QUE FOI FRACIONADO NA VENDA
   $sql = 'SELECT COALESCE(MAX(item_fracionado), 0) AS item_fracionado FROM vendaitem ';
   $sql .= 'WHERE ven_001 =:venda AND (item_fracionado IS NOT NULL AND item_fracionado > 0) ';
   $stm = $pdo->prepare($sql);
   $stm->bindValue(':venda', $id_venda);
   $stm->execute();
   $ultimo_fracionado = $stm->fetch(PDO::FETCH_OBJ);

   if ($ultimo_fracionado->item_fracionado == 0):
  	   $fracionado = 1;
   else:

   	  if (COBRAR_MAIOR_VALOR_FRACIONADO):

	  	 // SELECIONA O MAIOR VALOR ENTRE OS ITENS FRACIONADOS DO MESMO PEDIDO
   	     $sql = 'SELECT MAX(ite_003) as maior_valor, ite_001 as item, ite_002 as qtde FROM vendaitem ';
	     $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado ';
	     $sql .= 'GROUP BY ite_001, ite_002 LIMIT 1';
	     //echo $sql;
	     $stm = $pdo->prepare($sql);
	     $stm->bindValue(':venda', $id_venda);
	     $stm->bindValue(':fracionado', $ultimo_fracionado->item_fracionado);
	     $stm->execute();
	     $totalizador = $stm->fetch(PDO::FETCH_OBJ);

	     if ($totalizador->maior_valor > $valor_caculo_item):
	     	$valor_caculo_item = $totalizador->maior_valor;
	     endif;

     	$sql = 'UPDATE vendaitem SET ite_005 = :valor + COALESCE(acrescimo, 0.0) ';
	    $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:item ';
	    $stm = $pdo->prepare($sql);
	    $stm->bindValue(':valor', ($totalizador->qtde * $valor_caculo_item));
	    $stm->bindValue(':venda', $id_venda);
	    $stm->bindValue(':item', $ultimo_fracionado->item_fracionado);
	    $stm->execute();

   	  endif;

   	   // SELECIONA A QUANTIDADE DE ITENS FRACIONADOS ANTERIORES
   	   $sql = 'SELECT COUNT(*) as total FROM vendaitem ';
	   $sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado ';
	   $stm = $pdo->prepare($sql);
	   $stm->bindValue(':venda', $id_venda);
	   $stm->bindValue(':fracionado', $ultimo_fracionado->item_fracionado);
	   $stm->execute();
	   $total_fracionado = $stm->fetch(PDO::FETCH_OBJ);

	   if (($quantidade == 0.5 && $total_fracionado->total >= 2) ||
	   	   ($quantidade == 0.3333 && $total_fracionado->total == 3)):
	   	  $fracionado = $ultimo_fracionado->item_fracionado + 1;
	   else:
	   	  $fracionado = $ultimo_fracionado->item_fracionado;
	   endif;

   endif; 
endif;

$sql = 'INSERT INTO vendaitem ';
$sql .= '(emp_001, ven_001, mat_001, ite_002, ite_003, ite_005, ite_006, ite_009, ite_001, gar_001, ';
$sql .= 'ite_013, ite_012, sit_001, ite_011, ite_008, tamanho, b_venda_tamanho, item_fracionado,';
$sql .= 'quantidade_impressao, origem_pedido, mobile_impressao)VALUES ';
$sql .= '(:emp, :id_venda, :id_material, :quantidade, :valor_unit, :valor_total, :observacao, :hora, :nro_item, ';
$sql .= ":id_garcom, :cod_impressora, 'N', 4, 'S', 'N', :tamanho, :b_venda_tamanho, :item_fracionado, :quantidade_impressao, 'M', 'N')";
$stm = $pdo->prepare($sql);
$stm->bindValue(':emp', '1');
$stm->bindValue(':id_venda', $id_venda);
$stm->bindValue(':id_material', $produto->mat_001);
$stm->bindValue(':quantidade', $quantidade);
$stm->bindValue(':valor_unit', $valor_unitario);
$stm->bindValue(':valor_total', ($quantidade * $valor_caculo_item));
$stm->bindValue(':observacao', $observacao);
$stm->bindValue(':hora', date('H:i:s'));
$stm->bindValue(':nro_item', ($itens +1));
$stm->bindValue(':id_garcom', $usuario);
$stm->bindValue(':cod_impressora', $produto->mat_021);
$stm->bindValue(':tamanho', $tamanho);
$stm->bindValue(':b_venda_tamanho', $v_tamanho);
$stm->bindValue(':item_fracionado', $fracionado);
$stm->bindValue(':quantidade_impressao', $quantidade);
$retorno = $stm->execute();


if(!empty($opcional)):
	$sql = 'SELECT MAX(ite_001) as ultimo_item FROM vendaitem WHERE ven_001 = :venda';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':venda', $id_venda);
	$stm->execute();
	$item = $stm->fetch(PDO::FETCH_OBJ);

	$sql = 'SELECT valor FROM opcional WHERE id_opcional = :opcional';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':opcional', $opcional);
	$stm->execute();
	$item_opcional = $stm->fetch(PDO::FETCH_OBJ);

	$sql = 'UPDATE vendaitem SET acrescimo = :valor_opcional, ite_005 = (ite_005 + :valor_opcional) ';
    $sql .= 'WHERE ven_001 =:venda AND ite_001 =:item ';
    $stm = $pdo->prepare($sql);
    $stm->bindValue(':valor_opcional', ($quantidade * $item_opcional->valor));
    $stm->bindValue(':venda', $id_venda);
    $stm->bindValue(':item', $item->ultimo_item);
    $stm->execute();

	$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional)VALUES';
	$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional)';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':id_venda', $id_venda);
	$stm->bindValue(':id_vendaitem', $item->ultimo_item);
	$stm->bindValue(':id_opcional', $opcional);
	$stm->execute();
	$opcional = $stm->fetch(PDO::FETCH_OBJ);
endif;


$sql = 'SELECT fn_calcula_total_venda(:idvenda, :idempresa)';
$stm = $pdo->prepare($sql);
$stm->bindValue(':idvenda', $id_venda);
$stm->bindValue(':idempresa', 1);
$stm->execute();


if ($retorno):
	echo json_encode(array('status'=>'1', 'text' => 'Gravado com sucesso', 'tipo' => $tipo_venda, 'comanda' => $comanda));
else:
	echo json_encode(array('status'=>'0', 'text' => 'Erro ao gravar item!'));
endif;