<?php
require 'verifica_cookie.php';
require 'conexao.php';

$pdo  = Conexao::getInstance();

$sql = "SELECT mes_003 FROM mesa WHERE sit_001 = 4 ORDER BY mes_003";
$stm = $pdo->prepare($sql);
$stm->execute();
$mesas = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">

	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	    <?php foreach($mesas as $mesa):
	    	$sql = "SELECT sit_001 FROM venda WHERE sit_001 = 8 AND ven_025 = " . $mesa->mes_003;
			$stm = $pdo->prepare($sql);
			$stm->execute();
			$venda = $stm->fetchAll(PDO::FETCH_OBJ);
			$back = (empty($venda)) ? '' : 'btn-red';

			if (empty($back)):
				$sql = "SELECT sit_001 FROM venda WHERE sit_001 = 21 AND ven_025 = " . $mesa->mes_003;
				$stm = $pdo->prepare($sql);
				$stm->execute();
				$venda = $stm->fetchAll(PDO::FETCH_OBJ);
				$back  = (empty($venda)) ? '' : 'btn-yellow';
				$confirmacao = (empty($venda)) ? 'confirmacao' : '';
			endif;
	    	?>
	    	<div class="mdl-cell mdl-cell--2-col-tablet mdl-cell--1-col-phone">
	 	    	<button data-id='<?= $mesa->mes_003?>' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored <?=$back?> btn-block <?=$confirmacao?>">
				  <?= $mesa->mes_003?> 
			    </button>
	    	</div>
    	<?php endforeach;?>
	  </div>
	</div>
	<dialog class="mdl-dialog">
	    <div class="mdl-dialog__content">
	      <p>
	      <h5>Pedido na Mesa <span class='mesa'></span>?</h5>
	      </p>
	    </div>
	    <div class="mdl-dialog__actions">
	      <input type="hidden" name="mesa" id='mesa' value="">
	      <button type="button" class="mdl-button close">Cancelar</button>
	      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored pedido">Lançar Item</button>
	    </div>
	</dialog>
	<script src="js/jquery.min.js"></script>
	<script>

    var dialog = document.querySelector('dialog')
	if (! dialog.showModal) {
       dialogPolyfill.registerDialog(dialog);
    }

    jQuery(document).ready(function($) {	

    	$('.confirmacao').click(function(event) {
    		var mesa = $(this).attr('data-id');

    		$('.mesa').html(mesa);
    		$('#mesa').val(mesa);
		    dialog.showModal();
    	});

    	$('.close').click(function(event) {
    		dialog.close();
    	});

    	$('.pedido').click(function(event) {
    		var mesa = $('#mesa').val();
    		dialog.close();
    		window.location = 'pedido.php?mesa=' + mesa;
    	});

    });
  </script>
</body>
</html>