﻿<?php
session_start();
require 'conexao.php';
require 'config.php';

$venda = (isset($_GET['venda'])) ? $_GET['venda'] : '' ;
$mesa  = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda  = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$tipo  = (isset($_GET['tipo'])) ? $_GET['tipo'] : '' ;
$codigo  = (isset($_GET['codigo'])) ? $_GET['codigo'] : '' ;

if ($tipo == 'M'):
  $linkListagem = "pedido.php?mesa={$mesa}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
elseif($tipo == 'C'):
  $linkListagem = "pedido.php?comanda={$comanda}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
endif;

if ($tipo == 'M'):
  $linkListagem = "pedido.php?mesa={$mesa}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
elseif($tipo == 'C'):
  $linkListagem = "pedido.php?comanda={$comanda}&tipo={$tipo}&venda={$venda}#scroll-tab-3";
endif;
?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'includes/inc_head.php'; ?>
  <style>
      .footer {
        position: absolute;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1000;
        background:#d6d7da;
      }
      .box-altura{
        display: block;
        height: 70px;
      }
      .btn-rodape{
        height: 50px;
      }
    .sabores{
      font-size: 17px;
      font-weight: bold;
      /* line-height: 27px; */
    }
    hr{
      margin-bottom: 10px;
    }
    .tabela {
      margin: 0 auto !important;
      width: 95% !important;
  }
  </style>
</head>
<body>
   <script>loadPagina()</script>
   <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header page">
     <header class = "mdl-layout__header">
        <div class = "mdl-layout__header-row login">
           <span class = "mdl-layout-title">ADICIONAIS DO ITEM</span>
        </div>
      </header>

      <?php include 'includes/inc_menu.php'; ?>

  	  <main class="mdl-layout__content">
  	    <div class = "wide-card mdl-card mdl-shadow--4dp conteudo">
           <div class = "mdl-card__actions mdl-card--border">
           <p class="text-left text-red valor"><strong>SABORES (Tamanho <span id="tamanho"></span>)</strong></p><hr>
              <hr>
              <div id="container-sabores">

              </div>
           </div>
        </div>

        <div id="wide-card mdl-card mdl-shadow--4dp">
          <div id="box-opcionais">

          </div>
        </div>

        <div class="box-altura"></div>
          <div class = "mdl-shadow--4dp footer mdl-card__actions mdl-card--border container-finalizar">
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-red" onclick="javascript:window.history.go(-1)" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">arrow_back</i>
                VOLTAR
            </button>
            <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-green btn-finalizar" data-upgraded=",MaterialButton" style="width: 49%">
                <i class="material-icons">check_circle</i>
                ADICIONAR
            </button>
          </div>
  	  </main>
  	</div>

  <?php include 'includes/inc_js.php'; ?>
  <script>
     function preloader(){
         EasyLoading.hide();
         $('#page').show();
      }
      window.onload = preloader;

     $(document).ready(function($) {

      carregaSabores()
      carregaOpcionais();
      var opcionais = []

      $('.btn-finalizar').on('click', function(){

          $('.ckb-opcional:checked').each(function() {
            opcionais.push({
                id_opcional: $(this).val(),
                fracao: false,
                completo: 0,
                quantidade: 1
            })
          });

          let carrinho = []
          let produto = {}
          let produtos = JSON.parse(localStorage.getItem('produtos'))

          if (localStorage.hasOwnProperty('carrinho')){
            carrinho = JSON.parse(localStorage.getItem('carrinho'))

            if ( carrinho.length > 0 ){
                carrinho.sort((a, b) => Number(b.ordem) - Number(a.ordem))
                ordem = carrinho[0].ordem + 1
            }
          }
          
          let contador = 0
          arrayPizza = JSON.parse(localStorage.getItem('sabores'))
          arrayPizza.forEach((item, index) => {

            let produto = {}
            let produto_selecionado = produtos.filter(prod => (prod.mat_001 == item.codigo))

            if (produto_selecionado){
              indice = ((new Date().getTime() / 1000) * Math.random()).toString()
              produto.indice = indice.replace(/\./g, '')
              produto.id = produto_selecionado[0].mat_001
              produto.codigo = produto_selecionado[0].mat_004
              produto.descricao = produto_selecionado[0].mat_003
              produto.vende_tamanho = produto_selecionado[0].b_venda_tamanho
              produto.vende_fracionado = produto_selecionado[0].fracionado
              produto.vende_balanca = produto_selecionado[0].b_peso_balanca
              produto.descricao_tamanho = item.descricao_tamanho

              if ( produto.vende_fracionado ){
                if ( item.qtde == 0.3333 ){
                  produto.quantidade = parseFloat(item.qtde).toFixed(4)
                }else{
                  produto.quantidade = parseFloat(item.qtde).toFixed(3)
                }
              }else{
                produto.quantidade = parseFloat(item.qtde).toFixed(3)
              }
              produto.tamanho_padrao = produto_selecionado[0].tamanho_padrao
              produto.tamanho_pedido = item.tamanho
              produto.valor_p = produto_selecionado[0].valor_tam_p 
              produto.valor_m = produto_selecionado[0].valor_tam_m  
              produto.valor_g = produto_selecionado[0].valor_tam_g 
              produto.valor_gg = produto_selecionado[0].valor_tam_gg  
              produto.valor_extra = produto_selecionado[0].valor_tam_extra 
              produto.impressora = produto_selecionado[0].impressora 
              produto.id_fracionado = 0
              produto.categoria = produto_selecionado[0].cat_001 
              produto.status = 'A'
              produto.observacao = ''
              produto.opcao_observacao = ''
              produto.opcional = opcionais
              produto.pacote = []

              carrinho.push(produto)
            } 
          })

          localStorage.setItem('carrinho', JSON.stringify(carrinho))
          localStorage.removeItem('sabores')
          Snackbar.show({text: 'Produto adicionado com sucesso!',
                                      actionText: 'Fechar',
                                      duration: 1000,
                                      pos: 'top-left'
                                    });
                                
          setTimeout(function(){
                        EasyLoading.show({text: 'Aguarde, carregando ...'});
                        window.location.href = '<?=$linkListagem?>';
                    }, 500)
      })

      function carregaOpcionais(){
        let container = document.getElementById('box-opcionais')
        let opcionaisStorage = []
        let opcionais = []
        let produtos = []
        let codigo = '<?=$codigo?>'
        let produto = {}
        let html = ''

        if (localStorage.hasOwnProperty('opcionais')){
           opcionaisStorage = JSON.parse(localStorage.getItem('opcionais'))
        }

        if (localStorage.hasOwnProperty('produtos')){
           produtos = JSON.parse(localStorage.getItem('produtos'))

           if (produtos.length > 0){
              produto = produtos.filter(prod => prod.mat_001 == codigo)
           }
        }

        if (opcionaisStorage.length > 0){
           opcionais = opcionaisStorage.filter(opcao => opcao.id_categoria == produto[0].cat_001)   
        }

        if (opcionais.length > 0){
            html += `<table class='mdl-data-table mdl-js-data-table mdl-data-table--selectable mdl-shadow--2dp tabela'>
                      <tbody>`
            opcionais.forEach(opcional => {
               html += `<tr>
                          <td width='10'>
                          <input type='checkbox' id='checkbox${opcional.id_opcional}' class='ckb-opcional' value='${opcional.id_opcional}' >
                          </td>
                          <td class = 'mdl-data-table__cell--non-numeric'><label for='checkbox${opcional.id_opcional}'>${opcional.descricao.toUpperCase()}</label></td>
                          <td>R$ ${opcional.valor}</td>
                        </tr>`
            })
            
            html += `</tbody>
                    </table>`
        }

        container.innerHTML = html
      }

      function carregaSabores(){
         let elemento = ''
         let tamanho = '';
         arrayPizza = JSON.parse(localStorage.getItem('sabores'))

         arrayPizza.forEach((item, index) => {
            let qtde = ''

            switch (item.tamanho) {
              case 'P':
                tamanho = 'Pequeno'
                break;
              case 'B':
                tamanho = 'Brotinho'
                break;
              case 'M':
                tamanho = 'Médio'
                break;
              case 'G':
                tamanho = 'Grande'
                break;
              case 'E':
                tamanho = 'Extra Grande'
                break;
              default:
                tamanho = 'Médio'
                break;
            }

            switch (arrayPizza.length) {
              case 1:
                qtde = '1'
                break;
              case 2:
                qtde = '1/2'
                break;
              case 3:
                qtde = '1/3'
                break;
              case 4:
                qtde = '1/4'
                break;
              default:
                qtde = '1'
            }

            elemento += `<p class='sabores'>
                        ${qtde} - ${item.nome}
                         </p>`
         })

         $('#tamanho').html(arrayPizza[0].descricao_tamanho)
         $('#container-sabores').html(elemento)
      }
    });
  </script>
</body>
</html>
