﻿<?php
session_start();

require 'conexao.php';
require 'config.php';
require 'includes/inc_verifica_caixa.php';

$tipo    = (isset($_GET['tipo'])) ? $_GET['tipo'] : $_SESSION['TIPO']  ;
$venda   = (isset($_GET['venda'])) ? $_GET['venda'] : '' ;
// $mesa    = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$idMesa  = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$cliente = (isset($_GET['cliente'])) ? strtoupper($_GET['cliente']) : '' ;

if ($tipo == 'C'):
   $comanda = (isset($_SESSION['CONTROLE'])) ? $_SESSION['CONTROLE'] : $comanda;
   $cliente = (isset($_SESSION['CLIENTE'])) ? $_SESSION['CLIENTE'] : $cliente;
   $venda   = (isset($_SESSION['VENDA'])) ? $_SESSION['VENDA'] : $venda;

   if ( !isset($_SESSION['CONTROLE']) ):
       $_SESSION['CONTROLE'] = '';
   endif;

elseif ($tipo == 'M'):
   $sql = "SELECT mes_003 FROM mesa WHERE mes_001 = {$idMesa}";
   $stm = $pdo->prepare($sql);
   $stm->execute();
   $mesas = $stm->fetch(PDO::FETCH_OBJ);

   $mesa  = (isset($_SESSION['CONTROLE'])) ? $_SESSION['CONTROLE'] : $mesas->mes_003;
   $venda = (isset($_SESSION['VENDA'])) ? $_SESSION['VENDA'] : $venda;
   $cliente = (isset($_SESSION['CLIENTE'])) ? $_SESSION['CLIENTE'] : $cliente;
endif;
   
$_SESSION['VENDA']   = $venda;
$_SESSION['TIPO']    = $tipo;
$_SESSION['CLIENTE'] = $cliente;

if ((!empty($cliente) || !empty($comanda)) && $tipo === 'C' ):
   $_SESSION['ID_MESA']  = '';

  if (!empty($comanda)):
    $_SESSION['CONTROLE'] = $comanda;
  endif;

  if (!empty($cliente)):
    $_SESSION['CLIENTE'] = $cliente;
  endif;

   $linkListagem  = '';
   switch (TIPO_COMANDA):
     case 0:
       $linkListagem = 'comandas_nome.php';
       if (!empty($comanda)):
          $labelControle = 'COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT);
       endif;

       if (!empty($cliente)):
          $labelControle = substr($cliente, 0, 10);
          $labelControle .= (!empty($comanda)) ? ' | COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT) : '';
        endif;
       break;
     case 1:
       $linkListagem = 'comandas_numero.php';
       if (!empty($comanda)):
        $labelControle = 'COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT);
       endif;

        if (!empty($cliente)):
          $labelControle = substr($cliente, 0, 10);
          $labelControle .= (!empty($comanda)) ? ' | COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT) : '';
        endif;
       break;
     case 2:
        if (!empty($comanda)):
            $labelControle = 'COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT);
        endif;

        if (!empty($cliente)):
          $labelControle .= (!empty($cliente)) ? ' | ' . str_pad($cliente, 2, '0', STR_PAD_LEFT) : '';
        endif;
       $linkListagem = 'comandas_numero_mesa.php';
       break;
     case 3:
         if (!empty($comanda)):
          $labelControle = 'COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT);
         endif;

         if (!empty($cliente)):
           $labelControle = substr($cliente, 0, 10);
           $labelControle .= (!empty($comanda)) ? ' | COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT) : '';
         endif;

         $linkListagem = 'comandas_numero_pesquisa.php';
         break;
      case 4:
         if (!empty($comanda)):
               $labelControle = 'COM.: ' . str_pad($comanda, 2, '0', STR_PAD_LEFT);
         endif;
   
         if (!empty($cliente)):
            $labelControle .= (!empty($cliente)) ? ' | ' . str_pad($cliente, 2, '0', STR_PAD_LEFT) : '';
         endif;
         $linkListagem = 'comandas_numero_nome.php';
         break;
     default:
       $linkListagem = 'comandas_numero.php';
       break;
   endswitch;

elseif (!empty($mesa)):
   $labelControle        = 'Mesa ' . str_pad($mesa, 2, '0', STR_PAD_LEFT);
   $_SESSION['CONTROLE'] = $mesa;
   $_SESSION['ID_MESA']  = $idMesa;


   if (!empty($venda)):
      $sql = "SELECT ven_027 FROM venda WHERE ven_001 = {$venda}";
      $stm = $pdo->prepare($sql);
      $stm->execute();
      $validacao = $stm->fetch(PDO::FETCH_OBJ);
      $cliente = $validacao->ven_027;
      $_SESSION['CLIENTE'] = $cliente;

      if (!empty($cliente)):
         $cliente = substr($cliente, 0, 10);
         $labelControle .= (!empty($cliente)) ? ' | ' . $cliente : '';
      endif; 
   endif;

   $linkListagem  = 'mesas.php';

else:

   $_SESSION['CONTROLE'] = '';
   $labelControle = 'Não Identificado';
   $linkListagem  = 'mesas.php';

endif;

$pdo  = Conexao::getInstance();
$sql = "SELECT DISTINCT c.cat_001, c.cat_002 ";
$sql .= "FROM categoria c INNER JOIN materiais m ON c.cat_001 = m.cat_001 ";
$sql .= "WHERE c.sit_001 = 4 AND m.sit_001 = 4 AND c.exibe_comanda = 1 ORDER BY cat_002";
$stm = $pdo->prepare($sql);
$stm->execute();
$categorias = $stm->fetchAll(PDO::FETCH_OBJ);

$sql = "SELECT tamanho_p as tamanho, 'P' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_m as tamanho, 'M' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_g as tamanho, 'G' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_gg as tamanho, 'GG' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$sql .= "UNION ALL ";
$sql .= "SELECT tamanho_extra as tamanho, 'E' as sigla ";
$sql .= "FROM desc_tamanho_material ";
$stm = $pdo->prepare($sql);
$stm->execute();
$tamanhos = $stm->fetchAll(PDO::FETCH_OBJ);

if (!empty($venda)):

  $sql = "SELECT sit_001, COALESCE(nro_pessoas, 0) AS pessoas, COALESCE(nro_couvert_f, 0) as mulheres, COALESCE(nro_couvert_m, 0) as homens FROM venda WHERE ven_001 = {$venda}";
  $stm = $pdo->prepare($sql);
  $stm->execute();
  $validacao = $stm->fetch(PDO::FETCH_OBJ);

  if ($validacao->sit_001 == 21 || $validacao->sit_001 == 1):
    header("Location: " . $linkListagem);
  endif;

   $sql = "SELECT i.ite_001, i.mat_001, i.ite_002, m.mat_003, i.ite_011, i.ite_005, i.ven_001, i.mobile_impressao, m.rodizio ";
   $sql .= "FROM venda v INNER JOIN vendaitem i ON v.ven_001 = i.ven_001 ";
   $sql .= "INNER JOIN materiais m ON m.mat_001 = i.mat_001 ";
   $sql .= "WHERE v.ven_001 = {$venda} AND i.sit_001 = 4 AND v.sit_001 = 8 ";
   $sql .= "ORDER BY i.ite_001 ";
   $stm = $pdo->prepare($sql);
   $stm->execute();
   $itensVenda = $stm->fetchAll(PDO::FETCH_OBJ);

   $sql = "SELECT ven_009 as subtotal,  ((ven_009 * 0.10) + ven_009) as total, (ven_009 * 0.10) as servico, ven_001 ";
   $sql .= "FROM venda ";
   $sql .= "WHERE ven_001 = {$venda} AND sit_001 = 8 ";
   $stm = $pdo->prepare($sql);
   $stm->execute();
   $totalizadores = $stm->fetch(PDO::FETCH_OBJ);

   $sql = "SELECT COALESCE(SUM(valor), 0) as valor FROM venda_pag_antecipado WHERE id_venda = {$venda}";
   $stm = $pdo->prepare($sql);
   $stm->execute();
   $antecipado = $stm->fetch(PDO::FETCH_OBJ);

endif;

$exibeCategorias = 'mostra';
$statusContainerCategoria = 'mostra';
$iconeBotao = 'keyboard_arrow_up';
$textoBotao = 'ESCONDER CATEGORIAS';

$revisao = (isset($_SESSION['PEDIDO'])) ? sizeof($_SESSION['PEDIDO']) : 0 ;
$exibe_finalizacao = (isset($_SESSION['PEDIDO']) && sizeof($_SESSION['PEDIDO']) > 0) ? 'mostra' : 'esconde' ;
$exibe_contador    = (isset($_SESSION['PEDIDO']) && sizeof($_SESSION['PEDIDO']) > 0) ? 'visivel' : 'not-visivel' ;
?>
<html>
   <head>
      <title>Comanda Eletrônica</title>
      <?php include 'includes/inc_head.php'; ?>
      <style>
         .footer {
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 1000;
            background:#d6d7da;
         }
         .box-altura{
            display: block;
            height: 70px;
         }
         .btn-rodape{
            height: 50px;
         }

         .onoffswitch {
            position: relative; width: 100px;
            -webkit-user-select:none; -moz-user-select:none; -ms-user-select: none;
         }
         .onoffswitch-checkbox {
            display: none;
         }
         .onoffswitch-label {
            display: block; overflow: hidden; cursor: pointer;
            border: 2px solid #E3E3E3; border-radius: 30px;
         }
         .onoffswitch-inner {
            display: block; width: 200%; margin-left: -100%;
            transition: margin 0.3s ease-in 0s;
         }
         .onoffswitch-inner:before, .onoffswitch-inner:after {
            display: block; float: left; width: 50%; height: 30px; padding: 0; line-height: 30px;
            font-size: 12px; color: white; font-family: Trebuchet, Arial, sans-serif; font-weight: bold;
            box-sizing: border-box;
         }
         .onoffswitch-inner:before {
            content: "FRAÇÃO";
            padding-right: 35px;
            background-color: #3F51B5; color: #FFFFFF;
         }
         .onoffswitch-inner:after {
            content: "";
            padding-right: 10px;
            background-color: #FFFFFF; color: #666666;
            text-align: right;
         }
         .onoffswitch-switch {
            display: block; width: 30px; margin: 0px;
            background: #FFFFFF;
            position: absolute; top: 0; bottom: 0;
            right: 71px;
            border: 2px solid #E3E3E3; border-radius: 30px;
            transition: all 0.3s ease-in 0s; 
         }
         .onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-inner {
            margin-left: 0;
         }
         .onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-switch {
            right: 0px; 
         }
      </style>
   </head>

   <body>
      <script>loadPagina()</script>
      <div class = "mdl-layout mdl-js-layout mdl-layout--fixed-header mdl-layout--fixed-tabs" id="page" style="display:none">

         <header class = "mdl-layout__header">
            <div class = "mdl-layout__header-row">
               <span class = "mdl-layout-title titulo"><?=$labelControle?></span>
               <a href="<?=$linkListagem?>" class="link-topo link-mesas">
                  <i class="material-icons text-right text-white">view_comfy</i>&nbsp;&nbsp;&nbsp;
               </a>
               <?php if (PERMITE_REIMPRESSAO):?>
                <a href="javascript::void(0)" class="link-topo link-imprimir">
                    <i class="material-icons text-right margem-direita-md text-white">local_printshop</i>
                </a>
               <?php endif;?>
                <a href="javascript::void(0)" class="link-topo link-atualizar">
                    <i class="material-icons text-right margem-direita-md text-white">autorenew</i>
                </a>
            </div>

            <!-- Tabs -->
            <div class = "mdl-layout__tab-bar mdl-js-ripple-effect">
               <a href = "#scroll-tab-1" class = "mdl-layout__tab is-active" id='header-scroll-tab-1' onclick="history.pushState('scroll-tab-1','Comanda Eletrônica','#scroll-tab-1'); return false;">
                  Consumo
               </a>
               <a href = "#scroll-tab-2" class = "mdl-layout__tab" id='header-scroll-tab-2' onclick="history.pushState('scroll-tab-2','Comanda Eletrônica','#scroll-tab-2'); return false;">
                  Produtos
               </a>
               <a href = "#scroll-tab-3" class = "mdl-layout__tab" id='header-scroll-tab-3' onclick="history.pushState('scroll-tab-3','Comanda Eletrônica','#scroll-tab-3'); return false;">
                  Pendente <span class = "mdl-badge <?=$exibe_contador?>" data-badge = "<?=$revisao?>"></span>
               </a>
            </div>

         </header>

         <?php include 'includes/inc_menu.php'; ?>

         <main class = "mdl-layout__content">

            <!-- SEÇÃO ITENS DA MESA -->
            <section class = "mdl-layout__tab-panel is-active" id = "scroll-tab-1">
               <div class = "page-content">

                  <?php if(!empty($itensVenda)):?>
                     <?php foreach($itensVenda as $item):
                        $backImpressao = '';
                        //$backImpressao = ($item->ite_011 == 'S') ? 'bk-red-2' : '';
                        ?>
                        <div class = "wide-card mdl-card mdl-shadow--4dp <?=$backImpressao?>">
                           <div class = "mdl-card__title">
                              <h3 class = "mdl-card__title-text">
                                 <?=number_format($item->ite_002, 3, ',', '.')?> - <?=strtoupper($item->mat_003)?>
                              </h3>
                           </div>

                           <div class = "card-valor">
                              <span class="text-left text-red valor">Valor R$ <?=number_format($item->ite_005, 2, ',', '.')?></span>
                           </div>

                           <div class = "mdl-card__actions mdl-card--border totalizador detalhe">
                              <?php if (PERMITE_REIMPRESSAO && $item->rodizio == 0):?>
                                  &nbsp;&nbsp;
                                  <label class = "mdl-checkbox mdl-js-checkbox mdl-js-ripple-effect" for = "checkbox<?=$item->ite_001?>">
                                    <input type = "checkbox" id = "checkbox<?=$item->ite_001?>"
                                        class="ckb mdl-checkbox__input" <?=($item->ite_011 == 'S') ? '' : ''?> data-item='<?=$item->ite_001?>'>
                                    <span class = "mdl-checkbox__label">IMPRIMIR</span>
                                  </label>
                              <?php endif;?>
                              <a href="detalhes.php?venda=<?=$item->ven_001?>&item=<?=$item->ite_001?>" class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes">
                                 <i class="material-icons">search</i> DETALHES
                              </a>&nbsp;
                              <?php if ($item->rodizio == 1):?>
                                 <a href="rodizio.php?venda=<?=$item->ven_001?>&mesa=<?=$idMesa?>&comanda=<?=$comanda?>&tipo=<?=$tipo?>&item=<?=$item->ite_001?>&codigo=<?=$item->mat_001?>&qtde=<?=$item->ite_002?>&situacao=edicao" 
                                 class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes rodizio" data-id='<?=$item->mat_001?>'>
                                    <i class="material-icons">group</i> RODIZIO
                                 </a>
                              <?php else: ?>
                                 <a class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes duplicar" data-id='<?=$item->mat_001?>'>
                                    <i class="material-icons">content_copy</i> DUPLICAR
                                 </a>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php endforeach; ?>

                     <div class = "wide-card mdl-card mdl-shadow--4dp">
                        <div class = "mdl-card__title">
                           <h3 class = "mdl-card__title-text text-red">
                              DETALHES
                           </h3>
                        </div>

                        <div class = "mdl-card__actions mdl-card--border  totalizador">
                           <p>MULHERES (COUVERT)</p> 
                           <a href="javascript:void(0)" class="btn-remove-mulher">
                              <i class="material-icons text-red md-48 btn-qtde">remove_circle</i>
                           </a>
                           <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                              <input class="mdl-textfield__input quantidade qtde-item' type="number" id="quantidade-mulher" value="<?=$validacao->mulheres?>"/>
                           </div>
                           <a href="javascript:void(0)" class="btn-adiciona-mulher">
                              <i class="material-icons text-green md-48 btn-qtde">add_circle</i>
                           </a>

                           <p>HOMENS (COUVERT)</p> 
                           <a href="javascript:void(0)" class="btn-remove-homem">
                              <i class="material-icons text-red md-48 btn-qtde">remove_circle</i>
                           </a>
                           <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                              <input class="mdl-textfield__input quantidade qtde-item' type="number" id="quantidade-homem" value="<?=$validacao->homens?>"/>
                           </div>
                           <a href="javascript:void(0)" class="btn-adiciona-homem">
                              <i class="material-icons text-green md-48 btn-qtde">add_circle</i>
                           </a>

                           <p>QTDE DE PESSOAS (DIVISÃO DA CONTA)</p> 
                           <a href="javascript:void(0)" class="btn-remove-pessoa">
                              <i class="material-icons text-red md-48 btn-qtde">remove_circle</i>
                           </a>
                           <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                              <input class="mdl-textfield__input quantidade qtde-item' type="number" id="quantidade-pessoa" value="<?=$validacao->pessoas?>"/>
                           </div>
                           <a href="javascript:void(0)" class="btn-adiciona-pessoa">
                              <i class="material-icons text-green md-48 btn-qtde">add_circle</i>
                           </a>
                           
                           <p style="height: 10px; display: inline-block;"></p>
                           <button class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-gravar-pessoas" data-upgraded=",MaterialButton" style="width: 100%">
                              <i class="material-icons">check_circle</i>
                              Gravar
                           </button>

                        </div>
                     </div>

                     <div class = "wide-card mdl-card mdl-shadow--4dp">
                        <div class = "mdl-card__title">
                           <h3 class = "mdl-card__title-text text-red">
                              TOTALIZADORES
                           </h3>
                        </div>

                        <div class = "mdl-card__actions mdl-card--border  totalizador">
                           <p>( + ) SUB-TOTAL R$ <?=number_format( $totalizadores->subtotal, 2, ',', '.')?></p>
                           <p>
                              ( + ) TX DE SERVIÇO
                              <?php if ((TAXA_MESA && $tipo == 'M') || (TAXA_COMANDA && $tipo == 'C')):?>
                                 R$ <?=number_format( $totalizadores->servico, 2, ',', '.')?>
                              <?php else:?>
                                 R$ 0,00
                              <?php endif;?>
                           </p>
                           <p> ( - ) PAG. ANTECIPADO R$ <?=number_format( $antecipado->valor, 2, ',', '.')?></p>
                           <hr>
                           <span class="text-left text-red">
                              ( = ) TOTAL
                              <?php if ((TAXA_MESA && $tipo == 'M') || (TAXA_COMANDA && $tipo == 'C')):?>
                                 R$ <?=number_format( ($totalizadores->total - $antecipado->valor), 2, ',', '.')?>
                              <?php else:?>
                                 R$ <?=number_format( ($totalizadores->subtotal - $antecipado->valor), 2, ',', '.')?>
                              <?php endif;?>
                           </span>
                           <p style="height: 10px; display: inline-block;"></p>
                        </div>
                     </div>
                     
                     <?php else: ?>
                        <h4 class='text-center text-blue vazio2'>Nenhum Item Consumido <i class='material-icons'>thumb_up</i></h4>
                        
                        <div class = "wide-card mdl-card mdl-shadow--4dp">
                           <div class = "mdl-card__title">
                              <h3 class = "mdl-card__title-text text-red">
                                 QTDE DE PESSOAS (DIVISÃO DA CONTA)
                           </h3>
                        </div>
                        
                        <div class = "mdl-card__actions mdl-card--border  totalizador">
                           <a href="javascript:void(0)" class="btn-remove-pessoa">
                              <i class="material-icons text-red md-48 btn-qtde">remove_circle</i>
                           </a>
                           <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                              <input class="mdl-textfield__input quantidade qtde-item' disabled="disabled" type="number" id="quantidade-pessoa" value="<?=(isset($validacao)) ? $validacao->pessoas : '1' ?>"/>
                           </div>
                           <a href="javascript:void(0)" class="btn-adiciona-pessoa">
                              <i class="material-icons text-green md-48 btn-qtde">add_circle</i>
                           </a>
                           
                        </div>
                     </div>
                     
                     <?php endif; ?>
                  </div>

                  <?php if(!empty($itensVenda)):?>
                     <div class="box-altura"></div>
                     <div class = "mdl-shadow--4dp footer mdl-card__actions mdl-card--border">
                        <button class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored btn-fechamento btn-red btn-rodape" data-upgraded=",MaterialButton" style="width: 100%">
                           <i class="material-icons">local_printshop</i>
                           Pré-Fechamento
                        </button>
                     </div>
                  <?php endif; ?>

            </section>

            <!-- SEÇÃO CATEGORIAS E PRODUTOS -->
            <section class = "mdl-layout__tab-panel" id = "scroll-tab-2">
               <div class="container-scroll div-geral-categorias <?=$statusContainerCategoria?> <?=$exibeCategorias?>">
                  <div class = "page-content container-categorias">
					      
                  </div>
               </div>

               <a href="javascript::void(0)" class="acao-div-categoria">
                  <i class="material-icons"><?=$iconeBotao?></i>
                  <span><?=$textoBotao?></span>
               </a>

               <div class = "mdl-textfield mdl-js-textfield mdl-textfield--floating-label pesquisa">
                  <input class = "mdl-textfield__input" type = "text" id = "pesquisa" autocomplete="off">
                  <label class = "mdl-textfield__label" for = "text4">Procurar por Código ou Descrição</label>
               </div>

               <div id="produtos-categoria">

               </div>
            </section>

            <!-- SEÇÃO PEDIDO PARA REVISÃO -->
            <section class = "mdl-layout__tab-panel" id = "scroll-tab-3">

            </section>

         </main>
      </div>

      <?php include 'includes/inc_js.php'; ?>

   <script>

      var tamanhos_servidor = '<?= json_encode($tamanhos) ?>';

      function preloader(){
         if (! localStorage.hasOwnProperty('categorias')){
            getDadosServidor()
         }
         CarregarCategorias();
         CarregaCarrinho();
         getProdutosRevisaoStorage();
         EasyLoading.hide();
         $('#page').show();
      }
      window.onload = preloader;

      function CarregarCategorias(){
         let categorias = JSON.parse(localStorage.getItem('categorias'))
         let container = document.querySelector('.container-categorias')

         let str = `<button class="btn-categoria mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effects" data-upgraded=",MaterialButton,MaterialRipple" data-id="">` +
                     `TODAS` +
                  `</button>`
         
         container.innerHTML = ''
         categorias.forEach(categoria => {
            str += `<button class="btn-categoria mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effects" data-upgraded=",MaterialButton,MaterialRipple" data-id="${categoria.cat_001}">` +
                     `${categoria.cat_002}` +
                  `</button>`
         })

         container.innerHTML = str
      }

      function CarregaCarrinho(){

         if (localStorage.hasOwnProperty('carrinho')){
            let carrinho = JSON.parse(localStorage.getItem('carrinho'))
            $('.mdl-badge').removeClass('not-visivel')
                              .addClass('visivel')
                              .attr('data-badge', carrinho.length);
         }else{
            $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
            $('.mdl-badge').removeClass('visivel')
                           .addClass('not-visivel')
                           .attr('data-badge', 0);
         }
      }

      function getProdutosRevisaoStorage(){
         $('#produtos-revisao').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");
         let carrinho = []

         if (localStorage.hasOwnProperty('carrinho')){
            carrinho = JSON.parse(localStorage.getItem('carrinho'))
         }

         if (carrinho.length == 0){
            $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
         }else{
            let str = ''
            let tamanhos = JSON.parse(tamanhos_servidor)
            carrinho.sort((a, b) => Number(b.ordem) - Number(a.ordem))
            carrinho.forEach( item => {

               let index = item.indice
               let backObservacao = (item.observacao != "" || item.opcao_observacao != "") ? 'text-red' : ''
               let backOpcional   = (item.opcional.length > 0) ? 'text-red' : ''
               let descTamanhoSelecionado = ''
               let descSiglaTamanho = (item.tamanho_pedido != "") ? item.tamanho_pedido : item.tamanho_padrao
               let qtdeExibicao = parseFloat(item.quantidade)
               let valorOption = item.quantidade

               if (item.vende_tamanho){

                  if (item.descricao_tamanho != undefined && item.descricao_tamanho != ''){
                     descTamanhoSelecionado = item.descricao_tamanho
                  }else{
                     objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == descSiglaTamanho)
                     descTamanhoSelecionado = objTamanho[0].tamanho
                  }

                  // switch (tamanho) {
                  //    case 'P':
                  //       descTamanhoSelecionado = 'Pequeno'
                  //       break;
                  //    case 'M':
                  //       descTamanhoSelecionado = 'Médio'
                  //       break;
                  //    case 'G':
                  //       descTamanhoSelecionado = 'Grande'
                  //       break;
                  //    case 'GG':
                  //       descTamanhoSelecionado = 'Gigante'
                  //       break;
                  //    case 'E':
                  //       descTamanhoSelecionado = 'Extra'
                  //       break;
                  //    default:
                  //       descTamanhoSelecionado = 'Médio'
                  //       break;
                  // }                        
               }

               switch (qtdeExibicao) {
                  case 1:
                     valorOption = '1'
                     qtdeExibicao = '1'
                     break;
                  case 2:
                     valorOption = '2'
                     qtdeExibicao = '2'
                     break;
                  case 0.5:
                     valorOption = "0.500"
                     qtdeExibicao = '1/2'
                     break;
                  case 0.3333:
                     valorOption = "0.3333"
                     qtdeExibicao = '1/3'
                     break;
                  case 0.25:
                     valorOption = "0.250"
                     qtdeExibicao = '1/4'
                     break;
                  default:
                     valorOption = qtdeExibicao
                     break;
               }

               if(item.vende_balanca){
                  if (parseInt(item.quantidade) == 1){
                     qtdeExibicao = "1"
                  }else{
                     qtdeExibicao = parseFloat(item.quantidade).toFixed(3)
                  }
               }

               str += `<div class = "wide-card mdl-card mdl-shadow--4dp card-revisao item-${index}">
                  <div class = "mdl-card__title">
                     <p class="text-left">
                        ${item.codigo} - ${item.descricao}<br>
                     </p>`

                     if (item.vende_tamanho){
                        str +=  `<select class='select-tamanho tamanho' data-id='${index}'>
                              <option value='${descSiglaTamanho}'>${descTamanhoSelecionado}</option>`

                              if (item.valor_p != "0.00"){
                                 objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'P')
                                 str += `<option value='${objTamanho[0].sigla}'>${objTamanho[0].tamanho}</option>`
                              }

                              if (item.valor_m != "0.00"){
                                 objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'M')
                                 str += `<option value='${objTamanho[0].sigla}'>${objTamanho[0].tamanho}</option>`
                              }

                              if (item.valor_g != "0.00"){
                                 objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'G')
                                 str += `<option value='${objTamanho[0].sigla}'>${objTamanho[0].tamanho}</option>`
                              }

                              if (item.valor_gg != "0.00"){
                                 objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'GG')
                                 str += `<option value='${objTamanho[0].sigla}'>${objTamanho[0].tamanho}</option>`
                              }

                              if (item.valor_extra != "0.00"){
                                 objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'E')
                                 str += `<option value='${objTamanho[0].sigla}'>${objTamanho[0].tamanho}</option>`
                              }

                              // str += (item.valor_m != "0.00") ?  `<option value='M'>Médio</option>` : ''
                              // str += (item.valor_g != "0.00") ?  `<option value='G'>Grande</option>` : ''
                              // str += (item.valor_gg != "0.00") ?  `<option value='GG'>Gigante</option>` : ''
                              // str += (item.valor_extra != "0.00") ?  `<option value='E'>Extra</option>` : ''
                        str += `</select>
                              <select class='select-tamanho2 qtde-item' id='select-${index}' data-id='${index}'>
                                    <option value='${valorOption}'>${qtdeExibicao}</option>
                                    <option value='1'>1</option>
                                    <option value='2'>2</option>
                                    <option value='0.500'>1/2</option>
                                    <option value='0.3333'>1/3</option>
                                    <option value='0.250'>1/4</option>
                              </select>`
                     }else if(item.vende_balanca){
                        str +=  `<div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde-peso" data-upgraded=",MaterialTextfield">
                           <input class="mdl-textfield__input quantidade qtde-item" data-id='${index}' type="number" id="quantidade-${index}" value="${qtdeExibicao}">
                        </div>
                        <span class="negrito text-blue">Kg</span>`
                     }else{
                        str += `<a href="javascript:void(0)" class="btn-subtrai"  data-id='${index}'>
                           <i class="material-icons text-red md-48 btn-qtde">remove_circle</i>
                        </a>
                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde is-dirty is-upgraded container-qtde" data-upgraded=",MaterialTextfield">
                           <input class="mdl-textfield__input quantidade qtde-item" data-id='${index}' type="number" id="quantidade-${index}" value="${qtdeExibicao}">
                        </div>
                        <a href="javascript:void(0)" class="btn-adiciona"  data-id='${index}'>
                           <i class="material-icons text-green md-48 btn-qtde">add_circle</i>
                        </a>`
                     }

                     str +=  `</div>
                     <div class = "mdl-card__actions mdl-card--border  totalizador detalhe">
                        <a class = "${backOpcional} mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes btn-opcional" data-id="${index}">
                           <i class="material-icons">check</i> OPCIONAIS
                        </a>
                        <a class = "${backObservacao} mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes btn-observacao" data-id="${index}">
                           <i class="material-icons">assignment</i> OBSERVAÇÕES
                        </a>
                        <a class = "mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect btn-opcoes text-red btn-excluir" data-id="${index}">
                           <i class="material-icons">clear</i> EXCLUIR
                        </a>
                     </div>
               </div>`

            })

            str = '<div id="produtos-revisao">' + str + "</div>"
            $('#scroll-tab-3').html(str + `<div class="box-altura"></div>
               <div class = "mdl-shadow--4dp footer mdl-card__actions mdl-card--border container-finalizar mostra">
                  <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-red btn-limpar" data-upgraded=",MaterialButton" style="width: 49%">
                     <i class="material-icons">cancel</i>
                     LIMPAR
                  </button>
                  <button class="btn-rodape mdl-button mdl-js-button mdl-button--raised mdl-button--colored bk-green btn-finalizar" data-upgraded=",MaterialButton" style="width: 49%">
                     <i class="material-icons">check_circle</i>
                     FINALIZAR
                  </button>
               </div>`)
         }

      }

      function getDadosServidor(renderCategoria){
         EasyLoading.show({text: 'Atualizando Categorias...'});
         $.get('pesquisa_categoria_json.php', function(data, status, xhr){
            if (xhr.status == 200){
               localStorage.setItem('categorias', data);

               EasyLoading.show({text: 'Atualizando Produtos...'});
               $.get('pesquisa_produto_json.php', function(data, status, xhr){
                  if (xhr.status == 200){
                     localStorage.setItem('produtos', data);

                     EasyLoading.show({text: 'Atualizando Opcionais...'});
                     $.get('pesquisa_opcional_json.php', function(data, status, xhr){
                        if (xhr.status == 200){
                           localStorage.setItem('opcionais', data)

                           EasyLoading.show({text: 'Atualizando Observações...'});
                           $.get('pesquisa_observacao_json.php', function(data, status, xhr){
                              if (xhr.status == 200){
                                 localStorage.setItem('observacoes', data)
                                 CarregarCategorias()

                                 EasyLoading.hide();
                                 $('#page').show();
                                 Snackbar.show({text: 'Atualizado com sucesso!',
                                          actionText: 'Fechar',
                                          duration: 1000,
                                          pos: 'top-left'
                                       });
                              }
                           })
                        }
                     })  
                  }
               })	
            }
         })	
      }
   
      $(document).ready(function($) {

         /*******************************************************************************
          *******************************************************************************
          ******************************* ABA GERAL TOPO ********************************
          *******************************************************************************
          ********************************************************************************/

            $(window).load(function() {
               function getAncoraURL(url){

                     if (url == '' || url == undefined){
                        var ancora = window.location.href;
                        ancora = ancora.toString().split("#");
                        url = '#header-' + ancora[1];
                     }

                     if(ancora) {
                        $(url)[0].click();
                     }
               }
               getAncoraURL();
            });

            function TotalizaPessoas(){
               $('#quantidade-pessoa').val(parseInt($('#quantidade-mulher').val()) + parseInt($('#quantidade-homem').val()));
            }

            function Subtrai(caixaValor){
               var qtde = parseInt(caixaValor.val());

               if (qtde > 0){
                  qtde -= parseInt(1);
                  caixaValor.val(qtde);
               }
            }

            function Adiciona(caixaValor){
               var qtde = parseInt(caixaValor.val());
               qtde += parseInt(1);
               caixaValor.val(qtde);
            }

            function AtualizarProdutos(){
               swal({
                  title: 'Atualizar Dados Offline ?',
                  type: 'question',
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'Sim, Atualizar!',
                  cancelButtonText: 'Não Atualizar!',
                  confirmButtonClass: 'btn btn-success',
                  cancelButtonClass: 'btn',
                  buttonsStyling: false,
                  reverseButtons: true
                  }).then((result) => {
                     if (result.value) {
                        getDadosServidor()
                     }
                  })
               
            }

            
            $('.link-atualizar').click(function(){
               AtualizarProdutos();
            });

            $('.btn-adiciona-mulher').click(function(){
               Adiciona($('#quantidade-mulher'));
               TotalizaPessoas();
            });

            $('.btn-remove-mulher').click(function(){
               Subtrai($('#quantidade-mulher'));
               TotalizaPessoas();
            });

            $('.btn-adiciona-homem').click(function(){
               Adiciona($('#quantidade-homem'));
               TotalizaPessoas();
            });

            $('.btn-remove-homem').click(function(){
               Subtrai($('#quantidade-homem'));
               TotalizaPessoas();
            });

            $('.btn-adiciona-pessoa').click(function(){
               Adiciona($('#quantidade-pessoa'));
            });

            $('.btn-remove-pessoa').click(function(){
               Subtrai($('#quantidade-pessoa'));
            });


            $('.link-imprimir').click(function(){

               var itens = '';
               $('.ckb:checked').each(function (index, value) {
                  itens = $(this).attr('data-item') + ', ' + itens;
               });

               if (itens == ''){
                swal(
                  'Alerta',
                  'Nenhum item selecionado!',
                  'warning'
                )
               }else{
                  swal({
                     title: 'Imprimir itens Selecionados?',
                     type: 'question',
                     showCancelButton: true,
                     confirmButtonColor: '#3085d6',
                     cancelButtonColor: '#d33',
                     confirmButtonText: 'Sim, Imprimir!',
                     cancelButtonText: 'Não Imprimir!',
                     confirmButtonClass: 'btn btn-success',
                     cancelButtonClass: 'btn',
                     buttonsStyling: false,
                     reverseButtons: true
                   }).then((result) => {
                      if (result.value) {
                        $.ajax({
                           url: 'ajax_envia_impressao.php',
                           type: 'POST',
                           dataType: 'json',
                           data: {itens: itens},
                           beforeSend: function(){
                              $('#page').hide();
                              EasyLoading.show({text: 'Enviando impressão ...'});
                           },
                           success: function(retorno){
                              if (retorno.status == 1){
                                 Snackbar.show({text: 'Itens enviados para Impressão!',
                                              actionText: 'Fechar',
                                              duration: 500,
                                              pos: 'top-left'
                                           });
                              }
                              setTimeout(function(){
                                 location.reload();
                              }, 1000)
                           }
                        });
                      }
                    })
               }
            });


            $('.btn-gravar-pessoas').click(function(){

               var homem   = $('#quantidade-homem').val();
               var mulher  = $('#quantidade-mulher').val();
               var pessoas = $('#quantidade-pessoa').val();
               var venda   = '<?=$_SESSION['VENDA']?>';

               swal({
                  title: 'Deseja gravar os Dados ?',
                  type: 'question',
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'Sim, Gravar!',
                  cancelButtonText: 'Não Gravar!',
                  confirmButtonClass: 'btn btn-success',
                  cancelButtonClass: 'btn',
                  buttonsStyling: false,
                  reverseButtons: true
               }).then((result) => {
                  if (result.value) {
                     $.ajax({
                        url: 'ajax_grava_pessoa.php',
                        type: 'POST',
                        dataType: 'json',
                        data: {homem: homem, mulher: mulher, pessoas: pessoas, venda: venda},
                        beforeSend: function(){
                           $('#page').hide();
                           EasyLoading.show({text: 'Aguarde, gravando ...'});
                        },
                        success: function(retorno){
                           // EasyLoading.hide();
                           if (retorno.status == 1){
                              Snackbar.show({text: 'Gravado com sucesso !',
                                          actionText: 'Fechar',
                                          duration: 500,
                                          pos: 'top-left'
                                       });
                           }
                           setTimeout(function(){
                              location.reload();
                           }, 1000)
                        }
                     });
                  }
               })
          
            });


          /*******************************************************************************
           *******************************************************************************
           *************************** ABA 1 ITENS FINALIZADOS ***************************
           *******************************************************************************
           *******************************************************************************/

            $('.btn-fechamento').click(function(){
               swal({
                 title: 'Imprimir Pré-Fechamento?',
                 type: 'question',
                 showCancelButton: true,
                 confirmButtonColor: '#3085d6',
                 cancelButtonColor: '#d33',
                 confirmButtonText: 'Sim, Imprimir!',
                 cancelButtonText: 'Não Imprimir!',
                 confirmButtonClass: 'btn btn-success',
                 cancelButtonClass: 'btn',
                 buttonsStyling: false,
                 reverseButtons: true
               }).then((result) => {
                 if (result.value) {
                    $.ajax({
                        url: 'ajax_envia_impressao_pre_fechamento.php',
                        type: 'POST',
                        dataType: 'json',
                        beforeSend: function(){
                          $('#page').hide();
                          EasyLoading.show({text: 'Enviando Impressão ...'});
                        },
                        success: function(retorno){
                          if (retorno.status == 1){
                              Snackbar.show({text: 'Impressão enviada com sucesso!',
                                            actionText: 'Fechar',
                                            duration: 500,
                                            pos: 'top-left'
                                          });
                              setTimeout(function(){
                                 EasyLoading.show({text: 'Aguarde, carregando ...'});
                                 window.location.href = '<?=$linkListagem?>';
                              }, 500)
                          }else{
                           $('#page').show();
                          }
                        }
                    });
                 }
               })
            });

            $('.duplicar').on('click', function(){
               var id = $(this).attr('data-id');

               if (id != ''){
                  swal({
                    title: 'Deseja duplicar esse item?',
                    type: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Sim, Duplicar!',
                    cancelButtonText: 'Não Duplicar!',
                    confirmButtonClass: 'btn btn-success',
                    cancelButtonClass: 'btn',
                    buttonsStyling: false,
                    reverseButtons: true
                  }).then((result) => {
                     if (result.value) {
                        let ordem = 1
                        let carrinho = []
                        let produtos = []
                        let produto = {}

                        if ( localStorage.hasOwnProperty('carrinho') ){
                           carrinho = JSON.parse(localStorage.getItem('carrinho'))
                           carrinho.sort((a, b) => Number(b.ordem) - Number(a.ordem))
                           ordem = carrinho[0].ordem + 1
                        }

                        produtos = JSON.parse(localStorage.getItem('produtos'))
                        let produto_selecionado = produtos.filter(prod => (prod.mat_001 == id))

                        if ( produto_selecionado ){
                           indice = ((new Date().getTime() / 1000) * Math.random()).toString()
                           produto.ordem = ordem
                           produto.indice = indice.replace(/\./g, '')
                           produto.id = produto_selecionado[0].mat_001
                           produto.codigo = produto_selecionado[0].mat_004
                           produto.descricao = produto_selecionado[0].mat_003
                           produto.vende_tamanho = produto_selecionado[0].b_venda_tamanho
                           produto.vende_fracionado = produto_selecionado[0].fracionado
                           produto.vende_balanca = produto_selecionado[0].b_peso_balanca
                           produto.quantidade = parseFloat("1.000").toFixed(3)
                           produto.tamanho_padrao = produto_selecionado[0].tamanho_padrao

                           if ( produto_selecionado[0].b_venda_tamanho ){
                              produto.tamanho_pedido = produto_selecionado[0].tamanho_padrao
                           }else{
                              produto.tamanho_pedido = 'M'
                           }

                           produto.valor_p = produto_selecionado[0].valor_tam_p 
                           produto.valor_m = produto_selecionado[0].valor_tam_m  
                           produto.valor_g = produto_selecionado[0].valor_tam_g 
                           produto.valor_gg = produto_selecionado[0].valor_tam_gg  
                           produto.valor_extra = produto_selecionado[0].valor_tam_extra 
                           produto.impressora = produto_selecionado[0].impressora 
                           produto.id_fracionado = 0
                           produto.categoria = produto_selecionado[0].cat_001 
                           produto.status = 'A'
                           produto.observacao = ''
                           produto.opcao_observacao = ''
                           produto.opcional = []
                           produto.pacote = []

                           carrinho.push(produto)
                           localStorage.setItem('carrinho', JSON.stringify(carrinho))

                           $('.mdl-layout__content').scrollTop(5);

                           getProdutosRevisaoStorage()
                           $('#header-scroll-tab-3')[0].click();
                           $('.mdl-badge').removeClass('not-visivel')
                                                .addClass('visivel')
                                                .attr('data-badge', carrinho.length);

                           Snackbar.show({text: 'Produto está como pendente!',
                                          actionText: 'Fechar',
                                          duration: 500,
                                          pos: 'top-left'
                                       });
                        }
                     }
                  })
               }
            });


          /*******************************************************************************
           *******************************************************************************
           *************************** ABA 2 LISTA DE PRODUTOS ***************************
           *******************************************************************************
           *******************************************************************************/

            var categoriaSelecionada = '';

            function getProdutosCategoria(id){
                $.ajax({
                    url: 'ajax_produto_categoria.php',
                    type: 'POST',
                    dataType: 'html',
                    data: {categoria: id, canal: '<?=$_SESSION['TIPO']?>'},
                    beforeSend: function(){
                      $('#produtos-categoria').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");
                    },
                    success: function(retorno){
                      $('#produtos-categoria').html(retorno);
                    }
                });
            }

            function getProdutosCategoriaStorage(id){
               $('#produtos-categoria').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");

               if (localStorage.hasOwnProperty('produtos')){
                  let produtos = JSON.parse(localStorage.getItem('produtos'))
                  let container = document.getElementById('produtos-categoria')
                  let tamanhos = JSON.parse(tamanhos_servidor)

                  let str = ''
                  
                  container.innerHTML = ''
                  produtos.forEach(produto => {
                     if (id == produto.cat_001 || id == ''){
                        let descricao = produto.descricao ? produto.descricao : ''
                        let valores = ''

                        if (produto.b_venda_tamanho == true){

                           if (produto.valor_tam_p != "0.00"){
                              let objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'P')
                              valores = `${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_p
                           }

                           if (produto.valor_tam_m != "0.00"){
                              let objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'M')
                              valores += (valores != '') ? ` / ${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_m : `${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_m
                           }

                           if (produto.valor_tam_g != "0.00"){
                              let objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'G')
                              valores += (valores != '') ? ` / ${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_g : `${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_g
                           }

                           if (produto.valor_tam_gg != "0.00"){
                              let objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'GG')
                              valores += (valores != '') ? ` / ${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_gg : `${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_gg
                           }

                           if (produto.valor_tam_extra != "0.00"){
                              let objTamanho = tamanhos.filter(tempTamanho => tempTamanho.sigla == 'E')
                              valores += (valores != '') ? ` / ${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_extra : `${objTamanho[0].tamanho.substring(3, 0)} ` + produto.valor_tam_extra
                           }
                        }else{
                           if (produto.mat_008 != "0.00"){
                              valores = produto.mat_008
                           }
                        }

                        str += `<a href="javascript:void(0)" 
                                 data-id="${produto.mat_001}" 
                                 data-fracao="${(produto.fracionado) ? '1' : '0'}" 
                                 data-etapa="${(produto.possui_etapa != "0") ? '1' : '0'}" 
                                 data-rodizio="${produto.rodizio}"
                                 class="container-adicionar mdl-shadow--6dp">
                                 <div class = "wide-card mdl-card mdl-shadow--4dp mdl-card--border card-produto">
                                 <div class = "mdl-card__actions titulo-produto">
                                    <p class="text-left text-black">
                                       ${produto.mat_004} - ${produto.mat_003.toUpperCase()}
                                    </p>
                                    <p class="text-left text-gray">${descricao}</p>
                                    <p class="text-red">${valores}</p>
                                 </div>
                                 </div>
                              </a>`
                     }
                  })

                  container.innerHTML = str
               }

            }

            $('.acao-div-categoria').on('click', function(){

               if ($('.div-geral-categorias').hasClass('aberto')){
                  $('.div-geral-categorias').removeClass('aberto')
                                            .addClass('fechado')
                                            .fadeOut("100");

                  $('.acao-div-categoria span').html('EXIBIR CATEGORIAS');
                  $('.acao-div-categoria i').html('keyboard_arrow_down');
               }else{
                  $('.div-geral-categorias').removeClass('fechado')
                                            .addClass('aberto')
                                            .fadeIn("100");

                  $('.acao-div-categoria span').html('ESCONDER CATEGORIAS');
                  $('.acao-div-categoria i').html('keyboard_arrow_up');
               }
            });

            $('#pesquisa').on('input', function(event) {
               let termo = $(this).val();
               let container = document.getElementById('produtos-categoria')

               if(termo.length >= 1){
                  $('#produtos-categoria').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");

                  if (localStorage.hasOwnProperty('produtos')){
                     let produtos = JSON.parse(localStorage.getItem('produtos'))

                     let str = ''
                     produtos.forEach(produto => {
                        if (produto.mat_003.indexOf(termo.toUpperCase()) >= 0 ||  produto.mat_004 == termo.toUpperCase()){
                           let descricao = produto.descricao ? produto.descricao : ''
                           let valores = ''

                           if (produto.b_venda_tamanho == true){
                              if (produto.valor_tam_p != "0.00"){  
                                 valores = 'Pq ' + produto.valor_tam_p
                              }

                              if (produto.valor_tam_m != "0.00"){
                                 valores += (valores != '') ? ' / Med ' + produto.valor_tam_m : 'Med ' + produto.valor_tam_m
                              }

                              if (produto.valor_tam_g != "0.00"){
                                 valores += (valores != '') ? ' / Grd ' + produto.valor_tam_g : 'Grd ' + produto.valor_tam_g
                              }

                              if (produto.valor_tam_gg != "0.00"){
                                 valores += (valores != '') ? ' / GG ' + produto.valor_tam_gg : 'GG ' + produto.valor_tam_gg
                              }

                              if (produto.valor_tam_extra != "0.00"){
                                 valores += (valores != '') ? ' / Ext ' + produto.valor_tam_extra : 'Ext ' + produto.valor_tam_extra
                              }
                           }else{
                              if (produto.mat_008 != "0.00"){
                                 valores = produto.mat_008
                              }
                           }

                           str += `<a href="javascript:void(0)" 
                                    data-id="${produto.mat_001}" 
                                    data-fracao="${(produto.fracionado) ? '1' : '0'}" 
                                    data-etapa="${(produto.possui_etapa != "0") ? '1' : '0'}" 
                                    data-rodizio="${produto.rodizio}"
                                    class="container-adicionar mdl-shadow--6dp">
                                    <div class = "wide-card mdl-card mdl-shadow--4dp mdl-card--border card-produto">
                                    <div class = "mdl-card__actions titulo-produto">
                                       <p class="text-left text-black">
                                          ${produto.mat_004} - ${produto.mat_003.toUpperCase()}
                                       </p>
                                       <p class="text-left text-gray">${descricao}</p>
                                       <p class="text-red">${valores}</p>
                                    </div>
                                    </div>
                                 </a>`
                        }
                     })

                     container.innerHTML = str
                  }
               }else{
                  container.innerHTML = ''
               }

            });

            $(document).on('click', '.btn-categoria', function(){
               var id = $(this).attr('data-id');


               if ($(this).hasClass('mdl-js-ripple-effects')){
                  $('.btn-categoria').addClass('mdl-js-ripple-effects')
                                     .removeClass('mdl-button--colored');

                  $(this).addClass('mdl-button--colored')
                         .removeClass('mdl-js-ripple-effects');(id);

                  categoriaSelecionada = id;
                  getProdutosCategoriaStorage(id);
               }
            });

            $(document).on('click', '.container-adicionar', function(){
               let id = $(this).attr('data-id')
               let fracao = $(this).attr('data-fracao') // VENDE FRACIONADO
               let possui_etapa = $(this).attr('data-etapa') // POSSUI ETAPA
               let ordem = 1
               let tipo   = '<?=$_SESSION['TIPO']?>'
               let ESCOLHA_SABORES   = '<?=ESCOLHA_SABORES?>'
               let HABILITA_ETAPA   = '<?=HABILITA_ETAPA?>'
               let RODIZIO = $(this).attr('data-rodizio')

               if (id != ''){
                  if (RODIZIO == 1){
                     window.location.href = 'rodizio.php?venda=<?=$venda?>&mesa=<?=$idMesa?>&comanda=<?=$comanda?>&tipo=<?=$tipo?>&codigo='+id+'&situacao=inclusao';
                  }else if (fracao == 1 && ESCOLHA_SABORES){
                     if (tipo == 'M'){
                        window.location.href = 'fracionamento.php?mesa=<?=$idMesa?>&venda=<?=$venda?>&tipo=<?=$tipo?>&codigo='+id;
                     }else{
                        window.location.href = 'fracionamento.php?comanda=<?=$comanda?>&venda=<?=$venda?>&tipo=<?=$tipo?>&codigo='+id;
                     }
                  }else if(HABILITA_ETAPA && possui_etapa == 1){
                     if (tipo == 'M'){
                        window.location.href = 'etapa.php?mesa=<?=$idMesa?>&venda=<?=$venda?>&tipo=<?=$tipo?>&codigo='+id;
                     }else{
                        window.location.href = 'etapa.php?comanda=<?=$comanda?>&venda=<?=$venda?>&tipo=<?=$tipo?>&codigo='+id;
                     }
                  }else{
                     EasyLoading.show({text: 'Adicionando ...'});

                     let carrinho = []
                     let produto = {}
                     let produtos = JSON.parse(localStorage.getItem('produtos'))

                     if (localStorage.hasOwnProperty('carrinho')){
                        carrinho = JSON.parse(localStorage.getItem('carrinho'))

                        if ( carrinho.length > 0 ){
                           carrinho.sort((a, b) => Number(b.ordem) - Number(a.ordem))
                           ordem = carrinho[0].ordem + 1
                        }
                     }

                     let produto_selecionado = produtos.filter(prod => (prod.mat_001 == id))
                     
                     if (produto_selecionado){
                        indice = ((new Date().getTime() / 1000) * Math.random()).toString()
                        produto.ordem = ordem
                        produto.indice = indice.replace(/\./g, '')
                        produto.id = produto_selecionado[0].mat_001
                        produto.codigo = produto_selecionado[0].mat_004
                        produto.descricao = produto_selecionado[0].mat_003
                        produto.vende_tamanho = produto_selecionado[0].b_venda_tamanho
                        produto.vende_fracionado = produto_selecionado[0].fracionado
                        produto.vende_balanca = produto_selecionado[0].b_peso_balanca
                        produto.quantidade = parseFloat("1.000").toFixed(3)
                        produto.tamanho_padrao = produto_selecionado[0].tamanho_padrao

                        if (produto_selecionado[0].b_venda_tamanho){
                           produto.tamanho_pedido = produto_selecionado[0].tamanho_padrao
                        }else{
                           produto.tamanho_pedido = 'M'
                        }

                        produto.valor_p = produto_selecionado[0].valor_tam_p 
                        produto.valor_m = produto_selecionado[0].valor_tam_m  
                        produto.valor_g = produto_selecionado[0].valor_tam_g 
                        produto.valor_gg = produto_selecionado[0].valor_tam_gg  
                        produto.valor_extra = produto_selecionado[0].valor_tam_extra 
                        produto.impressora = produto_selecionado[0].impressora 
                        produto.id_fracionado = 0
                        produto.categoria = produto_selecionado[0].cat_001 
                        produto.status = 'A'
                        produto.observacao = ''
                        produto.opcao_observacao = ''
                        produto.opcional = []
                        produto.pacote = []

                        carrinho.push(produto)
                        localStorage.setItem('carrinho', JSON.stringify(carrinho))
                        EasyLoading.hide();

                        $('#pesquisa').val('');
                        $('.mdl-layout__content').scrollTop(5);

                        getProdutosRevisaoStorage()
                        $('#header-scroll-tab-3')[0].click();
                        $('.mdl-badge').removeClass('not-visivel')
                                             .addClass('visivel')
                                             .attr('data-badge', carrinho.length);

                        Snackbar.show({text: 'Produto adicionado com sucesso!',
                                                actionText: 'Fechar',
                                                duration: 1000,
                                                pos: 'top-left'
                                             });
                     }
                  }
               }
            });


          /******************************************************************************
           ******************************************************************************
           *************************** ABA 3 ITENS PENDENTES ****************************
           ******************************************************************************
           ******************************************************************************/

            function getProdutosRevisao(){
                $.ajax({
                  url: 'ajax_produto_revisao.php',
                  type: 'POST',
                  dataType: 'html',
                  beforeSend: function(){
                     $('#produtos-revisao').html("<div class='text-center'><br><br><img src='img/aguarde.gif' width = '100'></div>");
                  },
                  success: function(retorno){
                     if (retorno.trim() != ''){
                        $('.container-finalizar').removeClass('esconde')
                                                 .addClass('mostra');
                        $('#produtos-revisao').html(retorno);
                     }else{
                        $('.container-finalizar').removeClass('mostra')
                                                 .addClass('esconde');
                        $('.mdl-badge').removeClass('not-visivel')
                                       .addClass('visivel')
                                       .attr('data-badge', 0);
                        $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
                     }
                  }
               });
            }

            function gravarItemRevisao(){
               $.ajax({
                  url: 'ajax_gravar_revisao.php',
                  type: 'POST',
                  dataType: 'json',
                  data: {item: item, qtde: qtde, obs1: obs1, obs2: obs2},
                  beforeSend: function(){
                     EasyLoading.show({text: 'Gravando ...'});
                  },
                  success: function(retorno){
                     EasyLoading.hide();
                  }
               });
            }

            $(document).on('blur', '.quantidade', function(event) {
               var id   = $(this).attr('data-id');
               var qtde = parseFloat($('#quantidade-'+id).val());

               let carrinho = []
               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == id){
                     item.quantidade = qtde.toFixed(3)
                  }
               })

               localStorage.setItem('carrinho', JSON.stringify(carrinho))
            });

            $(document).on('click', '.btn-adiciona', function(event) {
               var id   = $(this).attr('data-id');
               var qtde = parseFloat($('#quantidade-'+id).val());


               qtde += parseFloat(1)
               $('#quantidade-'+id).val(qtde)

               let carrinho = []
               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == id){
                     item.quantidade = qtde.toFixed(3)
                  }
               })

               localStorage.setItem('carrinho', JSON.stringify(carrinho))
            });

            $(document).on('click', '.btn-subtrai', function(event) {
               var id   = $(this).attr('data-id');
               var qtde = parseFloat($('#quantidade-'+id).val());

               if (qtde > 1){
                  qtde -= parseFloat(1)
                  $('#quantidade-'+id).val(qtde);

                  let carrinho = []
                  if (localStorage.hasOwnProperty('carrinho')){
                     carrinho = JSON.parse(localStorage.getItem('carrinho'))
                  }

                  carrinho.forEach(item => {
                     if (item.indice == id){
                        item.quantidade = qtde.toFixed(3)
                     }
                  })

                  localStorage.setItem('carrinho', JSON.stringify(carrinho))
               }
            });

            $(document).on('click', '.btn-limpar', function(){
               swal({
                 title: 'Limpar Itens Pendentes?',
                 type: 'question',
                 showCancelButton: true,
                 confirmButtonColor: '#3085d6',
                 cancelButtonColor: '#d33',
                 confirmButtonText: 'Sim, Limpar!',
                 cancelButtonText: 'Não Limpar!',
                 confirmButtonClass: 'btn btn-danger',
                 cancelButtonClass: 'btn',
                 buttonsStyling: false,
                 reverseButtons: true
               }).then((result) => {
                 if (result.value) {
                     if (localStorage.hasOwnProperty('carrinho')){
                        localStorage.removeItem('carrinho')

                        $('.mdl-badge').removeClass('visivel')
                                       .addClass('not-visivel')
                                       .attr('data-badge', 0);
                        $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
                        $('.container-finalizar').removeClass('mostra')
                                                .addClass('esconde');
                        Snackbar.show({text: 'Itens excluídos com sucesso!',
                                       actionText: 'Fechar',
                                       duration: 1000,
                                       pos: 'top-left'
                                    });
                     }
                 }
               })
            });

            $(document).on('click', '.btn-finalizar', function(){
               swal({
                 title: 'Finalizar Pedido?',
                 type: 'question',
                 showCancelButton: true,
                 confirmButtonColor: '#3085d6',
                 cancelButtonColor: '#d33',
                 confirmButtonText: 'Sim, Finalizar!',
                 cancelButtonText: 'Não Finalizar!',
                 confirmButtonClass: 'btn btn-success',
                 cancelButtonClass: 'btn',
                 buttonsStyling: false,
                 reverseButtons: true
               }).then((result) => {
                  if (result.value) {
                     let carrinho = []
                     if (localStorage.hasOwnProperty('carrinho')){
                        carrinho = JSON.parse(localStorage.getItem('carrinho'))
                     }

                     $('.tamanho').each(function (index, value) {
                         let tamanho = $(this).val()
                        
                         carrinho.forEach(item => {
                            if (item.indice == $(this).attr('data-id')){
                               item.tamanho_pedido = tamanho
                            }
                         })
                     })

                     localStorage.setItem('carrinho', JSON.stringify(carrinho))

                     let jsonPedido = {}
                     let pessoas  = $('#quantidade-pessoa').val()
                     pessoas = (pessoas == '') ? '1' : pessoas;
                     jsonPedido.venda = '<?=$_SESSION['VENDA']?>'
                     jsonPedido.tipo  = '<?=$_SESSION['TIPO']?>'
                     jsonPedido.cliente  = '<?=$_SESSION['CLIENTE']?>'
                     jsonPedido.id_mesa = '<?=$_SESSION['ID_MESA']?>';
                     jsonPedido.controle = '<?=$_SESSION['CONTROLE']?>';
                     jsonPedido.pessoas = pessoas
                     jsonPedido.id_atendente = '<?=$_COOKIE['id']?>'
                     jsonPedido.login = '<?=$_COOKIE['login']?>'
                     jsonPedido.atendente = '<?=$_COOKIE['usuario']?>'

                     let date = new Date();
                     let options = { year: 'numeric', month: '2-digit', day: '2-digit', hour: '2-digit', minute:'2-digit', second:'2-digit' };
                     jsonPedido.data_hora = date.toLocaleDateString('pt-BR', options)

                     jsonPedido.itens = carrinho
                     console.log(JSON.stringify(jsonPedido))

                     $.ajax({
                        url: 'ajax_gravar_pedido_json.php',
                        type: 'POST',
                        dataType: 'json',
                        data: {pedido: JSON.stringify(jsonPedido)},
                        beforeSend: function(){
                           $('#page').hide();
                           EasyLoading.show({text: 'Aguarde, enviando Pedido ...'});
                        },
                        error: function(error){
                           let erro = (error.status == 0) ? 'Perda de comunicação via Wifi !' : error.responseText;
                           EasyLoading.hide();
                           swal(
                                'Erro',
                                erro,
                                'warning'
                              );
                           $('#page').show();
                        },
                        success: function(retorno){
                           if (retorno.status == 1){
                              localStorage.removeItem('carrinho')
                              $('#produtos-revisao').html('');
                              var html = $('#produtos-revisao').html();
                              if (html.trim() == ""){
                                 $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
                                 $('.container-finalizar').removeClass('mostra')
                                                          .addClass('esconde');
                                 $('.mdl-badge').removeClass('visivel')
                                          .addClass('not-visivel')
                                          .attr('data-badge', 0);
                              }

                              setTimeout(function(){
                                 EasyLoading.show({text: 'Gravado com sucesso, redirecionando ...'});
                                 $('#header-scroll-tab-1')[0].click();
                                 $('#page').hide();
                                 location.reload();
                              }, 500)
                           }else{
                              EasyLoading.hide();
                              swal(
                                'Erro',
                                retorno.mensagem,
                                'warning'
                              );
                              $('#page').show();
                           }
                        }
                     });

                 }
               })
            });

            $(document).on('click', '.btn-excluir', function(){
               var indice = $(this).attr('data-id');

               swal({
                 title: 'Excluir Item?',
                 type: 'question',
                 showCancelButton: true,
                 confirmButtonColor: '#3085d6',
                 cancelButtonColor: '#d33',
                 confirmButtonText: 'Sim, Excluir!',
                 cancelButtonText: 'Não Excluir!',
                 confirmButtonClass: 'btn btn-danger',
                 cancelButtonClass: 'btn',
                 buttonsStyling: false,
                 reverseButtons: true
               }).then((result) => {
                 if (result.value) {
                     let carrinho = []
                     let carrinho_novo = []

                     if (localStorage.hasOwnProperty('carrinho')){
                        carrinho = JSON.parse(localStorage.getItem('carrinho'))
                     }

                     if (carrinho.length > 0){

                        carrinho_novo = carrinho.filter(item => (item.indice != indice))
                        localStorage.setItem('carrinho', JSON.stringify(carrinho_novo))
                        $('.item-'+indice).remove();

                        if (carrinho_novo.length == 0){
                           $('#produtos-revisao').html("<h4 class='text-center text-blue vazio'>Nenhum Item Pendente <i class='material-icons'>thumb_up</i></h4>");
                           $('.container-finalizar').removeClass('mostra')
                                                    .addClass('esconde');
                           $('.mdl-badge').removeClass('visivel')
                                    .addClass('not-visivel')
                                    .attr('data-badge', 0);
                        }else{
                           $('.mdl-badge').attr('data-badge', carrinho_novo.length);
                        }

                        Snackbar.show({text: 'Produto excluído com sucesso!',
                                       actionText: 'Fechar',
                                       duration: 1000,
                                       pos: 'top-left'
                                    });
                     }
                 }
               })
            });

            $(document).on('click', '.btn-observacao', function(){
               let indice = $(this).attr('data-id')
               let elemento = $(this)
               let textoGravado = ''
               let opcaoObservacao = ''
               let categoria = 0
               let html = ''
               let carrinho = []
               let observacaoStorage = []
               let observacoes = []

               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == indice){
                     textoGravado = item.observacao
                     opcaoObservacao = item.opcao_observacao
                     categoria = item.categoria
                  }
               })

               if (localStorage.hasOwnProperty('observacoes')){
                  observacaoStorage = JSON.parse(localStorage.getItem('observacoes'))
               }

               if (observacaoStorage.length > 0){
                  observacoes = observacaoStorage.filter(obs => (obs.id_categoria == categoria && obs.observacao != opcaoObservacao))
               }

               html = `<input type="text" id="texto-observacao"  autocomplete="off" class="mdl-textfield__input observacao" placeholder="Digite uma Observação" value="${textoGravado}"><br>` 

               if (observacoes.length > 0 || opcaoObservacao != ''){

                  html += `<p>OU</p><br>` +
                          `<select class='select' id='opcao-observacao' required>
                              <option value='${opcaoObservacao}'>${opcaoObservacao}</option>`
                              observacoes.forEach(item => {
                                 html += `<option value='${item.observacao}'>${item.observacao.toUpperCase()}</option>`
                              })
                           html +=  `<option value=''>NENHUMA</option></select>`
               }

               swal({
                  title: 'Observações',
                  html: html,
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'GRAVAR',
                  cancelButtonText: 'FECHAR',
                  confirmButtonClass: 'btn btn-success',
                  cancelButtonClass: 'btn btn-danger',
                  buttonsStyling: false,
                  reverseButtons: true,
                  focusConfirm: true
               }).then((result) => {
                  if (result.value) {
                     var texto = $('#texto-observacao').val()
                     var opcao = $('#opcao-observacao').val()

                     carrinho.forEach(item => {
                        if (item.indice == indice){
                           item.observacao = texto.toUpperCase()

                           if (opcao !== undefined) {
                              item.opcao_observacao = opcao
                           } 
                        }
                     })

                     localStorage.setItem('carrinho', JSON.stringify(carrinho))
                     if (texto != '' || (opcao !== undefined && opcao != '')){
                        elemento.addClass('text-red');
                     }else{
                        elemento.removeClass('text-red');
                     }

                     Snackbar.show({text: 'Observação gravada com sucesso!',
                              actionText: 'Fechar',
                              duration: 500,
                              pos: 'top-left'
                           });
                  }    
               })
            });

            function OpcionalInteiro(indice, elemento){
               let opcionais = []
               let carrinho = []
               let opcoesStorage = []
               let opcoesItem = []
               let html = ''
               let categoria = 0
               let produto = {}

               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == indice){
                     categoria = item.categoria
                     produto = item
                  }
               })

               if (localStorage.hasOwnProperty('opcionais')){
                  opcoesStorage = JSON.parse(localStorage.getItem('opcionais'))
               }


               if (opcoesStorage.length > 0){
                  opcoesItem = opcoesStorage.filter(opcao => opcao.id_material == produto.id)
               }

               if (opcoesItem.length > 0){

                  html =  `<table class='mdl-data-table mdl-js-data-table mdl-data-table--selectable mdl-shadow--2dp'>
                             <tbody>`
                             opcoesItem.forEach(opcao => {
                                 let existeOpcional = (produto.opcional.find(opc => opc.id_opcional == opcao.id_opcional) != undefined) ? 'checked' : ''

                                 html += `<tr>
                                          <td width='10'>
                                          <input type='checkbox' id='checkbox${opcao.id_opcional}' class='ckb-opcional' value='${opcao.id_opcional}' ${existeOpcional}>
                                          </td>
                                          <td class = 'mdl-data-table__cell--non-numeric'><label for='checkbox${opcao.id_opcional}'>${opcao.descricao.toUpperCase()}</label></td>
                                          <td>R$ ${opcao.valor}</td>
                                          </tr>`
                                })
                  html +=    `</tbody>
                          </table>` 

                  swal({
                     title: 'Opcionais',
                     html: html,
                     showCancelButton: true,
                     confirmButtonColor: '#3085d6',
                     cancelButtonColor: '#d33',
                     confirmButtonText: 'GRAVAR',
                     cancelButtonText: 'FECHAR',
                     confirmButtonClass: 'btn btn-success',
                     cancelButtonClass: 'btn btn-danger',
                     buttonsStyling: false,
                     reverseButtons: true,
                     focusConfirm: true
                  }).then((result) => {
                     if (result.value) {

                        $('.ckb-opcional:checked').each(function() {
                           opcionais.push({
                              id_opcional: $(this).val(),
                              fracao: false,
                              completo: 0,
                              quantidade: 1
                           })
                        });

                        carrinho.forEach(item => {
                           if (item.indice == indice){
                              item.opcional = opcionais
                           }
                        })

                        localStorage.setItem('carrinho', JSON.stringify(carrinho))
                        if (opcionais.length > 0){
                           elemento.addClass('text-red');
                        }else{
                           elemento.removeClass('text-red');
                        }

                        Snackbar.show({text: 'Opcionais gravados com sucesso!',
                                       actionText: 'Fechar',
                                       duration: 500,
                                       pos: 'top-left'
                                    });
                     }
                  })
               }else{
                  swal(
						'Aviso',
						'Não existem Opcionais para o Item !' ,
						'error'
						)
               }

            }

            function OpcionalFracionado(indice, elemento){
               let opcionais = []
               let carrinho = []
               let opcoesStorage = []
               let opcoesItem = []
               let html = ''
               let categoria = 0
               let produto = {}

               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == indice){
                     categoria = item.categoria
                     produto = item
                  }
               })

               if (localStorage.hasOwnProperty('opcionais')){
                  opcoesStorage = JSON.parse(localStorage.getItem('opcionais'))
               }

               if (opcoesStorage.length > 0){
                  opcoesItem = opcoesStorage.filter(opcao => opcao.id_material == produto.id)
               }

               if (opcoesItem.length > 0){

                  html = `<table class='mdl-data-table mdl-js-data-table mdl-data-table--selectable mdl-shadow--2dp'>
                            <tbody>`
                              opcoesItem.forEach(opcao => {
                                 let checkedOpc = (produto.opcional.find(opc => opc.id_opcional == opcao.id_opcional) != undefined) ? 'checked' : ''
                                 let checkedFracao = (produto.opcional.find(opc => (opc.id_opcional == opcao.id_opcional && opc.fracao == true)) != undefined) ? 'checked' : ''
                                 html +=  `<tr>
                                             <td width='10'>
                                             <input type='checkbox' id='checkbox${opcao.id_opcional}' class='ckb-opcional' value='${opcao.id_opcional}' ${checkedOpc} >
                                             </td>
                                             <td class = 'mdl-data-table__cell--non-numeric'><label for='checkbox${opcao.id_opcional}'>${opcao.descricao.toUpperCase()} (${opcao.valor})</label></td>
                                             <td>
                                                   <div class="onoffswitch">
                                                      <input type="checkbox" ${checkedFracao} value='${opcao.id_opcional}' name="onoffswitch" class="onoffswitch-checkbox ckb-fracao" id="ckb-fracao-${opcao.id_opcional}">
                                                      <label class="onoffswitch-label" for="ckb-fracao-${opcao.id_opcional}">
                                                         <span class="onoffswitch-inner"></span>
                                                         <span class="onoffswitch-switch"></span>
                                                      </label>
                                                   </div>
                                             </td>
                                          </tr>`
                              })
                  html +=     `</tbody>
                           </table>`

                  swal({
                     title: 'Opcionais',
                     html: html,
                     showCancelButton: true,
                     confirmButtonColor: '#3085d6',
                     cancelButtonColor: '#d33',
                     confirmButtonText: 'GRAVAR',
                     cancelButtonText: 'FECHAR',
                     confirmButtonClass: 'btn btn-success',
                     cancelButtonClass: 'btn btn-danger',
                     buttonsStyling: false,
                     reverseButtons: true,
                     focusConfirm: true
                  }).then((result) => {
                     if (result.value) {

                        $('.ckb-opcional:checked').each(function() {
                           opcionais.push({
                              id_opcional: $(this).val(),
                              fracao: false,
                              completo: 0,
                              quantidade: 1
                           })
                        })

                        opcionais.forEach(opcao => opcao.fracao = false)

                        $('.ckb-fracao:checked').each(function() {
                              id_fracao = $(this).val()

                              opcionais.forEach(opcao => {
                                 if(opcao.id_opcional == id_fracao){
                                    opcao.fracao = true
                                 }
                              })
                        });

                        carrinho.forEach(item => {
                           if (item.indice == indice){
                              item.opcional = opcionais
                           }
                        })

                        localStorage.setItem('carrinho', JSON.stringify(carrinho))
                        if (opcionais.length > 0){
                           elemento.addClass('text-red');
                        }else{
                           elemento.removeClass('text-red');
                        }

                        Snackbar.show({text: 'Opcionais gravados com sucesso!',
                                       actionText: 'Fechar',
                                       duration: 500,
                                       pos: 'top-left'
                                    });
                     }
                  })
               }else{
                  swal(
						'Aviso',
						'Não existem Opcionais para o Item !',
						'error'
						)
               }

            }

            $(document).on('click', '.btn-opcional',function(){
               var item = $(this).attr('data-id');
               var elemento = $(this);
               var qtde = $('#select-'+item);

               if (qtde.length === 0 || qtde.val() >= 1){
                  OpcionalInteiro(item, elemento);
               }else{
                  OpcionalFracionado(item, elemento);
               }
            });


            $(document).on('change', '.qtde-item',function(){
               var indice = $(this).attr('data-id');
               var qtde = parseFloat($(this).val()).toFixed(3)

               let carrinho = []
               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == indice){
                     item.quantidade = qtde
                  }
               })

               localStorage.setItem('carrinho', JSON.stringify(carrinho))
            });


            $(document).on('change', '.tamanho',function(){
               var indice = $(this).attr('data-id');
               var elemento = $(this);

               let carrinho = []
               if (localStorage.hasOwnProperty('carrinho')){
                  carrinho = JSON.parse(localStorage.getItem('carrinho'))
               }

               carrinho.forEach(item => {
                  if (item.indice == indice){
                     item.tamanho_pedido = elemento.val()
                  }
               })

               localStorage.setItem('carrinho', JSON.stringify(carrinho))
            });

            $(document).on('click', '.titulo', function(){
               var venda    = '<?=$_SESSION['VENDA']?>';
               var cliente  = '<?=$_SESSION['CLIENTE']?>';

               if(venda == ''){
                  swal(
                      'Alerta',
                      'Só é possível informar o Cliente após a venda ser gravada !',
                      'warning'
                    )
                  return false;
               }
           
               swal({
                  title: 'Nome do Cliente',
                  html: "<input autofocus type='text' value='"+cliente+"' id='nome' placeholder='Informe o Nome' class='inpt-cliente text-red' autocomplete='off'>",
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'Gravar Cliente',
                  cancelButtonText: 'Cancelar',
                  confirmButtonClass: 'btn btn-success',
                  cancelButtonClass: 'btn btn-danger',
                  buttonsStyling: false,
                  reverseButtons: true,
                  focusConfirm: true
               }).then((result) => {
                  if (result.value) {
                     var cliente = $('#nome').val();
      
                     $.ajax({
                        url: 'ajax_gravar_nome_mesa.php',
                        type: 'POST',
                        dataType: 'json',
                        data: {venda: venda, cliente: cliente},
                        success: function(retorno){
                           if (retorno.status == 1){
                              Snackbar.show({text: 'Gravado com sucesso, recarregando ',
                                       actionText: 'Fechar',
                                       duration: 500,
                                       pos: 'bottom-left'
                                    });
                              
                              setTimeout(function(){
                                 EasyLoading.show({text: 'Aguarde, carregando ...'});
                                 $('#header-scroll-tab-1')[0].click();
                                 $('#page').hide();
                                 location.reload();
                              }, 500);
                           }else{
                              Snackbar.show({text: 'Erro ao gravar Cliente!',
                                          actionText: 'Fechar',
                                          actionTextColor: '#FF0000',
                                          duration: 500,
                                          pos: 'bottom-left'
                                       });
                           }
                        }
                     });
                  } 
               })
            });

      });
   </script>
   </body>
</html>
