<?php
require 'verifica_cookie.php';
require 'conexao.php';

$categoria = (isset($_GET['categoria'])) ? $_GET['categoria'] : '';
$mesa      = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda   = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$cliente   = (isset($_GET['cliente'])) ? $_GET['cliente'] : '' ;
$pdo       = Conexao::getInstance();

$sql = "SELECT mat_001, mat_003, c.cat_002 , mat_004, valor_tam_p, valor_tam_m, valor_tam_g ";
$sql .= "FROM materiais m INNER JOIN categoria c ON m.cat_001 = c.cat_001 ";
$sql .= "WHERE m.sit_001 = 4 ";

if ($categoria):
	$sql .= "AND m.cat_001 = '{$categoria}' ";
endif;

$sql .= "ORDER BY mat_004 LIMIT 100";
$stm = $pdo->prepare($sql);
$stm->execute();
$produtos = $stm->fetchAll(PDO::FETCH_OBJ);
?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">
	  
	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	  	<div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone">
	  		<h4>Produtos Cadastrados</h4>
	  		<div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
			    <input class="mdl-textfield__input" type="text" id="pesquisa">
			    <label class="mdl-textfield__label" for="sample3">Pesquisar por Código ou Descrição</label>
			</div>

			<div id='box-produto'>
				<?php foreach($produtos as $produto):?>
					<div class="mdl-card mdl-shadow--4dp">
					   <div class="mdl-card__title">
					    <h4 class="mdl-card__supporting-text"><?=$produto->mat_004?> - <?=$produto->mat_003?></h4>
					    <?php if($mesa || $comanda):?>
					    	<a href="quantidade.php?produto=<?=$produto->mat_004?>&mesa=<?=$mesa?>&comanda=<?=$comanda?>&cliente=<?=$cliente?>"><i class="material-icons">add_circle</i></a> 
					    <?php endif; ?>
					  </div>
					  <?php if ($produto->cat_002 == 'PIZZA'): ?>
					  	<span>Grande R$ <?=number_format($produto->valor_tam_g, 2, ',', '.')?> / Brotinho R$ <?=number_format($produto->valor_tam_p, 2, ',', '.')?></span>
					  <?php else: ?>
					  	<span>R$ <?=number_format($produto->valor_tam_m, 2, ',', '.')?></span>
					  <?php endif; ?>
					</div><br>
				<?php endforeach;?>
			</div>

		</div>
	  </div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script>

    jQuery(document).ready(function($) {	

    	$('#pesquisa').on('input', function(event) {
    		var termo = $(this).val();

    		if(termo.length >= 2){
    			$.ajax({
    				url: 'pesquisa_produto_ajax.php',
    				type: 'POST',
    				dataType: 'html',
    				data: {termo: termo, mesa: '<?=$mesa?>', cliente: '<?=$cliente?>', comanda: '<?=$comanda?>'},
    				success: function(retorno){
    					$('#box-produto').html(retorno);
    				}
    			});
    			
    		}
    	});

    });
  </script>
</body>
</html>
