<?php
require 'verifica_cookie.php';
require 'conexao.php';

$cod_prod= (isset($_GET['produto'])) ? $_GET['produto'] : '';
$mesa    = (isset($_GET['mesa'])) ? $_GET['mesa'] : '' ;
$comanda = (isset($_GET['comanda'])) ? $_GET['comanda'] : '' ;
$cliente = (isset($_GET['cliente'])) ? $_GET['cliente'] : '' ;
$pdo     = Conexao::getInstance();

$sql = "SELECT mat_001, mat_003, c.cat_002, c.cat_001, tamanho_padrao, b_venda_tamanho ";
$sql .= "FROM materiais m INNER JOIN categoria c ON m.cat_001 = c.cat_001 ";
$sql .= "WHERE m.sit_001 = 4 AND m.mat_004 = '{$cod_prod}'";
$stm = $pdo->prepare($sql);
$stm->execute();
$produto = $stm->fetch(PDO::FETCH_OBJ);

$sql = "SELECT id_opcional, descricao, valor FROM opcional ";
$sql .= "WHERE id_situacao = 4";
$stm = $pdo->prepare($sql);
$stm->execute();
$opcionais = $stm->fetchAll(PDO::FETCH_OBJ);

$categoria = $produto->cat_001;
$sql = "SELECT observacao FROM observacoes ";
$sql .= "WHERE id_categoria = {$categoria} ORDER BY observacoes";
$stm = $pdo->prepare($sql);
$stm->execute();
$observacoes = $stm->fetchAll(PDO::FETCH_OBJ);

?>
<!DOCTYPE html>
<html>
<head>
	<title>Comanda Eletrônica</title>
	<?php require 'include/head.php'; ?>
</head>
<body>
	<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">
	  
	  <?php require 'include/menu.php'; ?>

	  <div class="mdl-grid">
	  	<div class="mdl-cell mdl-cell--6-col mdl-cell--12-col-phone">
		  	<h4><?=$produto->mat_003?></h4>
	  		<?php if ($produto->b_venda_tamanho == TRUE):?>
	  			<p class="label-qtde">Quantidade</p>
	  			<select id='quantidade' class='select-qtde mdl-shadow--4dp'>
	  				<option value="1">1</option>
	  				<option value="2">2</option>
	  				<option value="0.500">1/2</option>
	  				<option value="0.3333">1/3</option>
	  			</select><br><br>
	  			<p class="label-qtde">Tamanho</p>
	  			<select id='tamanho' class='select-qtde mdl-shadow--4dp'>
	  				<option value="P" <?= ($produto->tamanho_padrao == 'P') ? 'selected' : ''; ?> >Brotinho</option>
	  				<option value="M" <?= ($produto->tamanho_padrao == 'M') ? 'selected' : ''; ?> >Média</option>
	  				<option value="G" <?= ($produto->tamanho_padrao == 'G') ? 'selected' : ''; ?> >Grande</option>
	  			</select><br><br>
	  			<p class="label-qtde">Itens Opcionais</p>
	  			<select id='opcional' class='select-qtde mdl-shadow--4dp'>
	  				<option value=""></option>
	  				<?php foreach($opcionais as $opcional): ?>
	  					<option value="<?=$opcional->id_opcional?>"><?=$opcional->descricao?> - R$ <?=number_format($opcional->valor, 2, ',', '.')?></option>
	  				<?php endforeach; ?>
	  			</select>
	  		<?php else: ?>
		  		<a href="javascript:void(0)" class="btn-subtrai">
			    	<i class="material-icons red md-48 btn-qtde">remove_circle</i>
			    </a> 
		  		<div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label qtde">
				    <input class="mdl-textfield__input center" type="number" id="quantidade" value="1">
				    <label class="mdl-textfield__label center" for="sample3">Quantidade</label>
				</div>
				<a href="javascript:void(0)" class="btn-adiciona">
			    	<i class="material-icons green md-48">add_circle</i>
			    </a> 
			<?php endif; ?>
			<p class="label-qtde">Itens Opcionais</p>
  			<select id='opcional' class='select-qtde mdl-shadow--4dp'>
  				<option value=""></option>
  				<?php foreach($opcionais as $opcional): ?>
  					<option value="<?=$opcional->id_opcional?>"><?=$opcional->descricao?> - R$ <?=number_format($opcional->valor, 2, ',', '.')?></option>
  				<?php endforeach; ?>
  			</select><br><br>
  			<p class="label-qtde">Observações Gravadas</p>
  			<select id='observacoes_gravadas' class='select-qtde mdl-shadow--4dp'>
  				<option value=""></option>
  				<?php foreach($observacoes as $observacao): ?>
  					<option value="<?=$observacao->observacao?>"><?=$observacao->observacao?></option>
  				<?php endforeach; ?>
  			</select>
			<div class="mdl-textfield mdl-js-textfield">
			  <textarea class="mdl-textfield__input" type="text" rows="3" id="observacoes"></textarea>
			  <label class="mdl-textfield__label" for="schools">Outras Observações</label>
			</div>
			<button data-id='<?= $mesa->mes_003?>' class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored confirma">
			  Gravar Item 
			  <i class="material-icons">add_circle</i>
		    </button>
		</div>
	  </div>
	</div>
	<dialog class="mdl-dialog">
	    <div class="mdl-dialog__content">
	      <p>
	      <h5>Gravar item na Mesa <?=$mesa?>?</h5>
	      <p><span class="red"><span class='qtde-venda'></span> - <?=$produto->mat_003?></span></p>
	      </p>
	    </div>
	    <div class="mdl-dialog__actions">
	      <button type="button" class="mdl-button close">Cancelar</button>
	      <button type="button" class="mdl-button mdl-button--raised mdl-button--colored pedido">Gravar</button>
	    </div>
	</dialog>
	<script src="js/jquery.min.js"></script>
	<script>

    var dialog = document.querySelector('dialog')
	if (! dialog.showModal) {
       dialogPolyfill.registerDialog(dialog);
    }

    jQuery(document).ready(function($) {	

    	$('.confirma').click(function(event) {
    		var qtde = $('#quantidade').val();

    		$('.qtde-venda').html(qtde);
		    dialog.showModal();
    	});

    	$('.close').click(function(event) {
    		dialog.close();
    	});

    	$('.pedido').click(function(event) { 
    		var qtde = $('#quantidade').val();
    		var obs      = $('#observacoes').val();
    		var obs2     = $('#observacoes_gravadas').val();
    		var opcional  = $('#opcional').val();
    		var tamanho  = $('#tamanho').val();

    		$.ajax({
    			url: 'gravar_item.php',
    			type: 'POST',
    			dataType: 'JSON',
    			data: {mesa: '<?=$mesa?>', comanda: '<?=$comanda?>', cliente: '<?=$cliente?>', produto: '<?=$cod_prod?>', qtde: qtde, obs: obs, obs2: obs2, opcional: opcional, tamanho: tamanho},
    			beforeSend: function(){
    				$('.pedido').html('Gravando ...');
    			},
    			success: function(retorno){
    				if (retorno.status == '1'){
    					if(retorno.tipo == 'M'){
    						window.location = 'pedido.php?mesa=<?=$mesa?>';
    					}else{
    						window.location = 'comanda.php?cliente=<?=$cliente?>&comanda='+retorno.comanda;
    					}
    				}else{
    					alert(retorno.erro);
    				}
    			}
    		});	

    	});

    	$('.btn-adiciona').click(function(event) {
    		var qtde = parseInt($('#quantidade').val());
    		
    		qtde += parseInt(1);
    		$('#quantidade').val(qtde);
    	});

    	$('.btn-subtrai').click(function(event) {
    		var qtde = parseInt($('#quantidade').val());

    		if (qtde > 1){
	    		qtde -= parseInt(1);
	    		$('#quantidade').val(qtde);	
    		}
    	});

    });
  </script>
</body>
</html>
