<?php
session_start();
require 'conexao.php';
require 'config.php';
require 'funcoes.php';


$json = (isset($_POST['pedido'])) ? $_POST['pedido'] : '' ;

if (empty($json)):
	echo json_encode(['status' => 0, 'mensagem' => 'Pedido não enviado !']);
	http_response_code(406);
	exit();
endif;

$pedido = json_decode($json);

$msg = '';
switch (json_last_error()) {
	case JSON_ERROR_DEPTH:
		$msg = ' - Maximum stack depth exceeded';
	break;
	case JSON_ERROR_STATE_MISMATCH:
		$msg = ' - Underflow or the modes mismatch';
	break;
	case JSON_ERROR_CTRL_CHAR:
		$msg = ' - Unexpected control character found';
	break;
	case JSON_ERROR_SYNTAX:
		$msg = ' - Syntax error, malformed JSON';
	break;
	case JSON_ERROR_UTF8:
		$msg = ' - Malformed UTF-8 characters, possibly incorrectly encoded';
	break;
}

if ($msg != ''):
	echo json_encode(['status' => 0, 'mensagem' => 'Erro no Pedido: ' . $msg]);
	http_response_code(406);
	exit();
endif;


if ($pedido->tipo == ''):
	echo json_encode(['status' => 0, 'mensagem' => 'Pedido sem canal de venda !']);
	http_response_code(406);
	exit();
endif;

if ($pedido->tipo == 'M' && ($pedido->id_mesa == '0' || $pedido->id_mesa == '')):
	echo json_encode(['status' => 0, 'mensagem' => 'Número da Mesa não informado !']);
	http_response_code(406);
	exit();
endif;

if ($pedido->id_atendente == ''):
	echo json_encode(['status' => 0, 'mensagem' => 'Pedido sem atendente !']);
	http_response_code(406);
	exit();
endif;

if (count($pedido->itens) == 0):
	echo json_encode(['status' => 0, 'mensagem' => 'Pedido sem itens !']);
	http_response_code(406);
	exit();
endif;

$invalido = false;
foreach($pedido->itens as $produto):
	if ($produto->quantidade == '' || $produto->quantidade == '0.000'):
		$invalido = true;
		break;
	endif;
endforeach;

if ($invalido):
	echo json_encode(['status' => 0, 'mensagem' => 'Existe(m) Produto(s) sem Quantidade !']);
	exit();
endif;

// GRAVA LOG DO PEDIDO
$canal = ($pedido->tipo == 'M') ? 'MESA ' . $pedido->controle : 'COMANDA ' . $pedido->controle;
$venda_log = (empty($pedido->venda)) ? -1 : $pedido->venda;
$sql = "INSERT INTO log_mobile (venda, canal, id_atendente, atendente, json, data_hora)VALUES(:venda, :canal, :id_atendente, :atendente, :json, :data_hora)";
$stm = $pdo->prepare($sql);
$stm->bindValue(':venda', $venda_log);
$stm->bindValue(':canal', $canal);
$stm->bindValue(':id_atendente', $pedido->id_atendente);
$stm->bindValue(':atendente', $pedido->atendente);
$stm->bindValue(':json', $json);
$stm->bindValue(':data_hora', date('Y-m-d H:i:s'));
$retorno = $stm->execute();

$venda       = $pedido->venda;
$tipo_venda  = $pedido->tipo ;
$pessoas     = $pedido->pessoas;
$cliente     = $pedido->cliente;
$usuario     = $pedido->id_atendente;
$mesa        = ($pedido->controle > 0 && $tipo_venda == 'M') ? $pedido->controle : '0' ;
$idMesa      = ($pedido->id_mesa > 0 && $tipo_venda == 'M') ? $pedido->id_mesa : '0' ;
$comanda     = ($pedido->controle > 0 && $tipo_venda == 'C') ? $pedido->controle : '0' ;
$pdo         = Conexao::getInstance();
$contErro    = 0;
$fracionado  = 0;
$aberturaVenda = true;
$hash_pedido = md5(date('YmdHis'));

try{

	if ($tipo_venda == 'M'):
		$sql = "SELECT ven_001 FROM venda WHERE ven_025 = {$idMesa} and sit_001 = 8 AND ven_024 = 'M'";
	elseif ($tipo_venda == 'C'):
		$sql = "SELECT ven_001 FROM venda WHERE ven_026 = {$comanda} and sit_001 = 8 AND ven_024 = 'C'";
	endif;
	$stm = $pdo->prepare($sql);
	$stm->execute();
	$existeVenda = $stm->fetch(PDO::FETCH_OBJ);

	$pdo->beginTransaction();

	// SENÃO NÃO ACHAR UMA VENDA ABERTA, GERA UM NÚMERO PARA NOVA VENDA
	if (empty($venda) && !$existeVenda):

		$aberturaVenda = true;
		$sql = 'SELECT (COALESCE(MAX(ven_001) ,0)+1) as venda FROM venda WHERE emp_001 = 1';
		$stm = $pdo->prepare($sql);
		$stm->execute();
		$contador = $stm->fetch(PDO::FETCH_OBJ);
		$id_venda = $contador->venda;
		$venda = $contador->venda;
		$itens    = 0;

		// SE FOR UMA VENDA DO TIPO COMANDA E ESTIVER CONFIGURADO PARA
		// GERAR O NÚMERO AUTOMATICAMENTE TAMBÉM GERA O NÚMERO DE COMANDA
		if ($tipo_venda == 'C' && TIPO_COMANDA == 0):
			$sql = 'SELECT (COALESCE(MAX(ven_026) ,0)+1) as comanda FROM venda WHERE sit_001 in (8, 21)';
			$stm = $pdo->prepare($sql);
			$stm->execute();
			$controle = $stm->fetch(PDO::FETCH_OBJ);
			$comanda = $controle->comanda;
		endif;

		// SELECIONA O ID DE ABERTURA PARA O FLUXO DE CAIXA ATUAL
		$sql = "SELECT id_caixa FROM caixa WHERE id_situacao = 4";
		$stm = $pdo->prepare($sql);
		$stm->execute();
		$caixa = $stm->fetch(PDO::FETCH_OBJ);

		$sql = 'INSERT INTO venda (ven_001, ven_002, emp_001, dat_001_1, ven_025, cli_001, sit_001, usu_001_1, ';
		$sql .= 'VEN_024, ven_029, ven_004, ven_023, id_caixa_abertura, ven_026, terminal_abertura, ven_027, nro_pessoas)';
		$sql .= 'VALUES(:id_venda, 0, :emp, LOCALTIMESTAMP, :id_mesa, 0, 8, :id_usuario, ';
		$sql .= ":tipo_venda, :id_venda2, LOCALTIMESTAMP, 'N', :id_caixa_abertura, :comanda, :terminal_abertura, :nome_cliente, :nro_pessoas)";
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':id_venda', $id_venda);
		$stm->bindValue(':emp', 1);
		$stm->bindValue(':id_mesa', (int) $idMesa);
		$stm->bindValue(':id_usuario', (int) $usuario);
		$stm->bindValue(':tipo_venda', $tipo_venda);
		$stm->bindValue(':id_venda2', $id_venda);
		$stm->bindValue(':id_caixa_abertura', (int) $caixa->id_caixa);
		$stm->bindValue(':comanda', $comanda);
		$stm->bindValue(':terminal_abertura', 'MOBILE');
		$stm->bindValue(':nome_cliente', $cliente);
		$stm->bindValue(':nro_pessoas', $pessoas);
		$stm->execute();

	else:
		$venda = $existeVenda->ven_001;

		$aberturaVenda = false;
		$sql = 'SELECT MAX(ite_001) as itens FROM vendaitem WHERE ven_001 = :venda';
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':venda', $venda);
		$stm->execute();
		$item = $stm->fetch(PDO::FETCH_OBJ);

		$itens    = $item->itens;
		$id_venda = $venda;
	endif;

	// PERCORRE TODOS OS ITENS EM SESSION E PROCESSA A GRAVAÇÃO NO BANCO
	// foreach($_SESSION['PEDIDO'] as $itemPedido):
	foreach($pedido->itens as $itemPedido):

		$sql = 'SELECT mat_001, mat_021, COALESCE(valor_tam_p, 0) AS valor_tam_p, COALESCE(valor_tam_m, 0) AS valor_tam_m, b_venda_tamanho, ';
		$sql .= 'COALESCE(valor_tam_g, 0) AS valor_tam_g, COALESCE(valor_tam_gg, 0) AS valor_tam_gg, COALESCE(valor_tam_extra, 0) AS valor_tam_extra ';
		$sql .= ', mat_008 FROM materiais ';
		$sql .= 'WHERE mat_004 = :produto AND sit_001 = 4';
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':produto', $itemPedido->codigo);
		$stm->execute();
		$produto = $stm->fetch(PDO::FETCH_OBJ);

		if ($itemPedido->vende_tamanho):
			switch ($itemPedido->tamanho_pedido) :
				case 'P':
					$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'P', $tipo_venda);
					break;
				case 'M':
					$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'M', $tipo_venda);
					break;
				case 'G':
					$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'G', $tipo_venda);
					break;
				case 'GG':
					$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'GG', $tipo_venda);
					break;
				case 'E':
					$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'E', $tipo_venda);
					break;
			endswitch;
		else:
			$valor_unitario = CapturaValorNormalOuPromocao($produto->mat_001, 'M', $tipo_venda);
		endif;

		$tamanho = ($itemPedido->vende_tamanho) ? $itemPedido->tamanho_pedido : 'M';
		$valor_sem_promocao = CapturaValorNormal($produto->mat_001, $tamanho, $tipo_venda); 
		$id_promocao = CapturaIdPromocao($produto->mat_001, $tamanho, $tipo_venda);
		$valor_caculo_item = $valor_unitario;
		$fracionado = null;

		// VERIFICA SE É QUANTIDADE FRACIONADA
		if ( $itemPedido->quantidade < 1 && 
			!$itemPedido->vende_balanca &&
			$itemPedido->vende_fracionado ):

			// SELECIONA O MAIOR ITEM QUE FOI FRACIONADO NA VENDA
			$sql = 'SELECT COALESCE(MAX(item_fracionado), 0) AS item_fracionado FROM vendaitem ';
			$sql .= 'WHERE ven_001 =:venda AND sit_001 = 4 AND (item_fracionado IS NOT NULL AND item_fracionado > 0) ';
			$stm = $pdo->prepare($sql);
			$stm->bindValue(':venda', $id_venda);
			$stm->execute();
			$ultimo_fracionado = $stm->fetch(PDO::FETCH_OBJ);

			if ($ultimo_fracionado->item_fracionado == 0):
				$fracionado = 1;
			else:
				// SOMA A QUANTIDADE DOS ÚLTIMO ITENS FRACIONADOS E VERIFICA SE A SOMA DÁ UM INTEIRO
				$sql = 'SELECT COALESCE(TRUNC(SUM(ite_002), 1),0) as total FROM vendaitem ';
				$sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado AND sit_001 = 4';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':venda', $id_venda);
				$stm->bindValue(':fracionado', $ultimo_fracionado->item_fracionado);
				$stm->execute();
				$qtde_fracionada = $stm->fetch(PDO::FETCH_OBJ);

				if ($qtde_fracionada->total >= 0.9):
					$fracionado = $ultimo_fracionado->item_fracionado + 1;
				else:
					$fracionado = $ultimo_fracionado->item_fracionado;
				endif;

				if (COBRAR_MAIOR_VALOR_FRACIONADO):

					// SELECIONA O MAIOR VALOR ENTRE OS ITENS FRACIONADOS DO MESMO PEDIDO
					$sql = 'SELECT COALESCE(ite_003, 0.0) as maior_valor FROM vendaitem ';
					$sql .= 'WHERE ven_001 =:venda AND item_fracionado =:fracionado AND sit_001 = 4 ';
					$sql .= 'ORDER BY ite_003 DESC LIMIT 1';
					$stm = $pdo->prepare($sql);
					$stm->bindValue(':venda', $id_venda);
					$stm->bindValue(':fracionado', $fracionado);
					$stm->execute();
					$totalizador = $stm->fetch(PDO::FETCH_OBJ);

					if (!empty($totalizador) && $totalizador->maior_valor > $valor_caculo_item):
						$valor_caculo_item = $totalizador->maior_valor;
					endif;

					// ATUALIZA AS FRAÇÕES COM O VALOR DA MAIOR PIZZA
					if (!empty($totalizador)):
						$sql = 'UPDATE vendaitem SET ite_005 = :valor + COALESCE(acrescimo, 0.0) ';
						$sql .= 'WHERE ven_001 =:venda AND item_fracionado =:item ';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':valor', ( $itemPedido->quantidade * $valor_caculo_item ));
						$stm->bindValue(':venda', $id_venda);
						$stm->bindValue(':item', $fracionado);
						$stm->execute();
					endif;

				endif;

			endif;
		endif;

		$observacao = '';
		if (!empty($itemPedido->observacao) && !empty($itemPedido->opcao_observacao)):
			$observacao = $itemPedido->observacao . ', ' . $itemPedido->opcao_observacao;
		elseif (!empty($itemPedido->observacao)):
			$observacao = $itemPedido->observacao;
		elseif (!empty($itemPedido->opcao_observacao)):
			$observacao = $itemPedido->opcao_observacao;
		endif;

		$impressora = $itemPedido->impressora;

		$sql = 'SELECT COALESCE(MAX(ite_001), 0) as itens FROM vendaitem WHERE ven_001 = :venda';
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':venda', $id_venda);
		$stm->execute();
		$item  = $stm->fetch(PDO::FETCH_OBJ);
		$itens = $item->itens;
		$itens++;

		// VERIFICA SE FOI ADICIONADO CATEGORIA COM DESCONTO
		$sql = 'SELECT m.cat_001 FROM categoria c INNER JOIN materiais m ON c.cat_001 = m.cat_001 ';
		$sql .= 'WHERE nao_totaliza_cupom AND mat_001 = :codigo';
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':codigo', $itemPedido->id);
		$stm->execute();
		$categoria_desconto  = $stm->fetch(PDO::FETCH_OBJ);
		$desconto = (empty($categoria_desconto)) ? 0 : ($itemPedido->quantidade * $valor_caculo_item); 
		$valor_caculo_item = (empty($categoria_desconto)) ? $valor_caculo_item : 0; 

		$sql = 'INSERT INTO vendaitem ';
		$sql .= '(emp_001, ven_001, mat_001, ite_002, ite_003, ite_005, ite_006, ite_009, ite_001, gar_001, ';
		$sql .= 'ite_013, ite_012, sit_001, ite_011, ite_008, tamanho, b_venda_tamanho, item_fracionado,';
		$sql .= 'quantidade_impressao, origem_pedido, mobile_impressao, id_promocao, valor_sem_promocao, desconto, hash_pedido)VALUES ';
		$sql .= '(:emp, :id_venda, :id_material, :quantidade, :valor_unit, :valor_total, :observacao, :hora, :nro_item, ';
		$sql .= ":id_garcom, :cod_impressora, 'N', 4, 'S', 'N', :tamanho, :b_venda_tamanho, :item_fracionado, :quantidade_impressao, ";
		$sql .= "'M', 'N', :id_promocao, :valor_sem_promocao, :desconto, :hash_pedido)";
		$stm = $pdo->prepare($sql);
		$stm->bindValue(':emp', '1');
		$stm->bindValue(':id_venda', $id_venda);
		$stm->bindValue(':id_material', $itemPedido->id);
		$stm->bindValue(':quantidade', $itemPedido->quantidade);
		$stm->bindValue(':valor_unit', $valor_unitario);
		$stm->bindValue(':valor_total', ($itemPedido->quantidade * $valor_caculo_item));
		$stm->bindValue(':observacao', $observacao);
		$stm->bindValue(':hora', date('H:i:s'));
		$stm->bindValue(':nro_item', $itens);
		$stm->bindValue(':id_garcom', $usuario);
		$stm->bindValue(':cod_impressora', $impressora);
		$stm->bindValue(':tamanho', $itemPedido->tamanho_pedido);
		$stm->bindValue(':b_venda_tamanho', (int) $itemPedido->vende_tamanho);
		$stm->bindValue(':item_fracionado', $fracionado);
		$stm->bindValue(':quantidade_impressao', $itemPedido->quantidade);
		$stm->bindValue(':id_promocao', $id_promocao);
		$stm->bindValue(':valor_sem_promocao', $valor_sem_promocao);
		$stm->bindValue(':desconto', $desconto);
		$stm->bindValue(':hash_pedido', $hash_pedido);
		$retorno = $stm->execute();

		$valor_caculo_item = 0;

		if(!empty($itemPedido->opcional)):
			$sql = 'SELECT MAX(ite_001) as ultimo_item FROM vendaitem WHERE ven_001 = :venda';
			$stm = $pdo->prepare($sql);
			$stm->bindValue(':venda', $id_venda);
			$stm->execute();
			$item = $stm->fetch(PDO::FETCH_OBJ);

			foreach($itemPedido->opcional as $opcional):
				$sql = 'SELECT valor FROM opcional WHERE id_opcional = :opcional';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':opcional', $opcional->id_opcional);
				$stm->execute();
				$item_opcional = $stm->fetch(PDO::FETCH_OBJ);

				$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional, unitario_fracao, imprime_completo, quantidade, valor)VALUES';
				$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional, :unitario_fracao, :imprime_completo, :quantidade, :valor)';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':id_venda', $id_venda);
				$stm->bindValue(':id_vendaitem', $item->ultimo_item);
				$stm->bindValue(':id_opcional', $opcional->id_opcional);
				$stm->bindValue(':unitario_fracao', (int) $opcional->fracao);
				$stm->bindValue(':imprime_completo', (int) $opcional->completo);
				$stm->bindValue(':quantidade', (int) ($opcional->quantidade * $itemPedido->quantidade));
				$stm->bindValue(':valor', (($opcional->quantidade * $itemPedido->quantidade) * $item_opcional->valor));
				$stm->execute();
				$opcional = $stm->fetch(PDO::FETCH_OBJ);
			endforeach;
		endif;

		if(!empty($itemPedido->pacote)):
			$sql = 'SELECT MAX(ite_001) as ultimo_item FROM vendaitem WHERE ven_001 = :venda';
			$stm = $pdo->prepare($sql);
			$stm->bindValue(':venda', $id_venda);
			$stm->execute();
			$item = $stm->fetch(PDO::FETCH_OBJ);

			foreach($itemPedido->pacote as $pacote):
				
				if ( $pacote->tipo == 'O' && $pacote->valor > 0 ):
					$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional, unitario_fracao, imprime_completo, quantidade, valor)VALUES';
					$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional, :unitario_fracao, :imprime_completo, :quantidade, :valor)';
					$stm = $pdo->prepare($sql);
					$stm->bindValue( ':id_venda', $id_venda );
					$stm->bindValue( ':id_vendaitem', $item->ultimo_item );
					$stm->bindValue( ':id_opcional', $pacote->id );
					$stm->bindValue( ':unitario_fracao', (int) 0 );
					$stm->bindValue( ':imprime_completo', 0 );
					$stm->bindValue( ':quantidade', (int) ($pacote->quantidade * $itemPedido->quantidade) );
					$stm->bindValue( ':valor', (($pacote->quantidade * $itemPedido->quantidade) * $pacote->valor) );
					$stm->execute();
				else:
					$sql = 'INSERT INTO vendaitem_pacote (id_venda, id_item, id_registro, tipo, descricao, quantidade, valor, tamanho)VALUES';
					$sql .= '(:id_venda, :id_item, :id_registro, :tipo, :descricao, :quantidade, :valor, :tamanho)';
					$stm = $pdo->prepare($sql);
					$stm->bindValue(':id_venda', $id_venda);
					$stm->bindValue(':id_item', $item->ultimo_item);
					$stm->bindValue(':id_registro', $pacote->id);
					$stm->bindValue(':tipo', $pacote->tipo);
					$stm->bindValue(':descricao', $pacote->descricao);
					$stm->bindValue(':quantidade', ($pacote->quantidade * $itemPedido->quantidade));
					$stm->bindValue(':valor', $pacote->valor);
					$stm->bindValue(':tamanho', 'M');
					$stm->execute();
				endif;

			endforeach;
		endif;

		// ACERTA OS ITENS OPCIONAIS PARA OS CASOS DE ITENS FRACIONADOS
		if ($fracionado != null):

			$sql = 'SELECT ite_001, ite_002 FROM vendaitem ';
			$sql .= 'WHERE ven_001 = :id_venda AND item_fracionado = :fracionado AND sit_001 = 4 ';
			$sql .= 'ORDER BY ite_001';
			$stm = $pdo->prepare($sql);
			$stm->bindValue(':id_venda', $id_venda);
			$stm->bindValue(':fracionado', $fracionado);
			$stm->execute();
			$itens_fracionado = $stm->fetchAll(PDO::FETCH_OBJ);

			foreach($itens_fracionado as $item):

				$sql = 'SELECT id_opcional, id_vendaitem, imprime_completo FROM vendaitemopcional o INNER JOIN vendaitem i ';
				$sql .= 'ON (o.id_vendaitem = i.ite_001 AND o.id_venda = i.ven_001) ';
				$sql .= 'WHERE id_venda = :id_venda AND item_fracionado = :fracionado AND sit_001 = 4 ';
				$sql .= 'AND not o.unitario_fracao ORDER BY ite_001';
				$stm = $pdo->prepare($sql);
				$stm->bindValue(':id_venda', $id_venda);
				$stm->bindValue(':fracionado', $fracionado);
				$stm->execute();
				$opcionais = $stm->fetchAll(PDO::FETCH_OBJ);

				foreach($opcionais as $opcional):
					$sql = 'SELECT id_venda FROM vendaitemopcional ';
					$sql .= 'WHERE id_venda = :id_venda AND id_vendaitem = :id_vendaitem AND id_opcional = :id_opcional';
					$stm = $pdo->prepare($sql);
					$stm->bindValue(':id_venda', $id_venda);
					$stm->bindValue(':id_vendaitem', $item->ite_001);
					$stm->bindValue(':id_opcional', $opcional->id_opcional);
					$stm->execute();
					$valida_opcional = $stm->fetch(PDO::FETCH_OBJ);

					if (empty($valida_opcional)):
						$sql = 'SELECT valor FROM opcional WHERE id_opcional = :opcional';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':opcional', $opcional->id_opcional);
						$stm->execute();
						$item_opcional = $stm->fetch(PDO::FETCH_OBJ);

						$sql = 'INSERT INTO vendaitemopcional (id_venda, id_empresa, id_vendaitem, id_opcional, imprime_completo)VALUES';
						$sql .= '(:id_venda, 1, :id_vendaitem, :id_opcional, :imprime_completo)';
						$stm = $pdo->prepare($sql);
						$stm->bindValue(':id_venda', $id_venda);
						$stm->bindValue(':id_vendaitem', $item->ite_001);
						$stm->bindValue(':id_opcional', $opcional->id_opcional);
						$stm->bindValue(':imprime_completo', $opcional->imprime_completo);
						$stm->execute();
					endif;

				endforeach;

			endforeach;

		endif;

	endforeach;


	// ATUALIZA DOS TOTALIZADORES DA VENDA | VALORES DOS ACRÉSCIMOS NOS ITENS | VALORES UNITÁRIOS DOS ITENS
	$sql = 'SELECT fn_calcula_total_venda(:idvenda, :idempresa)';
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':idvenda', $id_venda);
	$stm->bindValue(':idempresa', 1);
	$stm->execute();

	// ATUALIZA PENDÊNCIA DE IMPRESSÃO
	$sql = "UPDATE vendaitem SET mobile_impressao = 'S' WHERE ven_001 = :venda AND origem_pedido = 'M' AND mobile_impressao = 'N'";
	$stm = $pdo->prepare($sql);
	$stm->bindValue(':venda', $id_venda);
	$retorno = $stm->execute();

	echo json_encode(['status' => 1]);

	$pdo->Commit();

	$_SESSION['VENDA']   = $id_venda;
	$_SESSION['TIPO']    = $tipo_venda;
	$_SESSION['CLIENTE'] = $cliente;

}catch(Exception $erro){
	$pdo->rollBack();
	echo json_encode(['status' => 0, 'mensagem' => $erro->getMessage()]);
}

